/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.annotations.NiagaraOrionType;
import com.tridiumx.accessDriver.BAccessFloor;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BMappedFloorExt;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType(agent={@AgentOn(types={"accessDriver:AccessFloor"})})
@NiagaraOrionType
@NiagaraProperties(value={@NiagaraProperty(name="uuid", type="BUuid", defaultValue="BUuid.NULL", facets={@Facet(name="KEY", value="true")}), @NiagaraProperty(name="floorName", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="128"), @Facet(name="DISPLAY_ID", value="true")}), @NiagaraProperty(name="elevatorName", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="128"), @Facet(name="DISPLAY_ID", value="true")}), @NiagaraProperty(name="stationName", type="String", defaultValue="", flags=8, facets={@Facet(name="WIDTH", value="64"), @Facet(name="INDEXED", value="true")}), @NiagaraProperty(name="floorDisplayPath", type="String", defaultValue="", facets={@Facet(name="WIDTH", value="256")})})
public class BAccFloorRec
extends BReplicableObject
implements BIOrdMappable {
    @Generated
    public static final Property uuid = BAccFloorRec.newProperty((int)0, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    @Generated
    public static final Property floorName = BAccFloorRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    @Generated
    public static final Property elevatorName = BAccFloorRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    @Generated
    public static final Property stationName = BAccFloorRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    @Generated
    public static final Property floorDisplayPath = BAccFloorRec.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"width", (int)256));
    @Generated
    public static final Type TYPE = Sys.loadType(BAccFloorRec.class);
    @Generated
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    private static final BIcon ICON = BAccessFloor.ICON;

    @Generated
    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    @Generated
    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    @Generated
    public String getFloorName() {
        return this.getString(floorName);
    }

    @Generated
    public void setFloorName(String v) {
        this.setString(floorName, v, null);
    }

    @Generated
    public String getElevatorName() {
        return this.getString(elevatorName);
    }

    @Generated
    public void setElevatorName(String v) {
        this.setString(elevatorName, v, null);
    }

    @Override
    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Generated
    public String getFloorDisplayPath() {
        return this.getString(floorDisplayPath);
    }

    @Generated
    public void setFloorDisplayPath(String v) {
        this.setString(floorDisplayPath, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public void mapFrom(BObject source) {
        BAccessFloor floor = (BAccessFloor)source;
        BMappedFloorExt ext = (BMappedFloorExt)floor.getMixIn(BMappedFloorExt.TYPE);
        this.setUuid(ext.getUuid());
        this.setLastModified(BAbsTime.now());
        this.setStationName(Sys.getStation().getStationName());
        if (floor.isRunning()) {
            this.setElevatorName(floor.getParent().getDisplayName(null));
            String displayName = floor.getDisplayName(null);
            if (displayName != null) {
                this.setFloorName(displayName);
            } else if (floor.getName() != null) {
                this.setFloorName(floor.getName());
            } else {
                throw new IllegalStateException("need a name when is running");
            }
            this.setSlotPathOrd(source);
        }
    }

    @Override
    public BOrd getMappedOrd() {
        return MappingSupport.getMappedOrd(this);
    }

    @Override
    public void setSlotPathOrd(BObject source) {
        this.setFloorDisplayPath(MappingSupport.getDisplayPath(source));
    }

    @Override
    public String getMappedDisplayPath() {
        return this.getFloorDisplayPath();
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    public String toDisplayString(Context cx) {
        return this.getStationName() + ":" + this.getElevatorName() + "." + this.getFloorName();
    }

    public String toDisplayString() {
        return this.getStationName() + ":" + this.getElevatorName() + "." + this.getFloorName();
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertFloorRec(this);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateFloorRec(this);
    }

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteFloorRec(this);
    }

    public BIcon getIcon() {
        return ICON;
    }
}

