/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access;

import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessStrike;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.entsec.access.BAccessControlService;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="inputSource", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=8, facets={@Facet(name="BFacets.TRUE_TEXT", value="BAccessControlService.lex.getText(\"active\")"), @Facet(name="BFacets.FALSE_TEXT", value="BAccessControlService.lex.getText(\"inactive\")"), @Facet(name="BFacets.FIELD_EDITOR", value="\"entsec:PointLinkChooserFE\"")}), @NiagaraProperty(name="unlockState", type="BStatusBoolean", defaultValue="new BStatusBoolean(false)", flags=9, facets={@Facet(name="BFacets.TRUE_TEXT", value="BAccessControlService.lex.getText(\"unlockInput.unlock\")"), @Facet(name="BFacets.FALSE_TEXT", value="BAccessControlService.lex.getText(\"unlockInput.lock\")")}), @NiagaraProperty(name="requiresApplicationReset", type="boolean", defaultValue="true", flags=8), @NiagaraProperty(name="followInputOnReset", type="boolean", defaultValue="true", flags=8), @NiagaraProperty(name="waitingOnApplicationReset", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="waitingOnInputSourceToGoFalse", type="boolean", defaultValue="false", flags=4)})
@NiagaraAction(name="reset")
public class BUnlockInput
extends BComponent {
    @Generated
    public static final Property inputSource = BUnlockInput.newProperty((int)8, (BValue)new BStatusBoolean(), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)BAccessControlService.lex.getText("active")), (BFacets)BFacets.make((String)"falseText", (String)BAccessControlService.lex.getText("inactive"))), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:PointLinkChooserFE")));
    @Generated
    public static final Property unlockState = BUnlockInput.newProperty((int)9, (BValue)new BStatusBoolean(false), (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)BAccessControlService.lex.getText("unlockInput.unlock")), (BFacets)BFacets.make((String)"falseText", (String)BAccessControlService.lex.getText("unlockInput.lock"))));
    @Generated
    public static final Property requiresApplicationReset = BUnlockInput.newProperty((int)8, (boolean)true, null);
    @Generated
    public static final Property followInputOnReset = BUnlockInput.newProperty((int)8, (boolean)true, null);
    @Generated
    public static final Property waitingOnApplicationReset = BUnlockInput.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property waitingOnInputSourceToGoFalse = BUnlockInput.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Action reset = BUnlockInput.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BUnlockInput.class);
    private BAccessStrike[] strikes;
    private static BRelTime permanent = BRelTime.make((long)BAbsTime.END_OF_TIME.getMillis());
    private Object monitor = new Object();
    private static Lexicon lex = Lexicon.make((String)"entsec");
    private boolean inputValue = false;

    @Generated
    public BStatusBoolean getInputSource() {
        return (BStatusBoolean)this.get(inputSource);
    }

    @Generated
    public void setInputSource(BStatusBoolean v) {
        this.set(inputSource, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getUnlockState() {
        return (BStatusBoolean)this.get(unlockState);
    }

    @Generated
    public void setUnlockState(BStatusBoolean v) {
        this.set(unlockState, (BValue)v, null);
    }

    @Generated
    public boolean getRequiresApplicationReset() {
        return this.getBoolean(requiresApplicationReset);
    }

    @Generated
    public void setRequiresApplicationReset(boolean v) {
        this.setBoolean(requiresApplicationReset, v, null);
    }

    @Generated
    public boolean getFollowInputOnReset() {
        return this.getBoolean(followInputOnReset);
    }

    @Generated
    public void setFollowInputOnReset(boolean v) {
        this.setBoolean(followInputOnReset, v, null);
    }

    @Generated
    public boolean getWaitingOnApplicationReset() {
        return this.getBoolean(waitingOnApplicationReset);
    }

    @Generated
    public void setWaitingOnApplicationReset(boolean v) {
        this.setBoolean(waitingOnApplicationReset, v, null);
    }

    @Generated
    public boolean getWaitingOnInputSourceToGoFalse() {
        return this.getBoolean(waitingOnInputSourceToGoFalse);
    }

    @Generated
    public void setWaitingOnInputSourceToGoFalse(boolean v) {
        this.setBoolean(waitingOnInputSourceToGoFalse, v, null);
    }

    @Generated
    public void reset() {
        this.invoke(reset, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStrikes() {
        Object object = this.monitor;
        synchronized (object) {
            Knob[] knobs = this.getKnobs((Slot)unlockState);
            this.strikes = new BAccessStrike[knobs.length];
            for (int i = 0; i < knobs.length; ++i) {
                this.strikes[i] = (BAccessStrike)knobs[i].getTargetComponent();
            }
        }
    }

    public void startedAndStationStarted() {
        this.inputValue = this.getInputSource().getValue();
        boolean justUnlocked = this.handleOutput(null);
        if (!justUnlocked && this.getUnlockState().getValue()) {
            this.unlockStrikes(null);
        }
    }

    public void started() throws Exception {
        super.started();
        if (Sys.isStationStarted()) {
            this.startedAndStationStarted();
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.startedAndStationStarted();
    }

    public void changed(Property property, Context context) {
        boolean newInputValue;
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(requiresApplicationReset)) {
            if (!this.getRequiresApplicationReset()) {
                this.setFlags((Slot)followInputOnReset, this.getFlags((Slot)followInputOnReset) | 4);
                if (this.getWaitingOnApplicationReset() || this.getWaitingOnInputSourceToGoFalse()) {
                    this.handleOutput(context);
                }
                this.setWaitingOnApplicationReset(false);
                this.setWaitingOnInputSourceToGoFalse(false);
            } else {
                this.setFlags((Slot)followInputOnReset, this.getFlags((Slot)followInputOnReset) & 0xFFFFFFFB);
            }
        } else if (property.equals(inputSource) && (newInputValue = this.getInputSource().getValue()) != this.inputValue) {
            this.inputValue = newInputValue;
            this.handleOutput(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doReset(Context cx) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.getWaitingOnApplicationReset()) {
                this.setWaitingOnApplicationReset(false);
                if (!this.getFollowInputOnReset()) {
                    this.restoreStrikes(true, cx);
                } else if (!this.getInputSource().getValue()) {
                    this.restoreStrikes(true, cx);
                } else {
                    this.setWaitingOnInputSourceToGoFalse(true);
                }
            }
        }
    }

    private boolean handleOutput(Context cx) {
        if (this.getInputSource().getValue() && !this.getUnlockState().getValue()) {
            this.unlockStrikes(cx);
            if (this.getRequiresApplicationReset()) {
                this.setWaitingOnApplicationReset(true);
            }
            return true;
        }
        if (!this.getInputSource().getValue() && this.getUnlockState().getBoolean() && (!this.getRequiresApplicationReset() || this.getWaitingOnInputSourceToGoFalse())) {
            this.restoreStrikes(this.getWaitingOnInputSourceToGoFalse(), cx);
            this.setWaitingOnInputSourceToGoFalse(false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockStrikes(Context cx) {
        Object object = this.monitor;
        synchronized (object) {
            this.setUnlockState(new BStatusBoolean(true));
            this.loadStrikes();
            for (int i = 0; i < this.strikes.length; ++i) {
                this.strikes[i].doEmergencyActive();
                this.strikes[i].fireInhibitAlarm(permanent);
                this.logDoorUnlocked(this.strikes[i], cx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreStrikes(boolean isReset, Context cx) {
        Object object = this.monitor;
        synchronized (object) {
            this.setUnlockState(new BStatusBoolean(false));
            this.loadStrikes();
            for (int i = 0; i < this.strikes.length; ++i) {
                if (this.strikes[i] == null) continue;
                this.strikes[i].doEmergencyAuto();
                BAccessDoor door = (BAccessDoor)this.strikes[i].getParent();
                if (door == null || door.getSensor() == null) continue;
                door.getSensor().stopInhibit();
                this.logDoorNormal(isReset, this.strikes[i], cx);
            }
        }
    }

    private void logDoorUnlocked(BAccessStrike strike, Context cx) {
        if (strike == null || strike.getParent() == null || cx == null) {
            return;
        }
        BAccessDoor door = (BAccessDoor)strike.getParent().asComponent();
        BAccessControlService accessControlService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        String authority = this.getAuthority(cx);
        accessControlService.accessAudit((BComponent)door, BBadgeActivity.unlockInput, authority, lex.getText("unlockInput.doorUnlocked", new Object[]{this.formatDescription(door)}), true);
    }

    private void logDoorNormal(boolean isReset, BAccessStrike strike, Context cx) {
        if (strike == null || strike.getParent() == null || cx == null) {
            return;
        }
        BAccessDoor door = (BAccessDoor)strike.getParent().asComponent();
        BAccessControlService accessControlService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        String format = this.formatDescription(door);
        String authority = this.getAuthority(cx);
        accessControlService.accessAudit((BComponent)door, BBadgeActivity.unlockInput, authority, isReset ? lex.getText("unlockInput.manualReset", new Object[]{format}) : lex.getText("unlockInput.doorNormal", new Object[]{format}), true);
    }

    private String getAuthority(Context cx) {
        String authority = "Unknown";
        BUser user = cx.getUser();
        if (user != null) {
            authority = "User: " + user.getUsername();
        } else {
            BLink[] links = this.getLinks((Slot)inputSource);
            if (links.length > 0) {
                BComponent inputPoint = links[0].getSourceComponent();
                BComplex parent = inputPoint.getParent();
                authority = parent.getDisplayName(cx) + "." + inputPoint.getDisplayName(cx);
            }
        }
        return authority;
    }

    private String formatDescription(BAccessDoor door) {
        if (door == null || door.getDevice() == null) {
            return "";
        }
        if (door.getStrike() != null) {
            return door.getDevice().getDisplayName(null) + ":" + door.getDisplayName(null) + ":" + door.getStrike().getDisplayName(null);
        }
        return door.getDevice().getDisplayName(null) + ":" + door.getDisplayName(null);
    }

    public BIcon getIcon() {
        return BIcon.std((String)"lock.png");
    }
}

