/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.AccessControlConst;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BKeypadFormat;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;

public abstract class AccessUtil
implements AccessControlConst {
    public static final String handlePrefix = "station:|h:";

    public static String text(String text) {
        return BAccessControlService.lex.getText(text);
    }

    public static String text(String text, Object[] params) {
        return BAccessControlService.lex.getText(text, params);
    }

    public static String getAlarmDescription(BAlarmSourceExt ext) {
        String text = TextUtil.toFriendly((String)ext.getParent().getName());
        String offNormalText = ext.getToOffnormalText().format((Object)ext);
        String faultText = ext.getToFaultText().format((Object)ext);
        if (offNormalText.length() > 0) {
            text = text + "." + offNormalText;
        } else if (faultText.length() > 0) {
            text = text + "." + faultText;
        }
        return text;
    }

    public static BComponent getComponent(String handle) {
        if (handle == null) {
            return null;
        }
        String ordString = handlePrefix + handle;
        try {
            BObject object = BOrd.make((String)ordString).get();
            if (object.isComponent()) {
                return (BComponent)object;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void ensureDefaults(OrionSession session) {
        AccessUtil.ensureDefaultWiegandFormats(session);
        AccessUtil.ensureDefaultKeypadFormats(session);
        BAccessZoneRec.recountCache(session);
    }

    public static void ensureDefaultWiegandFormats(OrionSession session) {
        OrionCursor c = session.scan(BWiegandFormat.ORION_TYPE);
        if (!c.next()) {
            for (int i = 0; i < DEFAULT_WIEGAND_FORMATS.length; ++i) {
                session.insert((BIOrionObject)DEFAULT_WIEGAND_FORMATS[i]);
            }
        }
    }

    public static void ensureDefaultKeypadFormats(OrionSession session) {
        OrionCursor c = session.scan(BKeypadFormat.ORION_TYPE);
        if (!c.next()) {
            for (int i = 0; i < DEFAULT_KEYPAD_FORMATS.length; ++i) {
                session.insert((BIOrionObject)DEFAULT_KEYPAD_FORMATS[i]);
            }
        }
    }
}

