/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BOrionType;
import com.tridium.orion.OrionType;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import javax.baja.naming.BOrd;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.security.PermissionException;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public abstract class PermissionsUtil {
    public static boolean canReadOrion(Context cx) {
        return PermissionsUtil.canReadOrion(null, cx);
    }

    public static boolean canReadOrion(BObject base, Context cx) {
        try {
            BOrionSpace orionSpace = (BOrionSpace)BOrd.make((String)"orion:").get(base);
            return orionSpace.getPermissions(cx).has(BPermissions.operatorRead);
        }
        catch (InvalidOrdBaseException e) {
            return false;
        }
    }

    public static boolean canReadOrionType(OrionType orionType, BOrionDatabase db, Context cx) {
        if (!PermissionsUtil.isLicensed(orionType)) {
            return false;
        }
        try {
            BOrionType bOrionType = db.getType(orionType);
            return bOrionType.getPermissions(cx).has(BPermissions.operatorRead);
        }
        catch (InvalidOrdBaseException e) {
            return false;
        }
    }

    public static boolean canAdminReadOrionType(OrionType orionType, BOrionDatabase db, Context cx) {
        if (!PermissionsUtil.isLicensed(orionType)) {
            return false;
        }
        try {
            BOrionType bOrionType = db.getType(orionType);
            return bOrionType.getPermissions(cx).has(BPermissions.adminRead);
        }
        catch (InvalidOrdBaseException e) {
            return false;
        }
    }

    public static boolean canWriteOrionType(OrionType orionType, BOrionDatabase db, Context cx) {
        if (!PermissionsUtil.isLicensed(orionType)) {
            return false;
        }
        try {
            BOrionType bOrionType = db.getType(orionType);
            return bOrionType.getPermissions(cx).has(BPermissions.adminWrite);
        }
        catch (InvalidOrdBaseException e) {
            return false;
        }
    }

    public static boolean isLicensed(OrionType orionType) {
        return !orionType.equals(BThreatLevelGroupRec.ORION_TYPE) || BEnterpriseSecurityService.isThreatAvailable();
    }

    public static boolean hasEnoughPermissions(BPermissionsMap map, Context cx) {
        if (cx == null || cx.getUser() == null) {
            return true;
        }
        BPermissionsMap cxUserPermissions = cx.getUser().getPermissions();
        return map.equals((Object)cxUserPermissions.and(map));
    }

    public static void checkEnoughPermissions(BPermissionsMap map, Context cx) {
        if (!PermissionsUtil.hasEnoughPermissions(map, cx)) {
            if (map.isSuperUser()) {
                throw new PermissionException("User not have Super User Permissions");
            }
            throw new PermissionException("User not have enough Permissions");
        }
    }
}

