/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseManager;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class LicenseChecker {
    private static final LicenseChecker INSTANCE = new LicenseChecker();
    protected static final LicenseManager licenseManager = Sys.getLicenseManager();
    protected static final int EMPTY_FLAGS = 0;
    protected static final Logger log = Logger.getLogger("entsec.licenseCheck");
    private static Array<Tuple> tupleArray = new Array(Tuple.class);
    private static Set<Slot> unlicensedSlots = new HashSet<Slot>();
    public static final String NO_ATTRIBUTE_KEY = "";
    public static final String NO_ATTRIBUTE_VALUE = "";

    public static LicenseChecker getChecker() {
        return INSTANCE;
    }

    public void check() {
        int licenseFailureCount = 0;
        Array requiredFeatures = new Array(String.class);
        Array requiredAttributes = new Array(String.class);
        log.info("Checking license restrictions");
        Tuple[] tuples = (Tuple[])tupleArray.trim();
        for (int i = 0; i < tuples.length; ++i) {
            int j;
            Tuple tuple = tuples[i];
            BComplex parent = tuple.parent();
            Slot[] slots = tuple.slots();
            String vendor = tuple.vendor();
            String feature = tuple.feature();
            String attribute = tuple.attribute();
            String value = tuple.value();
            try {
                licenseManager.checkFeature(vendor, feature);
                Feature licenseFeature = licenseManager.getFeature(vendor, feature);
                if (!attribute.equals("")) {
                    int j2;
                    String featureAndAttr;
                    String attrValueFromLicense = licenseFeature.get(attribute);
                    if (attrValueFromLicense != null) {
                        if (!value.equals("") && !attrValueFromLicense.equals(value)) {
                            log.info("Enforcing attribute restriction \"" + attribute + "=" + value + "\" for feature \"" + feature + "\"");
                            featureAndAttr = feature + ":" + attribute + "=" + value;
                            if (!requiredAttributes.contains((Object)featureAndAttr)) {
                                ++licenseFailureCount;
                                requiredAttributes.add((Object)featureAndAttr);
                            }
                            for (j2 = 0; j2 < slots.length; ++j2) {
                                this.hideSlot(parent, slots[j2]);
                            }
                        }
                    } else {
                        featureAndAttr = feature + ":" + attribute;
                        if (!requiredAttributes.contains((Object)featureAndAttr)) {
                            ++licenseFailureCount;
                            requiredAttributes.add((Object)featureAndAttr);
                        }
                        for (j2 = 0; j2 < slots.length; ++j2) {
                            this.hideSlot(parent, slots[j2]);
                        }
                    }
                }
                for (j = 0; j < slots.length; ++j) {
                    if ((unlicensedSlots.contains(slots[j]) || !this.notHiddenByDefault(slots[j])) && !slots[j].isDynamic()) continue;
                    this.unhideSlot(parent, slots[j]);
                }
                continue;
            }
            catch (FeatureNotLicensedException ex) {
                if (!requiredFeatures.contains((Object)feature)) {
                    ++licenseFailureCount;
                    requiredFeatures.add((Object)feature);
                }
                for (j = 0; j < slots.length; ++j) {
                    this.hideSlot(parent, slots[j]);
                }
            }
        }
        if (licenseFailureCount == 0) {
            log.info("******** Licensing checks succeeded **********");
        } else {
            log.severe("******* Found " + licenseFailureCount + " license check failures. *******");
            StringBuffer line = new StringBuffer();
            String[] requiredLicenseFeatures = (String[])requiredFeatures.trim();
            if (requiredLicenseFeatures.length > 0) {
                for (int i = 0; i < requiredLicenseFeatures.length; ++i) {
                    line.append(requiredLicenseFeatures[i] + ", ");
                }
                String temp = line.toString();
                temp = temp.substring(0, temp.length() - 2);
                log.severe("The following required features are either missing or unlicensed: {" + temp + "}");
            }
            line = new StringBuffer();
            String[] requiredLicenseAttributes = (String[])requiredAttributes.trim();
            if (requiredLicenseAttributes.length > 0) {
                for (int i = 0; i < requiredLicenseAttributes.length; ++i) {
                    line.append(requiredLicenseAttributes[i] + ", ");
                }
                String temp = line.toString();
                temp = temp.substring(0, temp.length() - 2);
                log.severe("The following required attributes are either missing or unlicensed: {" + temp + "}");
            }
        }
    }

    public void override() {
        log.warning("********** License visibility checking is not active ****************");
        Tuple[] tuples = (Tuple[])tupleArray.trim();
        for (int i = 0; i < tuples.length; ++i) {
            Tuple tuple = tuples[i];
            BComplex parent = tuple.parent();
            Slot[] slots = tuple.slots();
            for (int j = 0; j < slots.length; ++j) {
                if (!this.notHiddenByDefault(slots[j]) && !slots[j].isDynamic()) continue;
                this.unhideSlot(parent, slots[j]);
            }
        }
    }

    private boolean notHiddenByDefault(Slot slot) {
        int defaultFlags = slot.getDefaultFlags();
        return (defaultFlags & 4) == 0;
    }

    public LicenseChecker register(BComplex parent, Slot slot, String vendor, String feature, boolean checkDescendants) {
        return this.register(parent, slot, vendor, feature, "", "", checkDescendants);
    }

    public LicenseChecker register(Type type, String vendor, String feature, boolean checkDescendants) {
        return this.register(type, (BObject)Sys.getStation(), vendor, feature, checkDescendants);
    }

    public LicenseChecker register(Type type, BObject base, String vendor, String feature, boolean checkDescendants) {
        BITable results = (BITable)BOrd.make((String)("bql: select * from " + type.getTypeSpec())).get(base);
        TableCursor cursor = results.cursor();
        while (cursor.next()) {
            BComplex object = (BComplex)cursor.get();
            BComplex parent = object.getParent();
            Property slot = object.getPropertyInParent();
            this.register(parent, (Slot)slot, vendor, feature, checkDescendants);
        }
        return this;
    }

    public LicenseChecker register(Type type, BObject base, String vendor, String feature, String attribute, String value, boolean checkDescendants) {
        BITable results = (BITable)BOrd.make((String)("bql: select * from " + type.getTypeSpec())).get(base);
        TableCursor cursor = results.cursor();
        while (cursor.next()) {
            BComplex object = (BComplex)cursor.get();
            BComplex parent = object.getParent();
            Property slot = object.getPropertyInParent();
            this.register(parent, (Slot)slot, vendor, feature, attribute, value, checkDescendants);
        }
        return this;
    }

    public LicenseChecker register(BComplex parent, Slot slot, String vendor, String feature, String attribute, String value, boolean checkDescendants) {
        if (checkDescendants) {
            this.registerDescendants(parent, slot, vendor, feature, attribute, value);
        }
        return this.register(parent, new Slot[]{slot}, vendor, feature, attribute, value);
    }

    private void registerDescendants(BComplex parent, Slot slot, String vendor, String feature, String attribute, String value) {
        BValue object;
        if (slot.isProperty() && (object = parent.get(slot.asProperty())).getType().is(BComplex.TYPE)) {
            Slot[] childSlots = object.asComplex().getSlotsArray();
            this.register(object.asComplex(), childSlots, vendor, feature, attribute, value);
            for (int i = 0; i < childSlots.length; ++i) {
                this.registerDescendants(object.asComplex(), childSlots[i], vendor, feature, attribute, value);
            }
        }
    }

    private synchronized LicenseChecker register(BComplex parent, Slot[] slots, String vendor, String feature, String attribute, String value) {
        Array propertySlots = new Array(Slot.class);
        for (int i = 0; i < slots.length; ++i) {
            if (!slots[i].isProperty()) continue;
            propertySlots.add((Object)slots[i]);
        }
        tupleArray.add((Object)new Tuple(parent, (Slot[])propertySlots.trim(), vendor, feature, attribute, value));
        return this;
    }

    public synchronized void deregisterAll() {
        tupleArray.clear();
        unlicensedSlots.clear();
    }

    public synchronized void deregister(BComplex parent) {
        Tuple tupleToRemove = this.findTuple(parent);
        if (tupleToRemove == null) {
            return;
        }
        Slot[] slots = tupleToRemove.slots();
        for (int i = 0; i < slots.length; ++i) {
            unlicensedSlots.remove(slots[i]);
        }
        tupleArray.remove((Object)tupleToRemove);
    }

    private Tuple findTuple(BComplex parent) {
        Tuple[] tuples = this.getTuples();
        for (int i = 0; i < tuples.length; ++i) {
            Tuple current = tuples[i];
            if (!parent.equals((Object)current.parent())) continue;
            return current;
        }
        return null;
    }

    private void hideSlot(BComplex parent, Slot slot) {
        if (!parent.isComponent()) {
            return;
        }
        int mask = parent.getFlags(slot) | 4;
        parent.setFlags(slot, mask);
        unlicensedSlots.add(slot);
    }

    private void unhideSlot(BComplex parent, Slot slot) {
        if (!parent.isComponent()) {
            return;
        }
        int mask = parent.getFlags(slot) & 0xFFFFFFFB;
        parent.setFlags(slot, mask);
        unlicensedSlots.remove(slot);
    }

    public Tuple[] getTuples() {
        return (Tuple[])tupleArray.trim();
    }

    private class Tuple {
        private BComplex parent;
        private Array<Slot> slots;
        private String vendor;
        private String feature;
        private String attribute;
        private String value;

        public Tuple(BComplex parent, Slot slot, String vendor, String feature) {
            this(parent, new Slot[]{slot}, vendor, feature);
        }

        public Tuple(BComplex parent, Slot[] slots, String vendor, String feature) {
            this(parent, slots, vendor, feature, "", "");
        }

        public Tuple(BComplex parent, Slot[] slots, String vendor, String feature, String attribute, String value) {
            this.parent = parent;
            this.slots = new Array(Slot.class);
            this.slots.addAll((Object[])slots);
            this.vendor = vendor;
            this.feature = feature;
            this.attribute = attribute;
            this.value = value;
        }

        public String feature() {
            return this.feature;
        }

        public String vendor() {
            return this.vendor;
        }

        public String attribute() {
            return this.attribute;
        }

        public String value() {
            return this.value;
        }

        public Slot[] slots() {
            return (Slot[])this.slots.trim();
        }

        public BComplex parent() {
            return this.parent;
        }
    }
}

