/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platLon;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.platLon.BLonPlatformService;
import com.tridium.platform.BPlatform;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BLonPlatformServiceWin32
extends BLonPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BLonPlatformServiceWin32.class);
    private boolean nativesLoaded = false;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        boolean validOS = OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows);
        boolean validArch = "amd64".equalsIgnoreCase(System.getProperty("os.arch"));
        return validOS && validArch;
    }

    @Override
    public synchronized int driverInit(String deviceName) throws Exception {
        if (!this.loadLibraries()) {
            throw new Exception("Could not load lonworks dlls");
        }
        int ldvHandle = this.ldvOpen(deviceName);
        if (ldvHandle == -1) {
            throw new Exception("Unable to open lonworks device " + deviceName);
        }
        this.init(ldvHandle);
        return ldvHandle;
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                BPlatform.log.fine("Loading lon native library");
                System.loadLibrary("lon");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                BPlatform.log.log(Level.SEVERE, "Cannot load lon native library", e);
            }
            return this.nativesLoaded;
        });
    }

    private void init(int ldvHandle) throws Exception {
        byte[] msg = new byte[2];
        byte[] resp = new byte[128];
        boolean failedOnce = false;
        this.emptyReceive(ldvHandle, resp);
        msg[0] = 80;
        msg[1] = 0;
        int cnt = 0;
        while (cnt++ < 10) {
            this.ldvWrite(ldvHandle, msg, msg.length);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            resp[0] = 0;
            int rc = this.ldvRead(ldvHandle, resp);
            if (resp[0] == 80) {
                if (failedOnce) {
                    BLonPlatformServiceWin32.debug("LON Card reset complete!!");
                }
                return;
            }
            BLonPlatformServiceWin32.debug("LON Card Resetting!!");
            failedOnce = true;
            this.emptyReceive(ldvHandle, resp);
        }
        throw new Exception("Unable to successfully reset lonworks interface.");
    }

    private void emptyReceive(int ldvHandle, byte[] buf) throws Exception {
        try {
            Thread.sleep(100L);
            while (this.read(ldvHandle, buf)) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void write(int ldvHandle, byte[] netBytes, int msgLen) throws Exception {
        this.ldvWrite(ldvHandle, netBytes, msgLen);
    }

    @Override
    public boolean read(int ldvHandle, byte[] buf) throws Exception {
        int rc = this.ldvRead(ldvHandle, buf);
        return rc != -1;
    }

    @Override
    public synchronized void close(int ldvHandle) {
        try {
            if (ldvHandle >= 0) {
                this.ldvClose(ldvHandle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private native int ldvOpen(String var1);

    private native int ldvRead(int var1, byte[] var2) throws Exception;

    private native void ldvWrite(int var1, byte[] var2, int var3) throws Exception;

    private native void ldvClose(int var1) throws Exception;

    private static void debug(String s) {
        System.out.println(s);
    }
}

