/*
 * Decompiled with CFR 0.152.
 */
package obix.asm;

public class Buffer {
    public byte[] bytes;
    public int count;

    public Buffer() {
        this(1024);
    }

    public Buffer(int size) {
        this.bytes = new byte[size];
    }

    public final int u1(int v) {
        int cur = this.count;
        if (this.count + 1 >= this.bytes.length) {
            this.grow(this.count + 1);
        }
        this.bytes[this.count++] = (byte)(v & 0xFF);
        return cur;
    }

    public final int u2(int v) {
        int cur = this.count;
        if (this.count + 2 >= this.bytes.length) {
            this.grow(this.count + 2);
        }
        this.bytes[this.count++] = (byte)(v >>> 8 & 0xFF);
        this.bytes[this.count++] = (byte)(v >>> 0 & 0xFF);
        return cur;
    }

    public final int u4(int v) {
        int cur = this.count;
        if (this.count + 4 >= this.bytes.length) {
            this.grow(this.count + 4);
        }
        this.bytes[this.count++] = (byte)(v >>> 24 & 0xFF);
        this.bytes[this.count++] = (byte)(v >>> 16 & 0xFF);
        this.bytes[this.count++] = (byte)(v >>> 8 & 0xFF);
        this.bytes[this.count++] = (byte)(v >>> 0 & 0xFF);
        return cur;
    }

    public final int u8(long v) {
        int cur = this.count;
        if (this.count + 8 >= this.bytes.length) {
            this.grow(this.count + 8);
        }
        this.bytes[this.count++] = (byte)(v >>> 56 & 0xFFL);
        this.bytes[this.count++] = (byte)(v >>> 48 & 0xFFL);
        this.bytes[this.count++] = (byte)(v >>> 40 & 0xFFL);
        this.bytes[this.count++] = (byte)(v >>> 32 & 0xFFL);
        this.bytes[this.count++] = (byte)(v >>> 24 & 0xFFL);
        this.bytes[this.count++] = (byte)(v >>> 16 & 0xFFL);
        this.bytes[this.count++] = (byte)(v >>> 8 & 0xFFL);
        this.bytes[this.count++] = (byte)(v >>> 0 & 0xFFL);
        return cur;
    }

    public final void utf(String str) {
        char c;
        int i;
        int strlen = str.length();
        int utflen = 0;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new RuntimeException("Illegal UTF exception");
        }
        if (this.count + utflen + 2 >= this.bytes.length) {
            this.grow(this.count + utflen + 2);
        }
        this.bytes[this.count++] = (byte)(utflen >>> 8 & 0xFF);
        this.bytes[this.count++] = (byte)(utflen >>> 0 & 0xFF);
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.bytes[this.count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.bytes[this.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.bytes[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.bytes[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.bytes[this.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.bytes[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    public void append(Buffer buffer) {
        if (this.count + buffer.count >= this.bytes.length) {
            this.grow(this.count + buffer.count);
        }
        System.arraycopy(buffer.bytes, 0, this.bytes, this.count, buffer.count);
        this.count += buffer.count;
    }

    public void append(byte[] b) {
        if (this.count + b.length >= this.bytes.length) {
            this.grow(this.count + b.length);
        }
        System.arraycopy(b, 0, this.bytes, this.count, b.length);
        this.count += b.length;
    }

    public final void u1(int offset, int v) {
        this.bytes[offset + 0] = (byte)(v & 0xFF);
    }

    public final void u2(int offset, int v) {
        this.bytes[offset + 0] = (byte)(v >>> 8 & 0xFF);
        this.bytes[offset + 1] = (byte)(v >>> 0 & 0xFF);
    }

    public final void u4(int offset, int v) {
        this.bytes[offset + 0] = (byte)(v >>> 24 & 0xFF);
        this.bytes[offset + 1] = (byte)(v >>> 16 & 0xFF);
        this.bytes[offset + 2] = (byte)(v >>> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(v >>> 0 & 0xFF);
    }

    private void grow(int capacity) {
        int len = Math.max(capacity, this.bytes.length * 2);
        byte[] temp = new byte[len];
        System.arraycopy(this.bytes, 0, temp, 0, this.bytes.length);
        this.bytes = temp;
    }
}

