/*
 * Decompiled with CFR 0.152.
 */
package obix;

import obix.Uri;
import obix.Val;

public class Real
extends Val {
    public static final double MIN_DEFAULT = Double.NEGATIVE_INFINITY;
    public static final double MAX_DEFAULT = Double.POSITIVE_INFINITY;
    public static final int PRECISION_DEFAULT = 1;
    private double val;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private Uri unit = null;
    private int precision = 1;

    public Real(String name, double val) {
        super(name);
        this.set(val);
    }

    public Real(String name) {
        super(name);
        this.set(0.0);
    }

    public Real(double val) {
        this.set(val);
    }

    public Real() {
        this.set(0.0);
    }

    public double get() {
        return this.val;
    }

    public void set(double val) {
        this.val = val;
    }

    @Override
    public String getElement() {
        return "real";
    }

    @Override
    public int getBinCode() {
        return 16;
    }

    @Override
    public boolean valEquals(Val that) {
        if (that instanceof Real) {
            return ((Real)that).val == this.val;
        }
        return false;
    }

    @Override
    public int compareTo(Val that) {
        double a = this.val;
        double b = ((Real)that).val;
        if (a == b) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    @Override
    public String encodeVal() {
        return String.valueOf(this.val);
    }

    @Override
    public void decodeVal(String val) throws Exception {
        this.val = Double.parseDouble(val);
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public Uri getUnit() {
        return this.unit;
    }

    public void setUnit(Uri unit) {
        this.unit = unit;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }
}

