/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.platBacnet.BBacnetEthernetPlatformService;
import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridium.platBacnet.BacnetEthernetAdapterWin32;
import com.tridium.platBacnet.EthernetFilter;
import java.security.AccessController;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetEthernetPlatformServiceWin32
extends BBacnetEthernetPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEthernetPlatformServiceWin32.class);
    private static final String PCAP_IS_MISSING = lex.getText("winpcap.is.missing");
    private static final String PCAP_ADAPTER_PREFIX = "rpcap://";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        return OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows);
    }

    @Override
    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading ether native library");
                System.loadLibrary("pcapBacEther");
                log.fine("Loaded ether native library");
                this.nativesLoaded = true;
            }
            catch (UnsatisfiedLinkError ule) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Failed to load ether native library", ule);
                }
                throw new BajaRuntimeException(PCAP_IS_MISSING);
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load ether native library", e);
            }
            return this.nativesLoaded;
        });
    }

    @Override
    public BacnetEthernetAdapter openAdapter(String adapterName, EthernetFilter etherType) {
        return new BacnetEthernetAdapterWin32(adapterName, etherType);
    }

    @Override
    protected void queryForAdapters(Vector<String> adapterTitles, Vector<String> adapterDescriptions, Vector<String> adapterNames) throws Exception {
        BacnetEthernetAdapterWin32.queryForAdapters(adapterTitles, adapterDescriptions, adapterNames);
        for (int i = 0; i < adapterNames.size(); ++i) {
            String adapterName = adapterNames.get(i);
            if (adapterName == null || !adapterName.startsWith(PCAP_ADAPTER_PREFIX)) continue;
            String newAdapterName = adapterName.substring(PCAP_ADAPTER_PREFIX.length());
            adapterNames.setElementAt(newAdapterName, i);
        }
    }
}

