/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platBacnet;

import com.tridium.platBacnet.BEthernetPortParameters;
import com.tridium.platBacnet.BacnetEthernetAdapter;
import com.tridium.platBacnet.BacnetEthernetAdapterNpsdk;
import com.tridium.platBacnet.BacnetEthernetAdapterQnx;
import com.tridium.platBacnet.BacnetEthernetAdapterWin32;
import com.tridium.platBacnet.EthernetFilter;
import com.tridium.platBacnet.EthernetListener;
import com.tridium.platform.BPlatformService;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="testCommDriver", parameterType="BEthernetPortParameters", defaultValue="new BEthernetPortParameters()", flags=20)
public abstract class BBacnetEthernetPlatformService
extends BPlatformService {
    @Generated
    public static final Action testCommDriver = BBacnetEthernetPlatformService.newAction((int)20, (BValue)new BEthernetPortParameters(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetEthernetPlatformService.class);
    protected static final Logger log = Logger.getLogger("plat.ethernet");
    protected static final Lexicon lex = Lexicon.make((String)"platBacnet");
    protected boolean nativesLoaded = false;

    @Generated
    public void testCommDriver(BEthernetPortParameters parameter) {
        this.invoke(testCommDriver, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetEthernetPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("bacnetPlatformService.description"));
    }

    public void init() {
        this.checkLibrariesLoaded();
    }

    public BacnetEthernetAdapter openAdapter(String adapterName) {
        return this.openAdapter(adapterName, EthernetFilter.BACNET);
    }

    public abstract BacnetEthernetAdapter openAdapter(String var1, EthernetFilter var2);

    public String getLicenseFeature() {
        return null;
    }

    protected abstract boolean loadLibraries();

    private void checkLibrariesLoaded() {
        if (this.nativesLoaded) {
            return;
        }
        this.loadLibraries();
        this.nativesLoaded = true;
    }

    public final void getAdapterChoices(Vector<String> adapterTitles, Vector<String> adapterDescriptions, Vector<String> adapterNames) throws Exception {
        this.checkLibrariesLoaded();
        this.queryForAdapters(adapterTitles, adapterDescriptions, adapterNames);
    }

    protected abstract void queryForAdapters(Vector<String> var1, Vector<String> var2, Vector<String> var3) throws Exception;

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void doTestCommDriver(final BEthernetPortParameters portParameters) {
        new Thread("TestCommDriver"){

            @Override
            public void run() {
                BBacnetEthernetPlatformService.this.doTestCommDriverEntry(portParameters);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestCommDriverEntry(BEthernetPortParameters portParameters) {
        log.info("[TestCommDriver] Start");
        try {
            BacnetEthernetAdapter nativeAdapter;
            log.info("[TestCommDriver] Testing with parameters");
            log.info("[TestCommDriver]   adapterName:        '" + portParameters.getAdapterName() + "'");
            log.info("[TestCommDriver]   destinationAddress: '" + portParameters.getFrameDestination() + "'");
            log.info("[TestCommDriver]   vlanTag:            '" + portParameters.getUseVlanTag() + "'");
            log.info("[TestCommDriver]   frameType:          '" + (Object)((Object)portParameters.getFrameType()) + "'");
            log.info("[TestCommDriver]   framePayload:       '" + TextUtil.truncate((String)portParameters.getFramePayload(), (int)60) + "...'");
            this.init();
            Vector<String> allTitles = new Vector<String>();
            Vector<String> allDescriptions = new Vector<String>();
            Vector<String> allNames = new Vector<String>();
            this.getAdapterChoices(allTitles, allDescriptions, allNames);
            log.info("[TestCommDriver] Current Ethernet adapter lists:");
            for (int i = 0; i < allTitles.size(); ++i) {
                log.info("[TestCommDriver]   " + i + " title='" + SlotPath.unescape((String)allTitles.get(i)) + "' desc='" + SlotPath.unescape((String)allDescriptions.get(i)) + "' name='" + SlotPath.unescape((String)allNames.get(i)) + "'");
            }
            if (portParameters.getAdapterName().equalsIgnoreCase(BEthernetPortParameters.adapterName.getDefaultValue().toString())) {
                log.severe("[TestCommDriver] Invalid test adapter name " + portParameters.getAdapterName() + ", use one of listed 'name' values");
                throw new IllegalArgumentException("Invalid test adapter name " + portParameters.getAdapterName() + ", use one of listed 'name' values");
            }
            if (portParameters.getUseVlanTag() && portParameters.getFrameType().toEthernetFilter() == EthernetFilter.BACNET) {
                log.severe("[TestCommDriver] VLAN tagging not supported with BACnet frames!");
                throw new IllegalArgumentException("VLAN tagging not supported with BACnet frames!");
            }
            byte[] destinationAddress = ByteArrayUtil.hexStringToBytes((String)portParameters.getFrameDestination());
            if (destinationAddress.length != 6) {
                log.severe("[TestCommDriver] Invalid destination frame string, must be hex string, length must be 12");
                throw new IllegalArgumentException("Invalid destination frame string, must be hex string, length must be 12");
            }
            byte[] macAddress = new byte[6];
            BacnetEthernetAdapter adapter = this.openAdapter(null, portParameters.getFrameType().toEthernetFilter());
            log.info("[TestCommDriver] Testing the 'null' adapter...");
            String commonError = "[TestCommDriver] Failed to get Exception on null adapter using function ";
            try {
                adapter.open();
                log.severe(commonError + "open");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                adapter.getAddress(macAddress);
                log.severe(commonError + "getAddress");
            }
            catch (Exception exception) {
                // empty catch block
            }
            Level previousLevel = log.getLevel();
            log.setLevel(Level.OFF);
            try {
                adapter.commStart();
                log.setLevel(previousLevel);
                log.severe(commonError + "commStart");
            }
            catch (Exception exception) {
                // empty catch block
            }
            log.setLevel(previousLevel);
            try {
                adapter.startReception();
                log.severe(commonError + "startReception");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                adapter.run();
                adapter.send(new byte[60], 60);
                adapter.sendPacket(new byte[60]);
                adapter.receivePacket(new byte[60]);
                adapter.stopReception();
                adapter.commStop();
                adapter.commCleanup();
                adapter.close();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "[TestCommDriver] Unexpected exception on no-op adapter operation with 'null' adapter", e);
                throw e;
            }
            log.info("[TestCommDriver] Tests for 'null' adapter complete");
            log.info("[TestCommDriver] Testing the 'null' adapter passed to native layer...");
            if (adapter instanceof BacnetEthernetAdapterQnx) {
                nativeAdapter = (BacnetEthernetAdapterQnx)adapter;
                try {
                    ((BacnetEthernetAdapterQnx)nativeAdapter).getAddress0(null, new byte[6]);
                    ((BacnetEthernetAdapterQnx)nativeAdapter).getAddress0("foo", null);
                    log.severe("[TestCommDriver] Failed to throw exception on bad arguments to getAddress0!");
                    throw new Throwable("Failed to throw exception on bad arguments to getAddress0!");
                }
                catch (Exception exception) {
                    if (((BacnetEthernetAdapterQnx)nativeAdapter).bacnetOpen0(null, 2048, "()") != -1L || ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetOpen0("foo", -1, "()") != -1L || ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetOpen0("foo", -1, null) != -1L) {
                        log.severe("[TestCommDriver] Failed to return -1 on bad arguments to bacnetOpen0!");
                        throw new Throwable("Failed to return -1 on bad arguments to bacnetOpen0!");
                    }
                    try {
                        ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetRead0(10L, null);
                        log.severe("[TestCommDriver] Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                        throw new Throwable("Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                    }
                    catch (IllegalStateException illegalStateException) {
                        try {
                            ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetRead0(-1L, new byte[60]);
                            log.severe("[TestCommDriver] Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                            throw new Throwable("Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                        }
                        catch (IllegalStateException illegalStateException2) {
                            log.info("[TestCommDriver] Testing read with 'bad' argument, if this does not return immediately there is a problem...");
                            try {
                                ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetRead0(10000L, new byte[2048]);
                                log.severe("[TestCommDriver] Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                                throw new Throwable("Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                            }
                            catch (IllegalStateException illegalStateException3) {
                                try {
                                    ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetWrite0(-1L, new byte[60], 60);
                                    ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetWrite0(10L, null, 60);
                                    ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetWrite0(10L, new byte[60], -1);
                                    ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetWrite0(10L, new byte[60], 60);
                                    log.severe("[TestCommDriver] Failed to throw exception on bad arguments to bacnetWrite0!");
                                    throw new Throwable("Failed to throw exception on bad arguments to bacnetWrite0!");
                                }
                                catch (Exception exception2) {
                                    ((BacnetEthernetAdapterQnx)nativeAdapter).bacnetClose0(-1L);
                                }
                            }
                        }
                    }
                }
            } else if (adapter instanceof BacnetEthernetAdapterWin32) {
                nativeAdapter = (BacnetEthernetAdapterWin32)adapter;
                try {
                    ((BacnetEthernetAdapterWin32)nativeAdapter).getAddress0(null, new byte[6]);
                    ((BacnetEthernetAdapterWin32)nativeAdapter).getAddress0("foo", null);
                    log.severe("[TestCommDriver] Failed to throw exception on bad arguments to getAddress0!");
                    throw new Throwable("Failed to throw exception on bad arguments to getAddress0!");
                }
                catch (Exception exception) {
                    if (((BacnetEthernetAdapterWin32)nativeAdapter).bacnetOpen0(null, 2048, "()") != -1L || ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetOpen0("foo", -1, "()") != -1L || ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetOpen0("foo", -1, null) != -1L) {
                        log.severe("[TestCommDriver] Failed to return -1 on bad arguments to bacnetOpen0!");
                        throw new Throwable("Failed to return -1 on bad arguments to bacnetOpen0!");
                    }
                    try {
                        ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetRead0(10L, null);
                        log.severe("[TestCommDriver] Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                        throw new Throwable("Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                    }
                    catch (IllegalStateException illegalStateException) {
                        try {
                            ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetRead0(-1L, new byte[60]);
                            log.severe("[TestCommDriver] Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                            throw new Throwable("Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                        }
                        catch (IllegalStateException illegalStateException4) {
                            try {
                                ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetWrite0(-1L, new byte[60], 60);
                                ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetWrite0(10L, null, 60);
                                ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetWrite0(10L, new byte[60], -1);
                                ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetWrite0(10L, new byte[60], 60);
                                log.severe("[TestCommDriver] Failed to throw exception on bad arguments to bacnetWrite0!");
                                throw new Throwable("Failed to throw exception on bad arguments to bacnetWrite0!");
                            }
                            catch (Exception exception3) {
                                ((BacnetEthernetAdapterWin32)nativeAdapter).bacnetClose0(-1L);
                            }
                        }
                    }
                }
            } else if (adapter instanceof BacnetEthernetAdapterNpsdk) {
                nativeAdapter = (BacnetEthernetAdapterNpsdk)adapter;
                try {
                    ((BacnetEthernetAdapterNpsdk)nativeAdapter).getAddress0(null, new byte[6]);
                    ((BacnetEthernetAdapterNpsdk)nativeAdapter).getAddress0("foo", null);
                    log.severe("[TestCommDriver] Failed to throw exception on bad arguments to getAddress0!");
                    throw new Throwable("Failed to throw exception on bad arguments to getAddress0!");
                }
                catch (Exception exception) {
                    if (((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetOpen0(null, 2048, "()") != -1L || ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetOpen0("foo", -1, "()") != -1L || ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetOpen0("foo", -1, null) != -1L) {
                        log.severe("[TestCommDriver] Failed to return -1 on bad arguments to bacnetOpen0!");
                        throw new Throwable("Failed to return -1 on bad arguments to bacnetOpen0!");
                    }
                    try {
                        ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetRead0(10L, null);
                        log.severe("[TestCommDriver] Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                        throw new Throwable("Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                    }
                    catch (IllegalStateException illegalStateException) {
                        try {
                            ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetRead0(-1L, new byte[60]);
                            log.severe("[TestCommDriver] Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                            throw new Throwable("Failed to throw IllegalStateException on bad arguments to bacnetRead0!");
                        }
                        catch (IllegalStateException illegalStateException5) {
                            try {
                                ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetWrite0(-1L, new byte[60], 60);
                                ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetWrite0(10L, null, 60);
                                ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetWrite0(10L, new byte[60], -1);
                                ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetWrite0(10L, new byte[60], 60);
                                log.severe("[TestCommDriver] Failed to throw exception on bad arguments to bacnetWrite0!");
                                throw new Throwable("Failed to throw exception on bad arguments to bacnetWrite0!");
                            }
                            catch (Exception exception4) {
                                ((BacnetEthernetAdapterNpsdk)nativeAdapter).bacnetClose0(-1L);
                            }
                        }
                    }
                }
            }
            log.info("[TestCommDriver] Tests for 'null' adapter passed to native layer complete");
            log.info("[TestCommDriver] Testing the with provided '" + portParameters.getAdapterName() + "' adapter");
            try {
                adapter = this.openAdapter(portParameters.getAdapterName(), portParameters.getFrameType().toEthernetFilter());
                adapter.addListener(TestCommEthernetListener.TEST_LISTENER_INSTANCE);
                adapter.commStart();
                adapter.getAddress(macAddress);
                byte[] payloadAsBytes = ByteArrayUtil.hexStringToBytes((String)portParameters.getFramePayload());
                int vlanTagSize = portParameters.getUseVlanTag() ? 4 : 0;
                byte[] frameAsBytes = new byte[14 + vlanTagSize + payloadAsBytes.length];
                log.info("[TestCommDriver] Prepared frame with length " + frameAsBytes.length);
                if (frameAsBytes.length < 60) {
                    log.info("[TestCommDriver] Prepared Ethernet frame length " + frameAsBytes.length + " < " + 60 + ", frame will be padded to minimum length");
                }
                frameAsBytes[0] = destinationAddress[0];
                frameAsBytes[1] = destinationAddress[1];
                frameAsBytes[2] = destinationAddress[2];
                frameAsBytes[3] = destinationAddress[3];
                frameAsBytes[4] = destinationAddress[4];
                frameAsBytes[5] = destinationAddress[5];
                frameAsBytes[6] = macAddress[0];
                frameAsBytes[7] = macAddress[1];
                frameAsBytes[8] = macAddress[2];
                frameAsBytes[9] = macAddress[3];
                frameAsBytes[10] = macAddress[4];
                frameAsBytes[11] = macAddress[5];
                if (portParameters.getFrameType().toEthernetFilter() == EthernetFilter.BACNET) {
                    frameAsBytes[12] = (byte)((payloadAsBytes.length & 0xFF00) >> 8);
                    frameAsBytes[13] = (byte)(payloadAsBytes.length & 0xFF);
                } else if (portParameters.getFrameType().toEthernetFilter() == EthernetFilter.PROFINET && portParameters.getUseVlanTag()) {
                    frameAsBytes[12] = -127;
                    frameAsBytes[13] = 0;
                    frameAsBytes[14] = 0;
                    frameAsBytes[15] = 0;
                }
                System.arraycopy(payloadAsBytes, 0, frameAsBytes, 14 + vlanTagSize, payloadAsBytes.length);
                adapter.sendPacket(frameAsBytes);
                log.info("[TestCommDriver] Packet Sent:");
                ByteArrayUtil.hexDump((byte[])(frameAsBytes.length < 60 ? BBacnetEthernetPlatformService.pad(frameAsBytes) : frameAsBytes));
                try {
                    adapter.sendPacket(new byte[10000]);
                    log.severe("[TestCommDriver] Failed to throw exception on bad arguments (frame too big)  to bacnetWrite0!");
                    throw new Throwable("Failed to throw exception on bad arguments (frame too big) to bacnetWrite0!");
                }
                catch (Exception exception) {
                    log.info("[TestCommDriver] Waiting a few seconds for any packets that might arrive...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                    log.info("[TestCommDriver] Reception pause complete, completing test");
                    try {
                        adapter.removeListener(TestCommEthernetListener.TEST_LISTENER_INSTANCE);
                    }
                    catch (Exception exception6) {
                        // empty catch block
                    }
                    try {
                        adapter.commStop();
                    }
                    catch (Exception exception7) {
                        // empty catch block
                    }
                    try {
                        adapter.commCleanup();
                    }
                    catch (Exception exception8) {}
                }
            }
            catch (Throwable throwable) {
                try {
                    adapter.removeListener(TestCommEthernetListener.TEST_LISTENER_INSTANCE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    adapter.commStop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    adapter.commCleanup();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            log.info("[TestCommDriver] Tests for '" + portParameters.getAdapterName() + "' adapter complete");
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "[TestCommDriver] Unhandled throwable caught, TEST FAILED!", t);
        }
        log.info("[TestCommDriver] End");
    }

    private static byte[] pad(byte[] packet) {
        byte[] padded = new byte[60];
        System.arraycopy(packet, 0, padded, 0, packet.length);
        return padded;
    }

    private static class TestCommEthernetListener
    implements EthernetListener {
        static final TestCommEthernetListener TEST_LISTENER_INSTANCE = new TestCommEthernetListener();

        private TestCommEthernetListener() {
        }

        @Override
        public void receivePacket(byte[] packet, int packetLen) {
            if (log.isLoggable(Level.FINE)) {
                log.info("[TestCommDriver] Received Packet, packet.length = " + packet.length + ", bytesRcvd = " + packetLen);
                if (packetLen < 0) {
                    return;
                }
                ByteArrayUtil.hexDump((byte[])packet, (int)0, (int)Math.min(packet.length, packetLen));
            }
            if (packetLen > packet.length) {
                log.warning("[TestCommDriver] Received packet with less bytes (" + packet.length + ") then indicated in bytesRcvd (" + packetLen + ")");
            }
        }
    }
}

