/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.spec;

import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class BerEncoder {
    private int curSeqIndex;
    private int[] seqOffset;
    protected byte[] buf;
    protected int offset;
    protected int bufsize;

    public BerEncoder() {
        this(1024);
    }

    public BerEncoder(int paramInt) {
        this.buf = new byte[paramInt];
        this.bufsize = paramInt;
        this.offset = 0;
        this.seqOffset = new int[16];
        this.curSeqIndex = 0;
    }

    public void reset() {
        while (this.offset > 0) {
            this.buf[--this.offset] = 0;
        }
        while (this.curSeqIndex > 0) {
            this.seqOffset[--this.curSeqIndex] = 0;
        }
    }

    public int getDataLen() {
        return this.offset;
    }

    public byte[] getBuf() {
        if (this.curSeqIndex != 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        return this.buf;
    }

    public byte[] getTrimmedBuf() {
        int i = this.getDataLen();
        byte[] arrayOfByte = new byte[i];
        System.arraycopy(this.getBuf(), 0, arrayOfByte, 0, i);
        return arrayOfByte;
    }

    public void beginSeq(int paramInt) {
        if (this.curSeqIndex >= this.seqOffset.length) {
            int[] arrayOfInt = new int[this.seqOffset.length * 2];
            for (int i = 0; i < this.seqOffset.length; ++i) {
                arrayOfInt[i] = this.seqOffset[i];
            }
            this.seqOffset = arrayOfInt;
        }
        this.encodeByte(paramInt);
        this.seqOffset[this.curSeqIndex] = this.offset;
        this.ensureFreeBytes(3);
        this.offset += 3;
        ++this.curSeqIndex;
    }

    public void endSeq() throws EncodeException {
        --this.curSeqIndex;
        if (this.curSeqIndex < 0) {
            throw new IllegalStateException("BER encode error: Unbalanced SEQUENCEs.");
        }
        int i = this.seqOffset[this.curSeqIndex] + 3;
        int j = this.offset - i;
        if (j <= 127) {
            this.shiftSeqData(i, j, -2);
            this.buf[this.seqOffset[this.curSeqIndex]] = (byte)j;
        } else if (j <= 255) {
            this.shiftSeqData(i, j, -1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -127;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)j;
        } else if (j <= 65535) {
            this.buf[this.seqOffset[this.curSeqIndex]] = -126;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(j >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)j;
        } else if (j <= 0xFFFFFF) {
            this.shiftSeqData(i, j, 1);
            this.buf[this.seqOffset[this.curSeqIndex]] = -125;
            this.buf[this.seqOffset[this.curSeqIndex] + 1] = (byte)(j >> 16);
            this.buf[this.seqOffset[this.curSeqIndex] + 2] = (byte)(j >> 8);
            this.buf[this.seqOffset[this.curSeqIndex] + 3] = (byte)j;
        } else {
            throw new EncodeException("SEQUENCE too long");
        }
    }

    private void shiftSeqData(int start, int end, int shift) {
        if (shift > 0) {
            this.ensureFreeBytes(shift);
        }
        System.arraycopy(this.buf, start, this.buf, start + shift, end);
        this.offset += shift;
    }

    public void encodeByte(int paramInt) {
        this.ensureFreeBytes(1);
        this.buf[this.offset++] = (byte)paramInt;
    }

    public void encodeInt(int paramInt) {
        this.encodeInt(paramInt, 2);
    }

    public void encodeInt(int paramInt1, int paramInt2) {
        int i = -8388608;
        int j = 4;
        while (((paramInt1 & i) == 0 || (paramInt1 & i) == i) && j > 1) {
            --j;
            paramInt1 <<= 8;
        }
        this.encodeInt(paramInt1, paramInt2, j);
    }

    private void encodeInt(int paramInt1, int paramInt2, int paramInt3) {
        if (paramInt3 > 4) {
            throw new IllegalArgumentException("BER encode error: INTEGER too long.");
        }
        this.ensureFreeBytes(2 + paramInt3);
        this.buf[this.offset++] = (byte)paramInt2;
        this.buf[this.offset++] = (byte)paramInt3;
        int i = -16777216;
        while (paramInt3-- > 0) {
            this.buf[this.offset++] = (byte)((paramInt1 & i) >> 24);
            paramInt1 <<= 8;
        }
    }

    public void encodeBoolean(boolean paramBoolean) {
        this.encodeBoolean(paramBoolean, 1);
    }

    public void encodeBoolean(boolean paramBoolean, int paramInt) {
        this.ensureFreeBytes(3);
        this.buf[this.offset++] = (byte)paramInt;
        this.buf[this.offset++] = 1;
        this.buf[this.offset++] = (byte)(paramBoolean ? -1 : 0);
    }

    public void encodeString(String paramString, int paramInt, boolean paramBoolean) throws EncodeException {
        int j;
        this.encodeByte(paramInt);
        int i = 0;
        byte[] arrayOfByte = null;
        if (paramString == null) {
            j = 0;
        } else {
            if (paramBoolean) {
                try {
                    arrayOfByte = paramString.getBytes("UTF8");
                    j = arrayOfByte.length;
                }
                catch (UnsupportedEncodingException localUnsupportedEncodingException1) {
                    throw new EncodeException("UTF8 not available on platform");
                }
            }
            try {
                arrayOfByte = paramString.getBytes("8859_1");
                j = arrayOfByte.length;
            }
            catch (UnsupportedEncodingException localUnsupportedEncodingException2) {
                throw new EncodeException("8859_1 not available on platform");
            }
        }
        this.encodeLength(j);
        this.ensureFreeBytes(j);
        while (i < j) {
            this.buf[this.offset++] = arrayOfByte[i++];
        }
    }

    public void encodeOctetString(byte[] paramArrayOfByte, int paramInt1, int paramInt2, int paramInt3) throws EncodeException {
        this.encodeByte(paramInt1);
        this.encodeLength(paramInt3);
        if (paramInt3 > 0) {
            this.ensureFreeBytes(paramInt3);
            System.arraycopy(paramArrayOfByte, paramInt2, this.buf, this.offset, paramInt3);
            this.offset += paramInt3;
        }
    }

    public void encodeOctetString(byte[] paramArrayOfByte, int paramInt) throws EncodeException {
        this.encodeOctetString(paramArrayOfByte, paramInt, 0, paramArrayOfByte.length);
    }

    private void encodeLength(int paramInt) throws EncodeException {
        this.ensureFreeBytes(4);
        if (paramInt < 128) {
            this.buf[this.offset++] = (byte)paramInt;
        } else if (paramInt <= 255) {
            this.buf[this.offset++] = -127;
            this.buf[this.offset++] = (byte)paramInt;
        } else if (paramInt <= 65535) {
            this.buf[this.offset++] = -126;
            this.buf[this.offset++] = (byte)(paramInt >> 8);
            this.buf[this.offset++] = (byte)(paramInt & 0xFF);
        } else if (paramInt <= 0xFFFFFF) {
            this.buf[this.offset++] = -125;
            this.buf[this.offset++] = (byte)(paramInt >> 16);
            this.buf[this.offset++] = (byte)(paramInt >> 8);
            this.buf[this.offset++] = (byte)(paramInt & 0xFF);
        } else {
            throw new EncodeException("string too long");
        }
    }

    public void encodeString(String paramString, boolean paramBoolean) throws EncodeException {
        this.encodeString(paramString, 4, paramBoolean);
    }

    public void encodeStringArray(String[] paramArrayOfString, boolean encodeUTF8) throws EncodeException {
        if (paramArrayOfString == null) {
            return;
        }
        for (int i = 0; i < paramArrayOfString.length; ++i) {
            this.encodeString(paramArrayOfString[i], encodeUTF8);
        }
    }

    private void ensureFreeBytes(int paramInt) {
        if (this.bufsize - this.offset < paramInt) {
            int i = this.bufsize * 8;
            if (i - this.offset < paramInt) {
                i += paramInt;
            }
            byte[] arrayOfByte = new byte[i];
            System.arraycopy(this.buf, 0, arrayOfByte, 0, this.offset);
            this.buf = arrayOfByte;
            this.bufsize = i;
        }
    }

    static final class EncodeException
    extends IOException {
        private static final long serialVersionUID = 1L;

        EncodeException(String paramString) {
            super(paramString);
        }
    }
}

