/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.callbacks;

import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.callbacks.LdapServerChangeObserver;
import com.tridiumx.ldapDriver.users.BLdapUser;
import com.tridiumx.ldapDriver.users.BLdapUsersDeviceExt;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.naming.Context;
import javax.naming.NamingException;

public final class PollingBasedObserver
extends LdapServerChangeObserver {
    private ScheduledExecutorService executorService;
    private static final Map<String, PollingBasedObserver> pollObserverList = new LinkedHashMap<String, PollingBasedObserver>();

    private PollingBasedObserver(BLdapServer server) {
        super(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PollingBasedObserver getInstance(BLdapServer ldapserver) {
        String key = ldapserver.getName();
        if (pollObserverList.get(key) != null) return pollObserverList.get(key);
        Class<PollingBasedObserver> clazz = PollingBasedObserver.class;
        synchronized (PollingBasedObserver.class) {
            if (pollObserverList.get(key) != null) return pollObserverList.get(key);
            pollObserverList.put(key, new PollingBasedObserver(ldapserver));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return pollObserverList.get(key);
        }
    }

    @Override
    public void register() {
        this.unregister();
        this.executorService = Executors.newScheduledThreadPool(1);
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                PollingBasedObserver.this.executeChangeQuery();
            }
        }, 100L, this.ldapServer.getPollingInterval().getMillis(), TimeUnit.MILLISECONDS);
        this.log.fine("Registered the POLL Handler for : " + this.ldapServer.getName());
    }

    @Override
    public void unregister() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeChangeQuery() {
        Context ldapContext = null;
        BLdapUsersDeviceExt userExt = this.ldapServer.getLdapUsersExt();
        long millis = userExt.getLastUpdateTime().getMillis();
        Date lastReplicationMoment = new Date(millis);
        String searchFilter = userExt.getSearchFilter();
        try {
            String finalFilter = this.getSearchFilter(lastReplicationMoment, searchFilter);
            BLdapUser[] changedUserList = userExt.getUserList(null, finalFilter).getUserList();
            BVector changeLog = new BVector();
            if (changedUserList.length > 0) {
                for (int index = 0; index < changedUserList.length; ++index) {
                    changeLog.add(null, changedUserList[index].newCopy(true));
                }
                this.ldapServer.fireLdapEntryChanged((BValue)changeLog);
            }
            super.executeChangeQuery();
        }
        catch (NamingException e) {
            this.log.log(Level.SEVERE, "Error initializing poll based change tracking : " + e.getLocalizedMessage());
        }
        finally {
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {
                    this.log.severe("Error closing LDAP connection : " + e.getLocalizedMessage());
                }
            }
        }
    }

    private String getSearchFilter(Date lastReplicationMoment, String searchFilter) {
        StringBuffer buffer = new StringBuffer();
        String modifyFilter1 = this.addTimeFilter(lastReplicationMoment, "whenChanged");
        String createFilter1 = this.addTimeFilter(lastReplicationMoment, "whenCreated");
        String modifyFilter2 = this.addTimeFilter(lastReplicationMoment, "modifyTimestamp");
        String createFilter2 = this.addTimeFilter(lastReplicationMoment, "createTimestamp");
        buffer.append("(|");
        buffer.append(modifyFilter1);
        buffer.append(createFilter1);
        buffer.append(modifyFilter2);
        buffer.append(createFilter2);
        buffer.append(")");
        StringBuffer finalBuffer = new StringBuffer();
        finalBuffer.append("(&");
        finalBuffer.append(searchFilter);
        finalBuffer.append(buffer.toString());
        finalBuffer.append(")");
        return finalBuffer.toString();
    }

    private String addTimeFilter(Date lastReplicationMoment, String timestamplabel) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append(timestamplabel);
        buffer.append(">=");
        SimpleDateFormat ldapFormat = new SimpleDateFormat("yyyyMMddHHmmss.S");
        ldapFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String modifiedTime = ldapFormat.format(lastReplicationMoment);
        buffer.append(modifiedTime);
        buffer.append("Z)");
        return buffer.toString();
    }
}

