/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.ldapDriver.callbacks;

import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.callbacks.LdapServerChangeObserver;
import com.tridiumx.ldapDriver.spec.EntryChangeResponseControl;
import com.tridiumx.ldapDriver.spec.PersistentSearchControl;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;

public final class PersistentSearchControlObserver
extends LdapServerChangeObserver
implements Runnable {
    private final Logger log = Logger.getLogger("ldapDriver.PersistentSearchControl");
    private NamingEnumeration<?> searchHandle;
    private LdapContext ldapContext;
    private ExecutorService executorservice = null;
    private static PersistentSearchControlObserver _instance = null;

    private PersistentSearchControlObserver(BLdapServer ldapServer) {
        super(ldapServer);
        this.setKeepRunning(true);
    }

    public static synchronized PersistentSearchControlObserver getInstance(BLdapServer ldapserver) {
        if (_instance == null) {
            _instance = new PersistentSearchControlObserver(ldapserver);
        }
        return _instance;
    }

    @Override
    public void run() {
        PersistentSearchControl control = null;
        this.ldapContext = null;
        try {
            this.log.fine("Registering persistent search control handler");
            this.ldapContext = (LdapContext)this.getConnection();
            SearchControls searchControls = new SearchControls();
            String[] returnedAttrs = null;
            searchControls.setReturningAttributes(returnedAttrs);
            searchControls.setSearchScope(2);
            searchControls.setTimeLimit(0);
            try {
                control = new PersistentSearchControl(15, true, true, true);
            }
            catch (IOException e) {
                this.log.fine("Error initializing persistent search control " + e.getLocalizedMessage());
                return;
            }
            Control[] requestControls = new Control[]{control};
            this.ldapContext.setRequestControls(requestControls);
            String searchBase = this.ldapServer.getUserSearchBase();
            String searchFilter = this.ldapServer.getUserSearchFilter();
            while (this.keepRunning) {
                this.log.fine("Waiting for changes...");
                this.searchHandle = this.ldapContext.search(searchBase, searchFilter, searchControls);
                SearchResult searchResult = null;
                searchResult = (SearchResult)this.searchHandle.next();
                Control[] responseControls = this.ldapContext.getResponseControls();
                if (responseControls != null) {
                    for (int i = 0; i < responseControls.length; ++i) {
                        if (!(responseControls[i] instanceof EntryChangeResponseControl)) continue;
                        EntryChangeResponseControl entryChangeResponseControl = (EntryChangeResponseControl)responseControls[i];
                        this.log.fine("Change Type: " + entryChangeResponseControl.getChangeType());
                    }
                    continue;
                }
                Attributes attributes = searchResult.getAttributes();
                NamingEnumeration<? extends Attribute> dnAttr = attributes.getAll();
                while (dnAttr.hasMore()) {
                    Attribute attr = dnAttr.next();
                    this.log.info("Attribute value pair is (" + attr.getID() + " , " + attr.get() + " and thread id is " + Thread.currentThread().getId());
                }
            }
        }
        catch (NamingException e) {
            this.log.log(Level.SEVERE, "Naming Error initializing persistent search control : " + e.getLocalizedMessage());
        }
    }

    @Override
    public void register() {
        if (this.executorservice != null) {
            this.executorservice.shutdown();
        }
        this.executorservice = Executors.newCachedThreadPool();
        this.executorservice.execute(this);
    }

    @Override
    public void unregister() throws NamingException {
        this.keepRunning = false;
        if (this.searchHandle != null) {
            this.searchHandle.close();
        }
        if (this.ldapContext != null) {
            this.ldapContext.close();
        }
        if (this.executorservice != null) {
            this.executorservice.shutdown();
        }
    }
}

