/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

public final class MbusTextUtil {
    private static final String[] SPACES;
    private static final String[] ZEROS;

    private MbusTextUtil() {
    }

    public static String byteToString(int b) {
        return Integer.toString(b);
    }

    public static String byteToHexString(int b) {
        return MbusTextUtil.intToHexString(b & 0xFF, 2);
    }

    public static char byteToChar(int b, char unprintable) {
        if (b < 32 || b > 126) {
            return unprintable;
        }
        return (char)b;
    }

    public static String intToHexString(int i) {
        return MbusTextUtil.padZeros(Integer.toHexString(i), 8);
    }

    public static String intToHexString(int i, int len) {
        return MbusTextUtil.padZeros(Integer.toHexString(i), len);
    }

    public static int charToInt(char c) {
        int x = c - 48;
        if (x < 0 || x > 9) {
            throw new IllegalArgumentException("'" + c + "'");
        }
        return x;
    }

    public static int hexCharToInt(char c) {
        int x = c - 48;
        if (x >= 0 && x <= 9) {
            return x;
        }
        x = c - 65 + 10;
        if (x >= 10 && x <= 15) {
            return x;
        }
        x = c - 97 + 10;
        if (x >= 10 && x <= 15) {
            return x;
        }
        throw new IllegalArgumentException("'" + c + "'");
    }

    public static boolean isHex(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }

    public static String getSpaces(int num) {
        try {
            return SPACES[num];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (num < 0) {
                return "";
            }
            int len = SPACES.length;
            StringBuilder buf = new StringBuilder(num);
            int rem = num;
            while (true) {
                if (rem < len) break;
                buf.append(SPACES[len - 1]);
                rem -= len - 1;
            }
            buf.append(SPACES[rem]);
            return buf.toString();
        }
    }

    public static String pad(String s, int width) {
        return MbusTextUtil.padRight(s, width);
    }

    public static String padRight(String s, int width) {
        if (s.length() >= width) {
            return s;
        }
        StringBuilder buf = new StringBuilder(width);
        buf.append(s).append(MbusTextUtil.getSpaces(width - s.length()));
        return buf.toString();
    }

    public static String padLeft(String s, int width) {
        if (s.length() >= width) {
            return s;
        }
        StringBuilder buf = new StringBuilder(width);
        buf.append(MbusTextUtil.getSpaces(width - s.length())).append(s);
        return buf.toString();
    }

    public static String truncate(String str, int max) {
        return str.length() > max ? str.substring(0, max) : str;
    }

    public static String padZeros(String s, int width) {
        if (s.length() >= width) {
            return s;
        }
        StringBuilder buf = new StringBuilder(width);
        buf.append(MbusTextUtil.getZeros(width - s.length())).append(s);
        return buf.toString();
    }

    public static String getZeros(int num) {
        try {
            return ZEROS[num];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (num < 0) {
                return "";
            }
            int len = ZEROS.length;
            StringBuilder buf = new StringBuilder(num);
            int rem = num;
            while (true) {
                if (rem < len) break;
                buf.append(ZEROS[len - 1]);
                rem -= len - 1;
            }
            buf.append(ZEROS[rem]);
            return buf.toString();
        }
    }

    public static char toUpperCase(char c) {
        if ('a' <= c && c <= 'z') {
            return (char)(c & 0xFFFFFFDF);
        }
        return c;
    }

    public static char toLowerCase(char c) {
        if ('A' <= c && c <= 'Z') {
            return (char)(c | 0x20);
        }
        return c;
    }

    public static String toUpperCase(String s) {
        int len = s.length();
        int first = -1;
        for (int i = 0; i < len; ++i) {
            char b;
            char a = s.charAt(i);
            if (a == (b = MbusTextUtil.toUpperCase(a))) continue;
            first = i;
            break;
        }
        if (first == -1) {
            return s;
        }
        char[] buf = new char[len];
        s.getChars(0, first, buf, 0);
        for (int i = first; i < len; ++i) {
            buf[i] = MbusTextUtil.toUpperCase(s.charAt(i));
        }
        return new String(buf);
    }

    public static String toLowerCase(String s) {
        int len = s.length();
        int first = -1;
        for (int i = 0; i < len; ++i) {
            char b;
            char a = s.charAt(i);
            if (a == (b = MbusTextUtil.toLowerCase(a))) continue;
            first = i;
            break;
        }
        if (first == -1) {
            return s;
        }
        char[] buf = new char[len];
        s.getChars(0, first, buf, 0);
        for (int i = first; i < len; ++i) {
            buf[i] = MbusTextUtil.toLowerCase(s.charAt(i));
        }
        return new String(buf);
    }

    public static String capitalize(String s) {
        char[] c = s.toCharArray();
        c[0] = MbusTextUtil.toUpperCase(c[0]);
        return new String(c);
    }

    public static String decapitalize(String s) {
        char[] c = s.toCharArray();
        c[0] = MbusTextUtil.toLowerCase(c[0]);
        return new String(c);
    }

    public static String toFriendly(String s) {
        StringBuilder buf = new StringBuilder();
        buf.append(Character.toUpperCase(s.charAt(0)));
        int len = s.length();
        for (int i = 1; i < len; ++i) {
            char c = s.charAt(i);
            if ((c & 0x20) == 0 && i > 0) {
                buf.append(' ').append(c);
                continue;
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String fromFriendly(String s) {
        char c;
        int i;
        StringBuilder buf = new StringBuilder(s.length());
        buf.append(Character.toLowerCase(s.charAt(0)));
        int len = s.length();
        for (i = 1; i < len && (c = s.charAt(i)) != ' '; ++i) {
            buf.append(c);
        }
        while (i < len) {
            c = s.charAt(i);
            if (c != ' ') {
                buf.append(c);
            }
            ++i;
        }
        return buf.toString();
    }

    public static String getClassName(Class<?> cls) {
        return MbusTextUtil.getClassName(cls.getName());
    }

    public static String getClassName(String className) {
        int x = className.lastIndexOf(46);
        if (x >= 0) {
            className = className.substring(x + 1);
        }
        if (className.charAt(className.length() - 1) == ';') {
            className = className.substring(0, className.length() - 1);
        }
        return className;
    }

    public static String getPackageName(Class<?> cls) {
        return MbusTextUtil.getPackageName(cls.getName());
    }

    public static String getPackageName(String className) {
        int x = className.lastIndexOf(46);
        if (x < 0) {
            return null;
        }
        return className.substring(0, x);
    }

    public static String stripMarkup(String text) {
        StringBuilder s = new StringBuilder();
        char[] buf = text.toCharArray();
        for (int i = 0; i < buf.length; ++i) {
            char c = buf[i];
            if (c != '<') {
                s.append(c);
                continue;
            }
            int end = -1;
            for (int j = i + 1; j < buf.length; ++j) {
                if (buf[j] != '>') continue;
                end = j;
                break;
            }
            if (end == -1) continue;
            i = end;
        }
        return s.toString();
    }

    public static String[] split(String str, char delimiter) {
        if (str.indexOf(delimiter) == -1) {
            if (str.length() == 0) {
                return new String[0];
            }
            return new String[]{str};
        }
        String[] list = new String[8];
        int a = 0;
        int b = 0;
        int n = 0;
        while (b < str.length()) {
            if (str.charAt(b) == delimiter) {
                list = MbusTextUtil.ensureCapacity(list, n);
                list[n++] = str.substring(a, b);
                a = ++b;
                continue;
            }
            ++b;
        }
        list = MbusTextUtil.ensureCapacity(list, n);
        list[n++] = str.substring(a);
        if (n == list.length) {
            return list;
        }
        String[] trim = new String[n];
        System.arraycopy(list, 0, trim, 0, n);
        return trim;
    }

    public static String[] splitAndTrim(String str, char delimiter) {
        return MbusTextUtil.trim(MbusTextUtil.split(str, delimiter));
    }

    public static String[] ensureCapacity(String[] x, int len) {
        if (len < x.length) {
            return x;
        }
        String[] expand = new String[x.length * 2];
        System.arraycopy(x, 0, expand, 0, x.length);
        return expand;
    }

    public static String[] trim(String[] list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            list[i] = list[i].trim();
        }
        return list;
    }

    public static String join(String[] v, char delimiter) {
        if (v.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = v.length - 1;
        for (int i = 0; i < n; ++i) {
            sb.append(v[i]).append(delimiter);
        }
        sb.append(v[n]);
        return sb.toString();
    }

    public static String trimLeft(String s) {
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimRight(String s) {
        StringBuilder sb = new StringBuilder(s);
        for (int len = sb.length(); len > 0 && Character.isWhitespace(sb.charAt(len - 1)); --len) {
            sb.deleteCharAt(len - 1);
        }
        return sb.toString();
    }

    public static String replace(String text, String oldStr, String newStr) {
        if (text == null) {
            throw new NullPointerException();
        }
        if (oldStr == null) {
            throw new NullPointerException();
        }
        if (newStr == null) {
            throw new NullPointerException();
        }
        int b = text.indexOf(oldStr);
        if (b == -1) {
            return text;
        }
        return MbusTextUtil.doReplace(new StringBuilder(text), oldStr, newStr, b).toString();
    }

    public static StringBuilder replace(StringBuilder text, String oldStr, String newStr) {
        if (text == null) {
            throw new NullPointerException();
        }
        if (oldStr == null) {
            throw new NullPointerException();
        }
        if (newStr == null) {
            throw new NullPointerException();
        }
        int b = MbusTextUtil.indexOf(text, oldStr, 0);
        if (b == -1) {
            return text;
        }
        return MbusTextUtil.doReplace(text, oldStr, newStr, b);
    }

    private static StringBuilder doReplace(StringBuilder text, String oldStr, String newStr, int b) {
        int n1 = oldStr.length();
        int n2 = newStr.length();
        while (b != -1) {
            text.replace(b, b + n1, newStr);
            b = MbusTextUtil.indexOf(text, oldStr, b + n2);
        }
        return text;
    }

    public static int indexOf(StringBuilder buffer, String pattern) {
        return MbusTextUtil.indexOf(buffer, pattern, 0);
    }

    public static int indexOf(StringBuilder buffer, String pattern, int fromIndex) {
        int z;
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (pattern == null) {
            throw new NullPointerException();
        }
        int[] overlap = MbusTextUtil.computeOverlap(pattern);
        int j = 0;
        int n = buffer.length();
        int m = pattern.length();
        block0: for (int i = z = Math.max(fromIndex, 0); i < n; ++i) {
            while (true) {
                if (buffer.charAt(i) == pattern.charAt(j)) {
                    if (++j != m) continue block0;
                    return i - m + 1;
                }
                if (j == 0) continue block0;
                j = overlap[j];
            }
        }
        return -1;
    }

    private static int[] computeOverlap(String pattern) {
        int m = pattern.length();
        int[] overlap = new int[m + 1];
        overlap[0] = -1;
        for (int i = 0; i < m; ++i) {
            overlap[i + 1] = overlap[i] + 1;
            while (overlap[i + 1] > 0 && pattern.charAt(i) != pattern.charAt(overlap[i + 1] - 1)) {
                overlap[i + 1] = overlap[overlap[i + 1] - 1] + 1;
            }
        }
        return overlap;
    }

    static {
        int i;
        SPACES = new String[50];
        MbusTextUtil.SPACES[0] = "";
        for (i = 1; i < 50; ++i) {
            MbusTextUtil.SPACES[i] = SPACES[i - 1] + " ";
        }
        ZEROS = new String[16];
        MbusTextUtil.ZEROS[0] = "";
        for (i = 1; i < 16; ++i) {
            MbusTextUtil.ZEROS[i] = ZEROS[i - 1] + "0";
        }
    }
}

