/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.utils.MbusDecodeVariableFrame;
import com.tridium.mbus.utils.MbusLogInputOutput;
import java.util.ArrayList;

public final class MbusReceivedLongFrame
extends MbusResponseMessage {
    int cField = 0;
    int aField = 0;
    int cIField = 0;
    String idBcdCoded = "";
    String manufacturer = "";
    String fabNumber = "";
    int versionNumber = 0;
    BMbusDeviceTypeId deviceTypeId = BMbusDeviceTypeId.other;
    int access = 0;
    String status = "";
    String secondaryAdd = "";
    int manufacturersIndex = -1;
    boolean status5 = false;
    boolean status6 = false;
    boolean status7 = false;
    long tariff = 0L;
    long integer = 0L;
    long storageBlockSize = 0L;
    long storageBlockDate = 0L;
    long storageBlockInterval = 0L;
    boolean furtherDataAvailable = false;
    private ArrayList<BMbusPointData> activeDataInformation = new ArrayList();

    public MbusReceivedLongFrame(int[] inputMessage, BAbstractMbusNetwork inputNetwork, boolean allowMultipleMessages, int maxSpecialFunctionReads) {
        this.cField = inputMessage[4];
        this.aField = inputMessage[5];
        this.cIField = inputMessage[6];
        if (this.cIField == 120 || this.cIField == 122 || this.cIField == 114 || this.cIField == 118) {
            boolean mode2Active = false;
            if (this.cIField == 118) {
                mode2Active = true;
            }
            MbusDecodeVariableFrame variableData = new MbusDecodeVariableFrame(inputMessage, inputNetwork, null, allowMultipleMessages, mode2Active, maxSpecialFunctionReads);
            this.idBcdCoded = variableData.getIdentNumber();
            this.manufacturer = variableData.getManufacturer();
            this.versionNumber = variableData.getVersionNumber();
            this.deviceTypeId = variableData.getDeviceTypeId();
            this.access = variableData.getAccess();
            this.status = variableData.getStatus();
            this.secondaryAdd = variableData.getSecondaryAddress();
            this.fabNumber = variableData.getFabricationNumber();
            this.activeDataInformation = variableData.getData();
            this.storageBlockSize = variableData.getStorageBlockSize();
            this.storageBlockDate = variableData.getStorageBlockDate();
            this.storageBlockInterval = variableData.getStorageBlockInterval();
        }
    }

    public MbusReceivedLongFrame(MbusResponseMessage inputMessage, BAbstractMbusNetwork inputNetwork, BMbusDevice inputDevice, boolean allowMultipleMessages, int maxSpecialFunctionReads) {
        this(inputMessage, inputNetwork, inputDevice, allowMultipleMessages, maxSpecialFunctionReads, null);
    }

    public MbusReceivedLongFrame(MbusResponseMessage inputMessage, BAbstractMbusNetwork inputNetwork, BMbusDevice inputDevice, boolean allowMultipleMessages, int maxSpecialFunctionReads, MbusDecodeVariableFrame.DecoderOverrides decoderOverrides) {
        if (MbusLogInputOutput.log.isTraceOn()) {
            MbusLogInputOutput.log.trace("Input(FirstRecord):- " + inputMessage.toDebugString());
        }
        byte[] byteHold = inputMessage.getBytes();
        int[] intHold = new int[byteHold.length];
        for (int i = 0; i < byteHold.length; ++i) {
            intHold[i] = byteHold[i] & 0xFF;
        }
        this.cField = intHold[4];
        this.aField = intHold[5];
        this.cIField = intHold[6];
        if (inputNetwork != null) {
            inputNetwork.setPrimarySearchAddress(this.aField);
        }
        if (this.cIField == 120 || this.cIField == 122 || this.cIField == 114 || this.cIField == 118) {
            boolean mode2Active = false;
            if (this.cIField == 118) {
                mode2Active = true;
            }
            MbusDecodeVariableFrame variableData = new MbusDecodeVariableFrame(intHold, inputNetwork, inputDevice, allowMultipleMessages, mode2Active, maxSpecialFunctionReads, decoderOverrides);
            this.idBcdCoded = variableData.getIdentNumber();
            this.manufacturer = variableData.getManufacturer();
            this.versionNumber = variableData.getVersionNumber();
            this.deviceTypeId = variableData.getDeviceTypeId();
            this.access = variableData.getAccess();
            this.status = variableData.getStatus();
            this.secondaryAdd = variableData.getSecondaryAddress();
            this.fabNumber = variableData.getFabricationNumber();
            this.status5 = variableData.getStatusBit5();
            this.status6 = variableData.getStatusBit6();
            this.status7 = variableData.getStatusBit7();
            this.activeDataInformation = variableData.getData();
            this.storageBlockSize = variableData.getStorageBlockSize();
            this.storageBlockDate = variableData.getStorageBlockDate();
            this.storageBlockInterval = variableData.getStorageBlockInterval();
            this.manufacturersIndex = variableData.getManufacturersIndex();
            this.furtherDataAvailable = variableData.getSpecialFunctionFound();
        }
    }

    public String getIdentNumber() {
        return this.idBcdCoded;
    }

    public String getSecondaryAddress() {
        return this.secondaryAdd;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public BMbusDeviceTypeId getDeviceTypeId() {
        return this.deviceTypeId;
    }

    public int getAccess() {
        return this.access;
    }

    public String getStatus() {
        return this.status;
    }

    public ArrayList<BMbusPointData> getData() {
        return this.activeDataInformation;
    }

    public int getCField() {
        return this.cField;
    }

    @Override
    public int getPrimaryAddress() {
        return this.aField;
    }

    public int getCIField() {
        return this.cIField;
    }

    public long getStorageBlockSize() {
        return this.storageBlockSize;
    }

    public long getStorageBlockDate() {
        return this.storageBlockDate;
    }

    public long getStorageBlockInterval() {
        return this.storageBlockInterval;
    }

    public int getManufacturerIndex() {
        return this.manufacturersIndex;
    }

    public String getFabricationNumber() {
        return this.fabNumber;
    }

    public boolean getStatusBit5() {
        return this.status5;
    }

    public boolean getStatusBit6() {
        return this.status6;
    }

    public boolean getStatusBit7() {
        return this.status7;
    }

    public boolean getFurtherDataIndicated() {
        return this.furtherDataAvailable;
    }
}

