/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.actionArgSets.BSecondaryDiscoverOptions;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.jobs.BMbusSecondarySearchJob;
import com.tridium.mbus.jobs.BMbusTxRxProfile;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.types.BMbusSecondaryAddressFilters;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusTextUtil;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.Vector;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="networkOrd", type="BOrd", defaultValue="BOrd.NULL", override=true), @NiagaraProperty(name="discoveryOptions", type="BSecondaryDiscoverOptions", defaultValue="new BSecondaryDiscoverOptions()")})
public final class BMbusSecondaryAddressScanJob
extends BMbusSecondarySearchJob {
    @Generated
    public static final Property networkOrd = BMbusSecondaryAddressScanJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property discoveryOptions = BMbusSecondaryAddressScanJob.newProperty((int)0, (BValue)new BSecondaryDiscoverOptions(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusSecondaryAddressScanJob.class);
    private Object commLock;
    private double baseProgress = 0.0;
    private double progressPerScan = 100.0;

    @Generated
    public BSecondaryDiscoverOptions getDiscoveryOptions() {
        return (BSecondaryDiscoverOptions)this.get(discoveryOptions);
    }

    @Generated
    public void setDiscoveryOptions(BSecondaryDiscoverOptions v) {
        this.set(discoveryOptions, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusSecondaryAddressScanJob() {
    }

    public BMbusSecondaryAddressScanJob(BAbstractMbusNetwork inputNetwork) {
        this.network = inputNetwork;
    }

    @Override
    public void run(Context cx) throws Exception {
        this.commLock = "SecondaryAddressScan" + this.getHandle();
        try {
            this.doCommsLockedRun(cx, this.commLock);
        }
        catch (Throwable e) {
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Exception occurred during doCommsLockedRun", e);
            }
            this.network.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
            this.network.unlockSends(this.commLock);
            this.network = null;
            if (e instanceof JobCancelException) {
                throw (JobCancelException)e;
            }
        }
        finally {
            this.network.unlockSends(this.commLock);
            this.network = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doCommsLockedRun(Context cx, Object commLock) throws Exception {
        Vector<MBusTxTimings> timings;
        String[] addressesToScan;
        Object[] baudRatesToScan;
        block26: {
            MBusTxTimings txRxProfile;
            block25: {
                int filterVersionNumber;
                BMbusDeviceTypeId deviceId;
                int i;
                this.setJobState(BJobState.running);
                this.log().message(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.starting"));
                baudRatesToScan = this.getDiscoveryOptions().getBaudRates().getChildren(BBaudRate.class);
                this.network.getNetworkDatabase().clearJustDetected();
                if (baudRatesToScan.length == 0) {
                    if (!(this.network instanceof BMbusTcpIpNetwork)) {
                        this.log().message(MbusToolkit.getText("MbusNetworkDeviceSearch.noBaudRatesSpecified"));
                        throw new Exception("Baud rates must be set");
                    }
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.tcpipConverterSlowBaudSet", new Object[]{BMbusBaudRate.baud300.getTypeDisplayName(null)}));
                    baudRatesToScan = new BBaudRate[]{BMbusBaudRate.baud300};
                } else {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.baudRatesToScan", new Object[]{String.valueOf(baudRatesToScan.length)}));
                    for (int i2 = 0; i2 < baudRatesToScan.length; ++i2) {
                        this.log().message("-> " + ((BBaudRate)baudRatesToScan[i2]).getDisplayTag(cx));
                    }
                }
                addressesToScan = null;
                String addressesToScanStr = this.getDiscoveryOptions().getFilters().getSecondaryAddresses().trim();
                String[] addressSegments = TextUtil.splitAndTrim((String)addressesToScanStr, (char)',');
                Vector<String> locatedStrings = new Vector<String>();
                for (i = 0; i < addressSegments.length; ++i) {
                    long finish;
                    if (addressSegments[i].indexOf(45) == -1) {
                        locatedStrings.add(addressSegments[i]);
                        continue;
                    }
                    String[] addressBoundaries = TextUtil.splitAndTrim((String)addressSegments[i], (char)'-');
                    long start = Long.parseLong(addressBoundaries[0]);
                    if (start == (finish = Long.parseLong(addressBoundaries[1]))) {
                        locatedStrings.add(TextUtil.padZeros((String)String.valueOf(start), (int)8));
                        continue;
                    }
                    while (start != finish + 1L) {
                        locatedStrings.add(TextUtil.padZeros((String)String.valueOf(start), (int)8));
                        ++start;
                    }
                }
                addressesToScan = new String[locatedStrings.size()];
                for (i = 0; i < locatedStrings.size(); ++i) {
                    addressesToScan[i] = (String)locatedStrings.get(i);
                }
                locatedStrings.clear();
                this.getDiscoveryOptions().getFilters().setManufacturer(this.getDiscoveryOptions().getFilters().getManufacturer().toUpperCase());
                String manufacturerFilter = this.getDiscoveryOptions().getFilters().getManufacturer();
                if (manufacturerFilter != null && manufacturerFilter.length() == 3) {
                    this.log().message(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.manSpecIdFilter", new Object[]{manufacturerFilter}));
                }
                if (!(deviceId = this.getDiscoveryOptions().getFilters().getDeviceTypeId()).equals(BMbusSecondaryAddressFilters.deviceTypeId.getDefaultValue())) {
                    this.log().message(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.deviceIdFilter", new Object[]{deviceId.getDisplayTag(cx)}));
                }
                if ((filterVersionNumber = this.getDiscoveryOptions().getFilters().getVersionNumber()) != 0) {
                    this.log().message(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.versionNoFilter", new Object[]{String.valueOf(filterVersionNumber), "[0x" + TextUtil.byteToHexString((int)(filterVersionNumber & 0xFF)).toUpperCase() + "]"}));
                }
                this.log().message(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.scanningAddresses", new Object[]{this.getDiscoveryOptions().getFilters().getSecondaryAddresses().trim()}));
                this.log().message(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.identAddressesToScan", new Object[]{String.valueOf(addressesToScan.length)}));
                for (int i3 = 0; i3 < addressesToScan.length; ++i3) {
                    this.log().message("-> " + addressesToScan[i3]);
                }
                if (this.getDiscoveryOptions().getFilters().getOptimiseSpeeds()) {
                    this.log().message(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.optimiseSpeedsSet"));
                }
                timings = new Vector<MBusTxTimings>();
                txRxProfile = this.getDiscoveryOptions().getTxRxProfile().getMBusTxTimings();
                MBusTxTimings standard = BMbusTxRxProfile.getStandardMBusTxTimings();
                MBusTxTimings slow = BMbusTxRxProfile.getSlowMBusTxTimings();
                if (!this.getDiscoveryOptions().getFilters().getOptimiseSpeeds()) break block25;
                if (!txRxProfile.timingsMatch(standard) && txRxProfile.timingsMatch(slow)) {
                    timings.add(slow);
                    timings.add(standard);
                    timings.add(txRxProfile);
                    break block26;
                } else if (txRxProfile.timingsMatch(standard)) {
                    timings.add(slow);
                    timings.add(standard);
                }
                break block26;
            }
            timings.add(txRxProfile);
        }
        MBusTxTimings[] timingsToTry = new MBusTxTimings[timings.size()];
        for (int i = 0; i < timings.size(); ++i) {
            timingsToTry[i] = (MBusTxTimings)timings.get(i);
        }
        this.network.lockSends(commLock);
        this.network.getNetworkDatabase().setActiveDiscovery((BJob)this);
        this.cancelInProgress = false;
        byte[] baseAddressData = BMbusSecondaryAddressScanJob.generateExtendedAddress(this.getDiscoveryOptions().getFilters());
        this.baseProgress = 0.0;
        this.progressPerScan = 100.0 / (double)(baudRatesToScan.length * addressesToScan.length);
        int brIdx = 0;
        while (true) {
            if (brIdx < baudRatesToScan.length && !this.getCancelInProgress()) {
                BBaudRate currentScanBaudRate = (BBaudRate)baudRatesToScan[brIdx];
                if (currentScanBaudRate instanceof BMbusBaudRate) {
                    this.network.setSearchBaudRate((BMbusBaudRate)currentScanBaudRate);
                }
                this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.startingBaudRateScan", new Object[]{currentScanBaudRate}));
            } else {
                this.network.getNetworkDatabase().clearJustDetected();
                Object[] dbHandleOrds = this.detectedDevices.toArray();
                for (int i = 0; i < dbHandleOrds.length; ++i) {
                    ((BMbusDeviceData)BOrd.make((String)((String)dbHandleOrds[i])).get((BObject)this)).setJustDetected(true);
                }
                this.detectedDevices.clear();
                this.network.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
                if (this.getJobState().equals((Object)BJobState.canceling)) {
                    throw new JobCancelException();
                }
                return;
            }
            for (int i = 0; i < addressesToScan.length && !this.getCancelInProgress(); ++i) {
                this.scanForDevice(addressesToScan[i], timingsToTry, baseAddressData);
                this.baseProgress = this.progressPerScan * (double)(i + 1 * brIdx + 1);
                this.progress((int)this.baseProgress);
            }
            ++brIdx;
        }
    }

    private static byte[] generateExtendedAddress(BMbusSecondaryAddressFilters inputFilters) {
        int manufacturersCode = 0;
        int version = -1;
        int deviceId = -1;
        byte[] manuBytes = new byte[]{-1, -1};
        if (inputFilters != null) {
            String manufacturer = inputFilters.getManufacturer();
            if (manufacturer != null && manufacturer.length() == 3) {
                manufacturersCode = (manufacturer.charAt(0) - 64) * 32 * 32 + (manufacturer.charAt(1) - 64) * 32 + (manufacturer.charAt(2) - 64);
                manuBytes[0] = (byte)(manufacturersCode & 0xFF);
                manuBytes[1] = (byte)(manufacturersCode >> 8 & 0xFF);
            }
            if (!inputFilters.getDeviceTypeId().equals(BMbusSecondaryAddressFilters.deviceTypeId.getDefaultValue())) {
                deviceId = (byte)inputFilters.getDeviceTypeId().getOrdinal();
            }
            if (inputFilters.getVersionNumber() != 0) {
                version = (byte)inputFilters.getVersionNumber();
            }
        }
        byte[] outputData = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        outputData[4] = manuBytes[0];
        outputData[5] = manuBytes[1];
        outputData[6] = version;
        outputData[7] = deviceId;
        return outputData;
    }

    private void scanForDevice(String secondaryAddress, MBusTxTimings[] timingsToScan, byte[] extendedAddressMaskSetup) {
        int totalSteps = 3 * timingsToScan.length;
        double progressPerStep = this.progressPerScan / (double)totalSteps;
        double activeProgress = this.baseProgress;
        boolean successfullyDetectedDevice = false;
        extendedAddressMaskSetup[0] = (byte)(MbusTextUtil.hexCharToInt(secondaryAddress.charAt(6)) << 4 | MbusTextUtil.hexCharToInt(secondaryAddress.charAt(7)));
        extendedAddressMaskSetup[1] = (byte)(MbusTextUtil.hexCharToInt(secondaryAddress.charAt(4)) << 4 | MbusTextUtil.hexCharToInt(secondaryAddress.charAt(5)));
        extendedAddressMaskSetup[2] = (byte)(MbusTextUtil.hexCharToInt(secondaryAddress.charAt(2)) << 4 | MbusTextUtil.hexCharToInt(secondaryAddress.charAt(3)));
        extendedAddressMaskSetup[3] = (byte)(MbusTextUtil.hexCharToInt(secondaryAddress.charAt(0)) << 4 | MbusTextUtil.hexCharToInt(secondaryAddress.charAt(1)));
        this.log().message(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.scanningForAddress", new Object[]{secondaryAddress, "[0x" + TextUtil.padZeros((String)TextUtil.bytesToHexString((byte[])extendedAddressMaskSetup), (int)16).toUpperCase() + "]"}));
        for (int timingIndex = 0; timingIndex < timingsToScan.length; ++timingIndex) {
            MBusTxTimings searchTimings = timingsToScan[timingIndex];
            MbusSndNkeMessage sendNkeMsg = new MbusSndNkeMessage(null, this.network, 255);
            sendNkeMsg.setResponseExpected(false);
            sendNkeMsg.setMessageBaudRate(this.network.getSearchBaudRate());
            sendNkeMsg.handleCorruptBuffers();
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.initNoReply"));
            }
            long minRxTxTimes = MBusTxTimings.calculateTxRxTime(sendNkeMsg, (BBaudRate)this.network.getSearchBaudRate());
            int reqSendNkes = Math.max(3, searchTimings.retryTransmission);
            this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.sendingSndNkes", new Object[]{String.valueOf(reqSendNkes)}));
            for (int i = 0; i < reqSendNkes; ++i) {
                this.network.sendMBusSync(searchTimings, this.commLock, sendNkeMsg, minRxTxTimes);
            }
            this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.sentSndNkes", new Object[]{String.valueOf(reqSendNkes)}));
            this.network.setSearchFcBitState(true);
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace(MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.endInitNoReply"));
            }
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.initDelay"));
            }
            this.initialiseDelay(searchTimings.initialisationDelay.getSeconds());
            this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.initSecondsDelayDone", new Object[]{String.valueOf(searchTimings.initialisationDelay.getSeconds())}));
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace(MbusToolkit.getText("BMbusNetworkSecondarySearchJob.endInitDelay"));
            }
            this.progress((int)(activeProgress += progressPerStep));
            if (this.getCancelInProgress()) {
                return;
            }
            this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondarySearchJob.scanningWithSelector", new Object[]{TextUtil.padZeros((String)TextUtil.bytesToHexString((byte[])extendedAddressMaskSetup), (int)16).toUpperCase()}));
            MbusResponseMessage selectorResult = null;
            MbusSndUdMessage message = new MbusSndUdMessage(extendedAddressMaskSetup);
            message.handleCorruptBuffers();
            message.setMessageBaudRate(this.network.getSearchBaudRate());
            minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.network.getSearchBaudRate());
            selectorResult = (MbusResponseMessage)this.network.sendMBusSync(searchTimings, this.commLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.network.getSearchBaudRate()));
            this.progress((int)(activeProgress += progressPerStep));
            if (selectorResult == null || selectorResult.getCollisionDetected() || !selectorResult.getSuccessfulResponse()) {
                this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.failedAddressSelection"));
                continue;
            }
            this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.oneOrMoreDevicesSelected"));
            this.network.setSearchFcBitState(true);
            if (this.getCancelInProgress()) {
                return;
            }
            BMbusConfig config = new BMbusConfig();
            config.setResponseTimeout(searchTimings.responseTimeout);
            config.setInitialisationDelay((BRelTime)searchTimings.initialisationDelay.newCopy());
            config.setRetryCount(searchTimings.retryTransmission);
            config.setInterMessageDelay(BRelTime.make((long)searchTimings.intermessageDelay));
            config.setOverrideNetwork(true);
            this.networkManager = this.network.getNetworkDatabase();
            int result = this.getAllTheData(this.commLock, config);
            this.networkManager = null;
            if (result <= 0) {
                this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.failedReadingDataFromDevice"));
                continue;
            }
            this.logMessage(0, MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.readDataFromDevice"));
            successfullyDetectedDevice = true;
            this.progress((int)(activeProgress += progressPerStep));
            if (!this.getCancelInProgress()) continue;
            return;
        }
        if (successfullyDetectedDevice) {
            this.log().success(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.deviceScanSuccess", new Object[]{secondaryAddress}));
        } else {
            this.log().failed(MbusToolkit.lex.getText("BMbusNetworkSecondaryDirectJob.deviceScanFailure", new Object[]{secondaryAddress}));
        }
    }

    @Override
    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
        this.cancelInProgress = true;
    }
}

