/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.Date;
import java.util.HashSet;
import javax.baja.driver.BDevice;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="networkOrd", type="BOrd", defaultValue="BOrd.NULL")
@NiagaraTopic(name="deviceFoundAtAddress", eventType="BInteger", flags=4)
public final class BMbusDeviceSearchJob
extends BSimpleJob {
    @Generated
    public static final Property networkOrd = BMbusDeviceSearchJob.newProperty((int)0, (BValue)BOrd.NULL, null);
    @Generated
    public static final Topic deviceFoundAtAddress = BMbusDeviceSearchJob.newTopic((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusDeviceSearchJob.class);
    BAbstractMbusNetwork network = null;
    BMbusNetworkDatabase networkManager = null;
    int[] addrs = null;
    JobLog log = null;
    boolean cancelInProgress = true;
    MBusTxTimings overrideTxTimings = null;
    int numberOfDetectedDevices = 0;
    HashSet<String> detectedDevices = new HashSet();
    private Object commLock;

    @Generated
    public BOrd getNetworkOrd() {
        return (BOrd)this.get(networkOrd);
    }

    @Generated
    public void setNetworkOrd(BOrd v) {
        this.set(networkOrd, (BValue)v, null);
    }

    @Generated
    public void fireDeviceFoundAtAddress(BInteger event) {
        this.fire(deviceFoundAtAddress, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusDeviceSearchJob() {
    }

    public BMbusDeviceSearchJob(BAbstractMbusNetwork network, int start, int end, JobLog log) {
        this.network = network;
        this.networkManager = network.getNetworkDatabase();
        this.cancelInProgress = false;
        this.log = this.log();
        this.addrs = new int[end - start + 1];
        for (int i = 0; i < this.addrs.length; ++i) {
            this.addrs[i] = start + i;
        }
    }

    public BMbusDeviceSearchJob(BAbstractMbusNetwork network, int[] addrs, JobLog log) {
        this.network = network;
        this.networkManager = network.getNetworkDatabase();
        this.cancelInProgress = false;
        this.addrs = addrs;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        boolean independentJob;
        boolean bl = independentJob = this.commLock == null;
        if (this.networkManager != null) {
            if (independentJob) {
                this.commLock = "primaryDevSearchJob" + this.getHandle();
            }
            try {
                this.searchForNewDevice(this.commLock);
                if (independentJob) {
                    this.network.unlockSends(this.commLock);
                }
                this.network = null;
                this.networkManager = null;
                this.overrideTxTimings = null;
                this.commLock = null;
            }
            catch (Throwable t) {
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Exception occurred during run", t);
                }
                if (independentJob) {
                    this.network.unlockSends(this.commLock);
                }
                this.network = null;
                this.networkManager = null;
                this.overrideTxTimings = null;
                this.commLock = null;
            }
            finally {
                if (independentJob) {
                    this.network.unlockSends(this.commLock);
                }
                this.network = null;
                this.networkManager = null;
                this.overrideTxTimings = null;
                this.commLock = null;
            }
        }
        this.progress(100);
    }

    public void searchForNewDevice(Object localCommLock) {
        if (this.getCancelInProgress()) {
            return;
        }
        int cycleQuantity = 1;
        boolean[] detectedPrimaryDevices = new boolean[this.addrs.length];
        MbusResponseMessage rsp = null;
        MbusSndNkeMessage message = null;
        MBusTxTimings searchTimings = new MBusTxTimings();
        if (this.overrideTxTimings != null) {
            searchTimings = this.overrideTxTimings;
        } else {
            searchTimings.intermessageDelay = 1000L;
            searchTimings.retryTransmission = 2;
            searchTimings.responseTimeout = BRelTime.makeSeconds((int)1);
            searchTimings.initialisationDelay = BRelTime.makeSeconds((int)2);
        }
        BMbusConfig txRxMbusConfig = new BMbusConfig();
        txRxMbusConfig.setInitialisationDelay(BRelTime.make((long)Math.max(searchTimings.initialisationDelay.getMillis(), 2000L)));
        txRxMbusConfig.setRetryCount(Math.max(searchTimings.retryTransmission, 2));
        txRxMbusConfig.setResponseTimeout(BRelTime.make((long)Math.max(searchTimings.responseTimeout.getMillis(), 2000L)));
        txRxMbusConfig.setInterMessageDelay(BRelTime.make((long)Math.max(300L, searchTimings.intermessageDelay)));
        if (this.addrs[0] == 254) {
            this.progress(5);
            message = new MbusSndNkeMessage(null, this.network, 255);
            message.setResponseExpected(false);
            message.handleCorruptBuffers();
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Initialisation Request No Response Expected (SndNke)");
            }
            long minRxTxTimes = MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.network.getSearchBaudRate());
            for (int i = 0; i < searchTimings.retryTransmission; ++i) {
                this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearch.sendingNoReplyInit"));
                rsp = (MbusResponseMessage)this.network.sendMBusSync(searchTimings, localCommLock, message, minRxTxTimes);
            }
            this.network.setSearchFcBitState(true);
            this.initialiseDelay(searchTimings.initialisationDelay.getSeconds());
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceSearch"));
            this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceSearch"));
            MbusReqUd2Message allReplyMessage = new MbusReqUd2Message(this.addrs[0], this.network);
            allReplyMessage.handleCorruptBuffers();
            allReplyMessage.setMessageBaudRate(this.network.getSearchBaudRate());
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("All Reply Request output ");
            }
            minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.network.getSearchBaudRate());
            rsp = (MbusResponseMessage)this.network.sendMBusSync(this.network.getActiveTxTimings(), localCommLock, allReplyMessage, minRxTxTimes += MBusTxTimings.calculateTxRxTime(allReplyMessage, (BBaudRate)this.network.getSearchBaudRate()));
            if (rsp != null && rsp.getSuccessfulResponse() && rsp.getLength() > 10) {
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("All Reply Response Received");
                }
                this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearch.responseReceived"));
                ++this.numberOfDetectedDevices;
                MbusReceivedLongFrame longFrameMessage = new MbusReceivedLongFrame(rsp, this.network, null, true, 0);
                int address = longFrameMessage.getPrimaryAddress();
                this.network.setPrimarySearchAddress(address);
                String secondaryAddress = longFrameMessage.getSecondaryAddress();
                BDevice[] devices = this.network.getDevices();
                BMbusDevice existingMbusDevice = null;
                for (int i = 0; i < devices.length; ++i) {
                    existingMbusDevice = (BMbusDevice)devices[i];
                    if (existingMbusDevice.getPrimaryAddress() != address || !existingMbusDevice.getSecondaryAddress().equals(secondaryAddress)) continue;
                    cycleQuantity = existingMbusDevice.getCycleQuantity();
                    break;
                }
                for (int j = 0; j < cycleQuantity; ++j) {
                    this.networkManager.addDeviceData(this.detectedDevices, longFrameMessage, j, this.network.getSearchBaudRate(), null, BMbusAddressing.primary, txRxMbusConfig);
                }
            } else {
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("All Reply Response Not Received");
                }
                this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearch.noResponseReceived"));
            }
            this.progress(100);
        } else {
            this.progress(5);
            double progressPerDevice = 95.0 / (double)(this.addrs.length + 1);
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.InitNetworkDelay"));
            this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.InitNetworkDelay"));
            message = new MbusSndNkeMessage(null, this.network, 255);
            message.setResponseExpected(false);
            message.handleCorruptBuffers();
            message.setMessageBaudRate(this.network.getSearchBaudRate());
            long minRxTxTimes = MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.network.getSearchBaudRate());
            this.network.sendMBusSync(searchTimings, localCommLock, message, minRxTxTimes);
            if (this.getCancelInProgress()) {
                return;
            }
            this.initialiseDelay(this.network.getActiveTxTimings().initialisationDelay.getSeconds());
            this.numberOfDetectedDevices = 0;
            double baseProgress = 5.0;
            for (int j = 0; j < this.addrs.length; ++j) {
                this.network.setPrimarySearchAddress(this.addrs[j]);
                if (this.getCancelInProgress()) {
                    return;
                }
                this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceSearch") + " " + this.addrs[j]);
                this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceSearch") + " " + this.addrs[j]);
                message = new MbusSndNkeMessage(null, this.network, this.addrs[j]);
                message.handleCorruptBuffers();
                message.setMessageBaudRate(this.network.getSearchBaudRate());
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.network.getSearchBaudRate());
                rsp = (MbusResponseMessage)this.network.sendMBusSync(this.network.getActiveTxTimings(), localCommLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.network.getSearchBaudRate()));
                if (this.getCancelInProgress()) {
                    return;
                }
                if (rsp != null && rsp.getSuccessfulResponse()) {
                    this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.FoundDevice") + " " + this.addrs[j]);
                    this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.FoundDevice") + " " + this.addrs[j]);
                    this.fireDeviceFoundAtAddress(BInteger.make((int)j));
                    detectedPrimaryDevices[j] = true;
                    ++this.numberOfDetectedDevices;
                    continue;
                }
                detectedPrimaryDevices[j] = false;
                this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceNotFound") + " " + this.addrs[j]);
                this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.DeviceNotFound") + " " + this.addrs[j]);
                this.progress((int)(baseProgress += progressPerDevice));
            }
            if (this.numberOfDetectedDevices > 0) {
                for (int k = 0; k < this.addrs.length; ++k) {
                    this.network.setSearchFcBitState(true);
                    if (this.getCancelInProgress()) {
                        return;
                    }
                    if (!detectedPrimaryDevices[k]) continue;
                    BDevice[] devices = this.network.getDevices();
                    BMbusDevice mbusDevice = null;
                    BMbusDevice mbusDevice2 = null;
                    for (int i = 0; i < devices.length; ++i) {
                        mbusDevice2 = (BMbusDevice)devices[i];
                        if (mbusDevice2.getPrimaryAddress() != this.addrs[k]) continue;
                        cycleQuantity = mbusDevice2.getCycleQuantity();
                        mbusDevice = (BMbusDevice)devices[i];
                        mbusDevice.setFcBitState(true);
                        break;
                    }
                    this.getAllTheData(localCommLock, this.addrs[k], 0L, baseProgress, progressPerDevice, cycleQuantity, mbusDevice, txRxMbusConfig);
                }
            }
        }
    }

    private int getAllTheData(Object localCommLock, int primaryAddress, long secondaryAddress, double progressBase, double progressIncrement, int cycleQty, BMbusDevice mbusDevice, BMbusConfig txRxMbusConfig) {
        MbusReceivedLongFrame longFrameMessage = null;
        MbusResponseMessage rsp = null;
        int recordsAdded = 0;
        MbusReqUd2Message message = null;
        for (int i = 0; i < cycleQty; ++i) {
            message = mbusDevice != null ? new MbusReqUd2Message(mbusDevice, this.network) : (primaryAddress <= 250 ? new MbusReqUd2Message(primaryAddress, this.network) : new MbusReqUd2Message(this.network.getPrimarySearchAddress(), this.network));
            message.handleCorruptBuffers();
            message.setMessageBaudRate(this.network.getSearchBaudRate());
            if (this.getCancelInProgress()) {
                return 0;
            }
            this.progress((int)(progressBase + progressIncrement * 0.5));
            long minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.network.getSearchBaudRate());
            rsp = (MbusResponseMessage)this.network.sendMBusSync(this.network.getActiveTxTimings(), localCommLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.network.getSearchBaudRate()));
            if (rsp == null || !rsp.getSuccessfulResponse() || rsp.getLength() <= 10) continue;
            longFrameMessage = new MbusReceivedLongFrame(rsp, this.network, mbusDevice, true, 0);
            recordsAdded += this.networkManager.addDeviceData(this.detectedDevices, longFrameMessage, i, this.network.getSearchBaudRate(), null, BMbusAddressing.primary, txRxMbusConfig);
        }
        this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.searchCompleted"));
        this.logMessage(0, MbusToolkit.getText("MbusNetworkDeviceSearchJob.searchCompleted"));
        return recordsAdded;
    }

    public void success() {
        if (!this.cancelInProgress) {
            super.success();
        } else {
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.searchCanceled"));
        }
    }

    public void doCancel(Context cx) {
        try {
            this.cancelInProgress = true;
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.searchCanceling"));
            this.canceled();
            this.complete(BJobState.canceled);
        }
        catch (Exception e) {
            this.networkManager.setStatusMessage(MbusToolkit.getText("MbusNetworkDeviceSearchJob.errorCanceling"));
        }
    }

    public boolean getCancelInProgress() {
        return this.cancelInProgress;
    }

    public void logMessage(int jLobItemId, String messageText) {
        this.log().add(new JobLogItem(jLobItemId, messageText));
        if (this.log != null) {
            String prefix = "--> ";
            this.log.add(new JobLogItem(jLobItemId, prefix + messageText));
        }
    }

    public void initialiseDelay(int seconds) {
        Date entryDate = new Date();
        long entryTime = entryDate.getTime() / 1000L;
        boolean delay = true;
        while (delay && !this.cancelInProgress) {
            Date currentDate = new Date();
            long currentTime = currentDate.getTime() / 1000L;
            if (currentTime - entryTime <= (long)seconds) continue;
            delay = false;
        }
    }

    public void setOverrideTxTimings(MBusTxTimings newTimings) {
        this.overrideTxTimings = newTimings;
    }

    public int getNumberOfDetectedDevices() {
        return this.numberOfDetectedDevices;
    }

    public HashSet<String> getDetectedDevicesHandleOrds() {
        HashSet<String> result = this.detectedDevices;
        this.detectedDevices = null;
        return result;
    }

    public void overrideCommLock(Object newCommLock) {
        this.commLock = newCommLock;
    }
}

