/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.BBasicDevice;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.BMbusDeviceFolder;
import com.tridium.mbus.BMbusNetwork;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.actionArgSets.BLivePointSearchDiscoverOptions;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.db.BMbusNetworkDatabase;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusAppReset;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusHeaderTypes;
import com.tridium.mbus.enums.BMbusTestControl;
import com.tridium.mbus.history.BMbusHistoryDeviceExt;
import com.tridium.mbus.jobs.BMbusAssignAddressJob;
import com.tridium.mbus.jobs.BMbusLivePointSearchDiscoveryJob;
import com.tridium.mbus.messages.MbusLongFrameMessage;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.messages.MbusReqSkeMessage;
import com.tridium.mbus.messages.MbusReqUd1Message;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndNkeMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.point.BMbusPointDeviceExt;
import com.tridium.mbus.types.BMbusCommand;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="mbusConfig", type="BMbusConfig", defaultValue="new BMbusConfig()", flags=264), @NiagaraProperty(name="modelName", type="String", defaultValue=""), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="baudRate", type="BMbusBaudRate", defaultValue="BMbusBaudRate.baud300"), @NiagaraProperty(name="primaryAddress", type="int", defaultValue="0", facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(MbusConst.MIN_PRIMARY), BFacets.MAX, BInteger.make(MbusConst.MAX_PRIMARY), BFacets.FIELD_WIDTH, BInteger.make(3))")}), @NiagaraProperty(name="secondaryAddress", type="String", defaultValue="", facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(16))")}), @NiagaraProperty(name="addressMode", type="BMbusAddressing", defaultValue="BMbusAddressing.primary"), @NiagaraProperty(name="cycleQuantity", type="int", defaultValue="1", flags=5), @NiagaraProperty(name="resetRequired", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="resetRequiredForPing", type="boolean", defaultValue="true", flags=4), @NiagaraProperty(name="inhibitPing", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="fcBitState", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="fcBitInUse", type="boolean", defaultValue="true"), @NiagaraProperty(name="reqSkeCapable", type="boolean", defaultValue="false"), @NiagaraProperty(name="identNumber", type="String", defaultValue="", flags=1, facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(8))")}), @NiagaraProperty(name="manufacturer", type="String", defaultValue="", flags=1, facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(3))")}), @NiagaraProperty(name="manufString", type="String", defaultValue="", flags=4), @NiagaraProperty(name="versionNumber", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="deviceTypeId", type="BMbusDeviceTypeId", defaultValue="BMbusDeviceTypeId.other"), @NiagaraProperty(name="applicationResetType", type="BMbusAppReset", defaultValue="BMbusAppReset.all", flags=4), @NiagaraProperty(name="subTelegramNumber", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="history", type="BMbusHistoryDeviceExt", defaultValue="new BMbusHistoryDeviceExt()"), @NiagaraProperty(name="points", type="BMbusPointDeviceExt", defaultValue="new BMbusPointDeviceExt()"), @NiagaraProperty(name="headerType", type="BMbusHeaderTypes", defaultValue="BMbusHeaderTypes.asMessage"), @NiagaraProperty(name="maxInputsPerCycleCount", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="allowMultipleRecords", type="boolean", defaultValue="true", flags=5), @NiagaraProperty(name="maxSpecialFunctionReads", type="int", defaultValue="1000", flags=5), @NiagaraProperty(name="commandHidden", type="BMbusCommand", defaultValue="new BMbusCommand()", flags=4), @NiagaraProperty(name="fabricationNumber", type="String", defaultValue="", flags=1, facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(8))")}), @NiagaraProperty(name="readoutModeNumber", type="int", defaultValue="0", flags=1, facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(2))")}), @NiagaraProperty(name="mbusMeterStatusDescription", type="String", defaultValue="No status Input", flags=1), @NiagaraProperty(name="manufacturerStatusBit5", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="manufacturerStatusBit6", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="manufacturerStatusBit7", type="boolean", defaultValue="false", flags=5)})
@NiagaraActions(value={@NiagaraAction(name="resetDatalink", flags=16), @NiagaraAction(name="resetApplication", flags=16), @NiagaraAction(name="removeFromDatabase", flags=16), @NiagaraAction(name="alarmProtocol", flags=16), @NiagaraAction(name="assignAddress", parameterType="BInteger", defaultValue="BInteger.DEFAULT", flags=128, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(MbusConst.MIN_PRIMARY), BFacets.MAX, BInteger.make(MbusConst.MAX_PRIMARY))")}), @NiagaraAction(name="calculateTimeForConcurrentReads", parameterType="BInteger", defaultValue="BInteger.make(0)", returnType="BRelTime", flags=2052), @NiagaraAction(name="submitLivePointsDiscoveryJob", parameterType="BLivePointSearchDiscoverOptions", defaultValue="new BLivePointSearchDiscoverOptions()", returnType="BOrd", flags=4), @NiagaraAction(name="optimiseReads", flags=280)})
public final class BMbusDevice
extends BBasicDevice {
    @Generated
    public static final Property mbusConfig = BMbusDevice.newProperty((int)264, (BValue)new BMbusConfig(), null);
    @Generated
    public static final Property modelName = BMbusDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property pollFrequency = BMbusDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property baudRate = BMbusDevice.newProperty((int)0, (BValue)BMbusBaudRate.baud300, null);
    @Generated
    public static final Property primaryAddress = BMbusDevice.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250), (String)"fieldWidth", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property secondaryAddress = BMbusDevice.newProperty((int)0, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)16)));
    @Generated
    public static final Property addressMode = BMbusDevice.newProperty((int)0, (BValue)BMbusAddressing.primary, null);
    @Generated
    public static final Property cycleQuantity = BMbusDevice.newProperty((int)5, (int)1, null);
    @Generated
    public static final Property resetRequired = BMbusDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property resetRequiredForPing = BMbusDevice.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Property inhibitPing = BMbusDevice.newProperty((int)4, (boolean)false, null);
    @Generated
    public static final Property fcBitState = BMbusDevice.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property fcBitInUse = BMbusDevice.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property reqSkeCapable = BMbusDevice.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property identNumber = BMbusDevice.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)8)));
    @Generated
    public static final Property manufacturer = BMbusDevice.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property manufString = BMbusDevice.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property versionNumber = BMbusDevice.newProperty((int)4, (int)0, null);
    @Generated
    public static final Property deviceTypeId = BMbusDevice.newProperty((int)0, (BValue)BMbusDeviceTypeId.other, null);
    @Generated
    public static final Property applicationResetType = BMbusDevice.newProperty((int)4, (BValue)BMbusAppReset.all, null);
    @Generated
    public static final Property subTelegramNumber = BMbusDevice.newProperty((int)4, (int)0, null);
    @Generated
    public static final Property history = BMbusDevice.newProperty((int)0, (BValue)new BMbusHistoryDeviceExt(), null);
    @Generated
    public static final Property points = BMbusDevice.newProperty((int)0, (BValue)new BMbusPointDeviceExt(), null);
    @Generated
    public static final Property headerType = BMbusDevice.newProperty((int)0, (BValue)BMbusHeaderTypes.asMessage, null);
    @Generated
    public static final Property maxInputsPerCycleCount = BMbusDevice.newProperty((int)4, (int)0, null);
    @Generated
    public static final Property allowMultipleRecords = BMbusDevice.newProperty((int)5, (boolean)true, null);
    @Generated
    public static final Property maxSpecialFunctionReads = BMbusDevice.newProperty((int)5, (int)1000, null);
    @Generated
    public static final Property commandHidden = BMbusDevice.newProperty((int)4, (BValue)new BMbusCommand(), null);
    @Generated
    public static final Property fabricationNumber = BMbusDevice.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)8)));
    @Generated
    public static final Property readoutModeNumber = BMbusDevice.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    @Generated
    public static final Property mbusMeterStatusDescription = BMbusDevice.newProperty((int)1, (String)"No status Input", null);
    @Generated
    public static final Property manufacturerStatusBit5 = BMbusDevice.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property manufacturerStatusBit6 = BMbusDevice.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property manufacturerStatusBit7 = BMbusDevice.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Action resetDatalink = BMbusDevice.newAction((int)16, null);
    @Generated
    public static final Action resetApplication = BMbusDevice.newAction((int)16, null);
    @Generated
    public static final Action removeFromDatabase = BMbusDevice.newAction((int)16, null);
    @Generated
    public static final Action alarmProtocol = BMbusDevice.newAction((int)16, null);
    @Generated
    public static final Action assignAddress = BMbusDevice.newAction((int)128, (BValue)BInteger.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)250)));
    @Generated
    public static final Action calculateTimeForConcurrentReads = BMbusDevice.newAction((int)2052, (BValue)BInteger.make((int)0), null);
    @Generated
    public static final Action submitLivePointsDiscoveryJob = BMbusDevice.newAction((int)4, (BValue)new BLivePointSearchDiscoverOptions(), null);
    @Generated
    public static final Action optimiseReads = BMbusDevice.newAction((int)280, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusDevice.class);
    MBusTxTimings networkTxTimings = null;
    private int optimisesQueued = 0;
    private final Object optimisedVarsSyncLock = new Object();

    @Generated
    public BMbusConfig getMbusConfig() {
        return (BMbusConfig)this.get(mbusConfig);
    }

    @Generated
    public void setMbusConfig(BMbusConfig v) {
        this.set(mbusConfig, (BValue)v, null);
    }

    @Generated
    public String getModelName() {
        return this.getString(modelName);
    }

    @Generated
    public void setModelName(String v) {
        this.setString(modelName, v, null);
    }

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BMbusBaudRate getBaudRate() {
        return (BMbusBaudRate)this.get(baudRate);
    }

    @Generated
    public void setBaudRate(BMbusBaudRate v) {
        this.set(baudRate, (BValue)v, null);
    }

    @Generated
    public int getPrimaryAddress() {
        return this.getInt(primaryAddress);
    }

    @Generated
    public void setPrimaryAddress(int v) {
        this.setInt(primaryAddress, v, null);
    }

    @Generated
    public String getSecondaryAddress() {
        return this.getString(secondaryAddress);
    }

    @Generated
    public void setSecondaryAddress(String v) {
        this.setString(secondaryAddress, v, null);
    }

    @Generated
    public BMbusAddressing getAddressMode() {
        return (BMbusAddressing)this.get(addressMode);
    }

    @Generated
    public void setAddressMode(BMbusAddressing v) {
        this.set(addressMode, (BValue)v, null);
    }

    @Generated
    public int getCycleQuantity() {
        return this.getInt(cycleQuantity);
    }

    @Generated
    public void setCycleQuantity(int v) {
        this.setInt(cycleQuantity, v, null);
    }

    @Generated
    public boolean getResetRequired() {
        return this.getBoolean(resetRequired);
    }

    @Generated
    public void setResetRequired(boolean v) {
        this.setBoolean(resetRequired, v, null);
    }

    @Generated
    public boolean getResetRequiredForPing() {
        return this.getBoolean(resetRequiredForPing);
    }

    @Generated
    public void setResetRequiredForPing(boolean v) {
        this.setBoolean(resetRequiredForPing, v, null);
    }

    @Generated
    public boolean getInhibitPing() {
        return this.getBoolean(inhibitPing);
    }

    @Generated
    public void setInhibitPing(boolean v) {
        this.setBoolean(inhibitPing, v, null);
    }

    @Generated
    public boolean getFcBitState() {
        return this.getBoolean(fcBitState);
    }

    @Generated
    public void setFcBitState(boolean v) {
        this.setBoolean(fcBitState, v, null);
    }

    @Generated
    public boolean getFcBitInUse() {
        return this.getBoolean(fcBitInUse);
    }

    @Generated
    public void setFcBitInUse(boolean v) {
        this.setBoolean(fcBitInUse, v, null);
    }

    @Generated
    public boolean getReqSkeCapable() {
        return this.getBoolean(reqSkeCapable);
    }

    @Generated
    public void setReqSkeCapable(boolean v) {
        this.setBoolean(reqSkeCapable, v, null);
    }

    @Generated
    public String getIdentNumber() {
        return this.getString(identNumber);
    }

    @Generated
    public void setIdentNumber(String v) {
        this.setString(identNumber, v, null);
    }

    @Generated
    public String getManufacturer() {
        return this.getString(manufacturer);
    }

    @Generated
    public void setManufacturer(String v) {
        this.setString(manufacturer, v, null);
    }

    @Generated
    public String getManufString() {
        return this.getString(manufString);
    }

    @Generated
    public void setManufString(String v) {
        this.setString(manufString, v, null);
    }

    @Generated
    public int getVersionNumber() {
        return this.getInt(versionNumber);
    }

    @Generated
    public void setVersionNumber(int v) {
        this.setInt(versionNumber, v, null);
    }

    @Generated
    public BMbusDeviceTypeId getDeviceTypeId() {
        return (BMbusDeviceTypeId)this.get(deviceTypeId);
    }

    @Generated
    public void setDeviceTypeId(BMbusDeviceTypeId v) {
        this.set(deviceTypeId, (BValue)v, null);
    }

    @Generated
    public BMbusAppReset getApplicationResetType() {
        return (BMbusAppReset)this.get(applicationResetType);
    }

    @Generated
    public void setApplicationResetType(BMbusAppReset v) {
        this.set(applicationResetType, (BValue)v, null);
    }

    @Generated
    public int getSubTelegramNumber() {
        return this.getInt(subTelegramNumber);
    }

    @Generated
    public void setSubTelegramNumber(int v) {
        this.setInt(subTelegramNumber, v, null);
    }

    @Generated
    public BMbusHistoryDeviceExt getHistory() {
        return (BMbusHistoryDeviceExt)this.get(history);
    }

    @Generated
    public void setHistory(BMbusHistoryDeviceExt v) {
        this.set(history, (BValue)v, null);
    }

    @Generated
    public BMbusPointDeviceExt getPoints() {
        return (BMbusPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BMbusPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BMbusHeaderTypes getHeaderType() {
        return (BMbusHeaderTypes)this.get(headerType);
    }

    @Generated
    public void setHeaderType(BMbusHeaderTypes v) {
        this.set(headerType, (BValue)v, null);
    }

    @Generated
    public int getMaxInputsPerCycleCount() {
        return this.getInt(maxInputsPerCycleCount);
    }

    @Generated
    public void setMaxInputsPerCycleCount(int v) {
        this.setInt(maxInputsPerCycleCount, v, null);
    }

    @Generated
    public boolean getAllowMultipleRecords() {
        return this.getBoolean(allowMultipleRecords);
    }

    @Generated
    public void setAllowMultipleRecords(boolean v) {
        this.setBoolean(allowMultipleRecords, v, null);
    }

    @Generated
    public int getMaxSpecialFunctionReads() {
        return this.getInt(maxSpecialFunctionReads);
    }

    @Generated
    public void setMaxSpecialFunctionReads(int v) {
        this.setInt(maxSpecialFunctionReads, v, null);
    }

    @Generated
    public BMbusCommand getCommandHidden() {
        return (BMbusCommand)this.get(commandHidden);
    }

    @Generated
    public void setCommandHidden(BMbusCommand v) {
        this.set(commandHidden, (BValue)v, null);
    }

    @Generated
    public String getFabricationNumber() {
        return this.getString(fabricationNumber);
    }

    @Generated
    public void setFabricationNumber(String v) {
        this.setString(fabricationNumber, v, null);
    }

    @Generated
    public int getReadoutModeNumber() {
        return this.getInt(readoutModeNumber);
    }

    @Generated
    public void setReadoutModeNumber(int v) {
        this.setInt(readoutModeNumber, v, null);
    }

    @Generated
    public String getMbusMeterStatusDescription() {
        return this.getString(mbusMeterStatusDescription);
    }

    @Generated
    public void setMbusMeterStatusDescription(String v) {
        this.setString(mbusMeterStatusDescription, v, null);
    }

    @Generated
    public boolean getManufacturerStatusBit5() {
        return this.getBoolean(manufacturerStatusBit5);
    }

    @Generated
    public void setManufacturerStatusBit5(boolean v) {
        this.setBoolean(manufacturerStatusBit5, v, null);
    }

    @Generated
    public boolean getManufacturerStatusBit6() {
        return this.getBoolean(manufacturerStatusBit6);
    }

    @Generated
    public void setManufacturerStatusBit6(boolean v) {
        this.setBoolean(manufacturerStatusBit6, v, null);
    }

    @Generated
    public boolean getManufacturerStatusBit7() {
        return this.getBoolean(manufacturerStatusBit7);
    }

    @Generated
    public void setManufacturerStatusBit7(boolean v) {
        this.setBoolean(manufacturerStatusBit7, v, null);
    }

    @Generated
    public void resetDatalink() {
        this.invoke(resetDatalink, null, null);
    }

    @Generated
    public void resetApplication() {
        this.invoke(resetApplication, null, null);
    }

    @Generated
    public void removeFromDatabase() {
        this.invoke(removeFromDatabase, null, null);
    }

    @Generated
    public void alarmProtocol() {
        this.invoke(alarmProtocol, null, null);
    }

    @Generated
    public void assignAddress(BInteger parameter) {
        this.invoke(assignAddress, (BValue)parameter, null);
    }

    @Generated
    public BRelTime calculateTimeForConcurrentReads(BInteger parameter) {
        return (BRelTime)this.invoke(calculateTimeForConcurrentReads, (BValue)parameter, null);
    }

    @Generated
    public BOrd submitLivePointsDiscoveryJob(BLivePointSearchDiscoverOptions parameter) {
        return (BOrd)this.invoke(submitLivePointsDiscoveryJob, (BValue)parameter, null);
    }

    @Generated
    public void optimiseReads() {
        this.invoke(optimiseReads, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == ping || action == optimiseReads || action == resetDatalink || action == resetApplication || action == removeFromDatabase || action == alarmProtocol) {
            this.getMbusNetwork().getWorker().post((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        if (action == assignAddress) {
            Object object = this.optimisedVarsSyncLock;
            synchronized (object) {
                if (this.optimisesQueued > 1) {
                    if (MbusToolkit.isTraceOn()) {
                        String deviceSp = this.isRunning() ? this.getSlotPath().toString() : "UNKNOWN DEVICE";
                        MbusToolkit.trace("Maximum optimises already queued for " + deviceSp + " cancelling additional request");
                    }
                    return null;
                }
                ++this.optimisesQueued;
                return null;
            }
        }
        return super.post(action, argument, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BMbusCommand || parent instanceof BMbusDeviceFolder || parent instanceof BMbusDevice || parent instanceof BMbusTcpIpNetwork || parent instanceof BMbusNetwork;
    }

    public BAbstractMbusNetwork getMbusNetwork() {
        return (BAbstractMbusNetwork)this.getNetwork();
    }

    public Type getNetworkType() {
        return BAbstractMbusNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
        this.getMbusNetwork().getNetworkDatabase().rationalise(this);
        this.optimiseReads();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        BAbstractMbusNetwork network = this.getMbusNetwork();
        if (prop == headerType) {
            BMbusNetworkDatabase database = network.getNetworkDatabase();
            database.removeDevicePointInformation(this.getPrimaryAddress(), this.getSecondaryAddress(), this.getModelName());
            this.setIdentNumber("");
            this.setManufacturer("");
            this.setVersionNumber(0);
            this.setDeviceTypeId(BMbusDeviceTypeId.other);
            if (this.getPrimaryAddress() != 253) {
                this.setSecondaryAddress("");
            }
        }
        if (prop == addressMode) {
            this.ping();
        } else if (prop == modelName) {
            this.getMbusNetwork().getNetworkDatabase().rationalise(this);
        }
    }

    public IFuture postPing() {
        this.doPing();
        return null;
    }

    public void doPing() {
        BAbstractMbusNetwork network = this.getMbusNetwork();
        String pingCommsLock = "ping" + this.getHandle();
        try {
            this.doCommsLockedPing(network, pingCommsLock);
            network.unlockSends(pingCommsLock);
        }
        catch (Exception e) {
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Error pinging device", e);
            }
            network.unlockSends(pingCommsLock);
        }
    }

    public void doCommsLockedPing(BAbstractMbusNetwork network, Object pingCommsLock) {
        block21: {
            long minRxTxTimes;
            MbusSndUdMessage message2;
            if (!this.isRunning()) {
                return;
            }
            if (network.getTestMode() != BMbusTestControl.inactive) {
                this.pingOk();
                return;
            }
            if (this.getInhibitPing()) {
                this.pingOk();
                return;
            }
            MbusResponseMessage rsp = null;
            MBusTxTimings txTimingsRef = this.getTxTimingsReference();
            if (this.getAddressMode() != BMbusAddressing.primary) {
                message2 = new MbusSndUdMessage(this, network);
                message2.setMessageBaudRate(this.getBaudRate());
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.getBaudRate());
                rsp = (MbusResponseMessage)network.sendMBusSync(txTimingsRef, pingCommsLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)this.getBaudRate()));
                if ((rsp == null || rsp != null && !rsp.getSuccessfulResponse() || rsp != null && rsp.getCollisionDetected()) && this.isMounted()) {
                    MbusLogInputOutput.log.warning(this.getDisplayName(null) + ": Failed to get response to initial secondary address selection " + (rsp != null && rsp.getCollisionDetected() ? "(COLLISION)" : ""));
                }
            }
            if (this.getResetRequiredForPing()) {
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Ping Reset to Meter:- " + this.getPrimaryAddress() + " Sec Add= " + this.getSecondaryAddress());
                }
                this.doSendNkeAndInitDelay(txTimingsRef, pingCommsLock);
                if (this.getAddressMode() != BMbusAddressing.primary) {
                    message2 = new MbusSndUdMessage(this, network);
                    message2.setMessageBaudRate(this.getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.getBaudRate());
                    rsp = (MbusResponseMessage)network.sendMBusSync(txTimingsRef, pingCommsLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)this.getBaudRate()));
                    if (rsp == null || rsp != null && !rsp.getSuccessfulResponse() || rsp != null && rsp.getCollisionDetected()) {
                        if (this.isMounted()) {
                            if (rsp != null && rsp.getCollisionDetected()) {
                                MbusLogInputOutput.log.warning(this.getDisplayName(null) + ": Secondary address selection collision detected");
                            } else {
                                MbusLogInputOutput.log.warning(this.getDisplayName(null) + ": Secondary address selection failure");
                            }
                        }
                        String pingFailText = rsp != null && rsp.getCollisionDetected() ? "collision - secondary address selection" : "timeout - secondary address selection";
                        this.pingFail(pingFailText);
                        network.unlockSends(pingCommsLock);
                        return;
                    }
                    this.setFcBitState(true);
                }
            }
            try {
                MbusMessage message;
                if (MbusLogInputOutput.log.isTraceOn()) {
                    MbusLogInputOutput.log.trace("Ping to Meter:- " + this.getPrimaryAddress() + "Sec Add= " + this.getSecondaryAddress());
                }
                if (this.getReqSkeCapable()) {
                    message = new MbusReqSkeMessage(this, this.getMbusNetwork());
                    message.setMessageBaudRate(this.getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.getBaudRate());
                    rsp = (MbusResponseMessage)network.sendMBusSync(txTimingsRef, pingCommsLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.getBaudRate()));
                } else {
                    message = new MbusReqUd2Message(this, this.getMbusNetwork());
                    message.setMessageBaudRate(this.getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.getBaudRate());
                    rsp = (MbusResponseMessage)network.sendMBusSync(txTimingsRef, pingCommsLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.getBaudRate()));
                }
                network.unlockSends(pingCommsLock);
                if (rsp != null) {
                    if (MbusLogInputOutput.log.isTraceOn()) {
                        MbusLogInputOutput.log.trace("Input(Ping):- " + rsp.toDebugString());
                    }
                    this.pingOk();
                    if (rsp.getBytes().length > 8) {
                        MbusReceivedLongFrame longFrameMessage = null;
                        longFrameMessage = new MbusReceivedLongFrame(rsp, this.getMbusNetwork(), this, false, 0);
                        this.setMbusMeterStatusDescription(longFrameMessage.getStatus());
                        this.setManufacturerStatusBit5(longFrameMessage.getStatusBit5());
                        this.setManufacturerStatusBit6(longFrameMessage.getStatusBit6());
                        this.setManufacturerStatusBit7(longFrameMessage.getStatusBit7());
                    }
                } else {
                    this.pingFail("timeout");
                }
            }
            catch (Exception e) {
                this.pingFail("caught exception");
                if (!MbusToolkit.isTraceOn()) break block21;
                MbusToolkit.trace("Error pinging device", e);
            }
        }
    }

    public BRelTime doCalculateTimeForConcurrentReads(BInteger numberOfReadsInt) {
        int numberOfReads = numberOfReadsInt.getInt();
        long millisecondsUsed = 0L;
        MBusTxTimings txTimings = this.getTxTimingsReference();
        if (this.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
            millisecondsUsed += MBusTxTimings.calculateTxRxTime(17L, (BBaudRate)this.getBaudRate());
            millisecondsUsed += txTimings.intermessageDelay;
        }
        if (this.getResetRequired()) {
            millisecondsUsed += MBusTxTimings.calculateTxRxTime(5L, (BBaudRate)this.getBaudRate());
            millisecondsUsed += txTimings.intermessageDelay;
        }
        millisecondsUsed += MBusTxTimings.calculateTxRxTime(5L, (BBaudRate)this.getBaudRate()) * (long)numberOfReads;
        millisecondsUsed += MBusTxTimings.calculateTxRxTime(256L, (BBaudRate)this.getBaudRate()) * (long)numberOfReads;
        if (numberOfReads > 1) {
            millisecondsUsed += txTimings.intermessageDelay * (long)(numberOfReads - 1);
        }
        return BRelTime.make((long)millisecondsUsed);
    }

    public void doSendNkeAndInitDelay(MBusTxTimings txTimingsRef, Object commsLock) {
        BAbstractMbusNetwork network = this.getMbusNetwork();
        if (network == null) {
            return;
        }
        MbusSndNkeMessage resetMessage = new MbusSndNkeMessage(this, network, 253);
        resetMessage.setMessageBaudRate(this.getBaudRate());
        long resetMinRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.getBaudRate());
        resetMinRxTxTimes += MBusTxTimings.calculateTxRxTime(resetMessage, (BBaudRate)this.getBaudRate());
        if (this.getAddressMode() != BMbusAddressing.primary) {
            MbusResponseMessage rsp = (MbusResponseMessage)network.sendMBusSync(txTimingsRef, commsLock, resetMessage, resetMinRxTxTimes);
            if (rsp == null || rsp != null && !rsp.getSuccessfulResponse()) {
                if (this.isMounted() && MbusLogInputOutput.log.isLoggable(0)) {
                    MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": SND_NKE unconfirmed - continuing assuming data loss");
                }
                this.setFcBitState(true);
            }
        } else {
            int numberRequired;
            resetMessage.setResponseExpected(false);
            MBusTxTimings primarySendTimings = new MBusTxTimings();
            primarySendTimings.intermessageDelay = 300L;
            primarySendTimings.responseTimeout = BRelTime.make((long)100L);
            primarySendTimings.retryTransmission = numberRequired = Math.max(this.getAddressMode() == BMbusAddressing.primary ? 2 : 3, txTimingsRef.retryTransmission);
            MbusResponseMessage rsp = null;
            for (int i = 0; i < numberRequired; ++i) {
                if (this.isMounted() && MbusLogInputOutput.log.isLoggable(0)) {
                    MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Sending SND_NKE");
                }
                if (i == numberRequired - 1) {
                    resetMessage.setResponseExpected(true);
                }
                primarySendTimings.responseTimeout = txTimingsRef.responseTimeout;
                rsp = (MbusResponseMessage)network.sendMBusSync(primarySendTimings, commsLock, resetMessage, resetMinRxTxTimes);
                if (!this.isMounted() || !MbusLogInputOutput.log.isLoggable(0)) continue;
                MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": Sent SND_NKE");
            }
            if ((rsp == null || rsp != null && !rsp.getSuccessfulResponse()) && this.isMounted() && MbusLogInputOutput.log.isLoggable(0)) {
                MbusLogInputOutput.log.trace(this.getDisplayName(null) + ": SND_NKE unconfirmed - continuing assuming data loss");
            }
        }
        try {
            if (MbusLogInputOutput.log.isTraceOn() && this.isMounted()) {
                MbusLogInputOutput.log.trace(this.getDisplayName(null) + " Initialisation delay");
            }
            txTimingsRef.applyInitialisationDelay();
            if (MbusLogInputOutput.log.isTraceOn() && this.isMounted()) {
                MbusLogInputOutput.log.trace(this.getDisplayName(null) + " Initialisation delay complete");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setFcBitState(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResetDatalink() {
        BAbstractMbusNetwork network = this.getMbusNetwork();
        String resetDlCommsLock = "resetDl" + this.getHandle();
        MBusTxTimings txTimingsRef = this.getTxTimingsReference();
        try {
            long minRxTxTimes;
            if (this.getAddressMode() != BMbusAddressing.primary) {
                MbusSndUdMessage message2 = new MbusSndUdMessage(this, network);
                message2.setMessageBaudRate(this.getBaudRate());
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.getBaudRate());
                MbusResponseMessage resp = (MbusResponseMessage)network.sendMBusSync(txTimingsRef, resetDlCommsLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)this.getBaudRate()));
                if (resp != null && resp.getCollisionDetected()) {
                    network.unlockSends(resetDlCommsLock);
                    throw new Exception("Secondary address selection collision detected");
                }
            }
            MbusSndNkeMessage message = new MbusSndNkeMessage(this, network, 0);
            message.setMessageBaudRate(this.getBaudRate());
            minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.getBaudRate());
            network.sendMBusSync(txTimingsRef, resetDlCommsLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.getBaudRate()));
            this.setFcBitState(true);
            network.unlockSends(resetDlCommsLock);
            network.getNetworkDatabase().initialiseDelay(network.getActiveTxTimings().initialisationDelay.getSeconds());
        }
        catch (Exception e) {
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Error resetting data link", e);
            }
        }
        catch (Throwable t) {
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Error resetting data link " + t.getMessage());
            }
        }
        finally {
            network.unlockSends(resetDlCommsLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAlarmProtocol() {
        String resetAlProtocolCommsLock = "alarmProtocol" + this.getHandle();
        BAbstractMbusNetwork network = this.getMbusNetwork();
        MBusTxTimings txTimingsRef = this.getTxTimingsReference();
        try {
            long minRxTxTimes;
            if (this.getAddressMode() != BMbusAddressing.primary) {
                MbusSndUdMessage message2 = new MbusSndUdMessage(this, network);
                message2.setMessageBaudRate(this.getBaudRate());
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.getBaudRate());
                MbusResponseMessage rsp = (MbusResponseMessage)network.sendMBusSync(txTimingsRef, resetAlProtocolCommsLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)this.getBaudRate()));
                if (rsp != null && rsp.getCollisionDetected()) {
                    network.unlockSends(resetAlProtocolCommsLock);
                    throw new Exception("Secondary address selection collision detected");
                }
            }
            MbusReqUd1Message message = new MbusReqUd1Message(this, network);
            message.setMessageBaudRate(this.getBaudRate());
            minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.getBaudRate());
            network.sendMBusSync(txTimingsRef, resetAlProtocolCommsLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.getBaudRate()));
            network.unlockSends(resetAlProtocolCommsLock);
        }
        catch (Exception e) {
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Error alarm protocol", e);
            }
        }
        catch (Throwable t) {
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Error alarm protocol " + t.getMessage());
            }
        }
        finally {
            network.unlockSends(resetAlProtocolCommsLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResetApplication() {
        String resetApplCommsLock = "resetApp" + this.getHandle();
        MBusTxTimings txTimingsRef = this.getTxTimingsReference();
        BAbstractMbusNetwork network = this.getMbusNetwork();
        try {
            if (this.getAddressMode() != BMbusAddressing.primary) {
                MbusSndUdMessage message2 = new MbusSndUdMessage(this, network);
                message2.setMessageBaudRate(this.getBaudRate());
                long minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.getBaudRate());
                MbusResponseMessage resp = (MbusResponseMessage)network.sendMBusSync(txTimingsRef, resetApplCommsLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)this.getBaudRate()));
                if (resp != null && resp.getCollisionDetected()) {
                    network.unlockSends(resetApplCommsLock);
                    throw new Exception("Secondary address selection collision detected");
                }
            }
            MbusLongFrameMessage message = new MbusLongFrameMessage();
            message.setMessageBaudRate(this.getBaudRate());
            if (this.getAddressMode() == BMbusAddressing.primary) {
                message.setAField(this.getPrimaryAddress());
            } else {
                message.setAField(253);
            }
            message.setCFieldNoFcb(67);
            message.setCiField(80);
            byte[] data = new byte[]{(byte)(this.getApplicationResetType().getOrdinal() | this.getSubTelegramNumber() & 0xF)};
            message.setBytes(data);
            long minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.getBaudRate());
            network.sendMBusSync(txTimingsRef, resetApplCommsLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.getBaudRate()));
            network.unlockSends(resetApplCommsLock);
        }
        catch (Exception e) {
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Error resetting appliance", e);
            }
        }
        catch (Throwable e) {
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Error resetting appliance " + e.getMessage());
            }
        }
        finally {
            network.unlockSends(resetApplCommsLock);
        }
    }

    public BOrd doSubmitLivePointsDiscoveryJob(BLivePointSearchDiscoverOptions ptDiscoveryOpts) {
        BMbusLivePointSearchDiscoveryJob livePointDiscoveryJob = new BMbusLivePointSearchDiscoveryJob(this);
        livePointDiscoveryJob.setDiscoveryOptions(ptDiscoveryOpts);
        return livePointDiscoveryJob.submit(null);
    }

    public void doRemoveFromDatabase() {
        BAbstractMbusNetwork network = this.getMbusNetwork();
        BMbusNetworkDatabase database = network.getNetworkDatabase();
        database.removeDevice(this.getPrimaryAddress(), this.getSecondaryAddress());
    }

    public void doAssignAddress(BInteger address) {
        BAbstractMbusNetwork network = this.getMbusNetwork();
        new BMbusAssignAddressJob(network, address.getInt(), this).submit(null);
    }

    public MBusTxTimings getTxTimingsReference() {
        if (this.networkTxTimings == null) {
            return this.getMbusNetwork().getTxTimingsReference();
        }
        return this.networkTxTimings;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        MBusTxTimings timings = this.getTxTimingsReference();
        out.startProps("Expected TX Timings");
        out.prop((Object)"IMD", (Object)BRelTime.make((long)timings.intermessageDelay));
        out.prop((Object)"Retry TX", timings.retryTransmission);
        out.prop((Object)"Response Timeout", (Object)timings.responseTimeout);
        out.prop((Object)"Initialisation Delay", (Object)timings.initialisationDelay);
        out.endProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOptimiseReads() {
        Object object = this.optimisedVarsSyncLock;
        synchronized (object) {
            --this.optimisesQueued;
        }
        int additionalMessagesRequired = this.getPoints().getMaxMessageRequired();
        if (MbusToolkit.isTraceOn()) {
            String deviceSp = this.isRunning() ? this.getSlotPath().toString() : "UNKNOWN DEVICE";
            MbusToolkit.trace("Maximum messages under device " + deviceSp + " required for currently setup points: " + additionalMessagesRequired);
        }
        if (additionalMessagesRequired > 0) {
            if (!this.getAllowMultipleRecords()) {
                this.setAllowMultipleRecords(true);
            }
        } else if (this.getAllowMultipleRecords()) {
            this.setAllowMultipleRecords(false);
        }
        if (this.getMaxSpecialFunctionReads() != additionalMessagesRequired) {
            this.setMaxSpecialFunctionReads(additionalMessagesRequired);
        }
        if (this.getCycleQuantity() != 1) {
            this.setCycleQuantity(1);
        }
    }
}

