/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message.linkup;

import com.tridiumemea.micros.BMicrosDevice;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.MicrosUnsolicitedNotification;

public final class MicrosLinkConfigNotification
extends MicrosMessage
implements MicrosUnsolicitedNotification {
    private static final String DIVIDER_CHAR = " // ";

    @Override
    public void unsolicitedAction(BMicrosNetwork network) {
        if (!network.getLinkConfig().getRequestVersion()) {
            network.getLogger().fine("Ignoring received PMS Version Info [LC].");
        } else {
            String answer;
            String UNKNOWN = "?";
            BMicrosDevice device = network.getDevice();
            if (this.isPlausibleFieldValue("A1")) {
                device.setVersionPMS((String)this.get("A1").getData());
            } else if (!device.getVersionPMS().equals(UNKNOWN)) {
                device.setVersionPMS(UNKNOWN);
            }
            StringBuilder IFC = new StringBuilder(16);
            if (this.isPlausibleFieldValue("A2")) {
                IFC.append(this.get("A2").getData());
            }
            if (this.isPlausibleFieldValue("A3")) {
                if (IFC.length() > 0) {
                    IFC.append(DIVIDER_CHAR);
                }
                IFC.append(this.get("A3").getData());
            }
            String string = answer = IFC.length() > 0 ? IFC.toString() : UNKNOWN;
            if (!device.getVersionIFC().equals(answer)) {
                device.setVersionIFC(answer);
            }
            if (this.isPlausibleFieldValue("PH")) {
                device.setHotelID((String)this.get("PH").getData());
            } else if (!device.getHotelID().equals(UNKNOWN)) {
                device.setHotelID(UNKNOWN);
            }
        }
    }

    private boolean isPlausibleFieldValue(String field) {
        return this.isAvailable(field) && this.get(field).getData() != null && ((CharSequence)this.get(field).getData()).length() > 0;
    }
}

