/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.common;

import java.util.Objects;
import java.util.logging.Logger;
import javax.baja.sys.BComplex;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Type;

public final class CommonUtil {
    public static final Logger globalLog = Logger.getLogger("Micros");

    private CommonUtil() {
    }

    public static boolean isParentLegal(Type parent, Type child, Type expected, Type alternative) {
        Object[] expectedParentLexiconMsgArgs;
        String key;
        Objects.requireNonNull(child);
        Objects.requireNonNull(parent);
        Objects.requireNonNull(expected);
        if (parent.is(expected)) {
            return true;
        }
        if (alternative != null && parent.is(alternative)) {
            return true;
        }
        if (alternative == null) {
            key = "mustBeParentedBy";
            expectedParentLexiconMsgArgs = new Object[]{child.getTypeName(), expected.getTypeName(), parent.getTypeName()};
        } else {
            key = "mustBeParentedByOr";
            expectedParentLexiconMsgArgs = new Object[]{child.getTypeName(), expected.getTypeName(), alternative.getTypeName(), parent.getTypeName()};
        }
        throw new IllegalParentException(child.getModule().getModuleName(), key, expectedParentLexiconMsgArgs);
    }

    public static boolean isParentLegal(BComplex parent, BComplex child, Type expected) {
        return CommonUtil.isParentLegal(parent.getType(), child.getType(), expected, null);
    }
}

