/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm.protocol;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.tcp.TcpLinkLayer;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.datatype.BMicrosIpAddress;
import com.tridiumemea.micros.message.linkup.MicrosSocketHandshakeMsg;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

public class SocketHandshakeUtil {
    private boolean socketHandshakeRequired = true;
    private boolean commInhibitFlag = true;
    private Clock.Ticket commInhibitTimer = Clock.expiredTicket;
    private final Object socketLock = new Object();
    private final BMicrosNetwork net;
    private static final String WAITING_FOR_SERVER = "HandshakeSent: Waiting for server to contact station ";

    public SocketHandshakeUtil(BMicrosNetwork net) {
        Objects.requireNonNull(net);
        this.net = net;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void socketHandshake() throws Exception {
        Logger log = this.net.log();
        BMicrosIpAddress addr = this.net.getDevice().getAddress();
        log.finest(() -> "Socket Handshake Entered via " + Thread.currentThread().getName());
        addr.verify(log);
        Object object = this.socketLock;
        synchronized (object) {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Debug Only", new Exception("Socket Handshake Call Stack"));
                }
                this.createSession(addr);
                this.commInhibitFlag = true;
                MicrosSocketHandshakeMsg hs = new MicrosSocketHandshakeMsg(addr);
                log.info("Opening Socket " + addr.toString());
                this.net.getTcpConfig().tcomm().sendMessage((NMessage)hs);
                this.socketHandshakeRequired = false;
                this.releaseCommsMuteAfterConnect();
                log.fine(() -> "HandshakeSent: Waiting for server to contact station {" + this.net.getDevice().getAddress().getSessionId() + '}');
            }
            catch (Exception e) {
                log.log(Level.WARNING, "socketHandshake: Cannot connect to Micros PMS Server:" + e);
                if (log.isLoggable(Level.FINE)) {
                    e.printStackTrace();
                }
                throw e;
            }
        }
    }

    private void releaseCommsMuteAfterConnect() {
        BRelTime secondsDelay = this.net.getLinkConfig().getDurationToBlockCommsAfterSocketOpen();
        this.commInhibitTimer.cancel();
        this.commInhibitTimer = Clock.schedule((BComponent)this.net, (BRelTime)secondsDelay, (Action)BMicrosNetwork.lowerCommInhibitFlag, null);
    }

    private void createSession(BMicrosIpAddress addr) throws Exception {
        TcpLinkLayer linkLayer = (TcpLinkLayer)this.net.getTcpConfig().tcomm().getLinkLayer();
        int newSessionReference = linkLayer.createSession((BIpAddress)addr);
        this.net.getDevice().setCurrentAddress(addr);
        addr.setSessionId(newSessionReference);
        if (this.net.log().isLoggable(Level.FINE)) {
            this.net.log().fine("Started new session {" + newSessionReference + '}');
        }
    }

    void raiseSocketHandshakeRequiredFlags() {
        this.socketHandshakeRequired = true;
        this.commInhibitFlag = true;
    }

    public boolean isSocketHandshakeRequired() {
        return this.socketHandshakeRequired;
    }

    public boolean isCommInhibitFlag() {
        return this.commInhibitFlag;
    }

    public void lowerCommInhibitFlag() {
        this.commInhibitFlag = false;
    }

    public void cancelCommInhibitTimer() {
        this.commInhibitTimer.cancel();
    }
}

