/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm.protocol;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.BMicrosListener;
import com.tridiumemea.micros.comm.exception.MicrosLinkNegotiationException;
import com.tridiumemea.micros.comm.flag.MicrosMessageFlag;
import com.tridiumemea.micros.datatype.config.BMicrosLinkConfig;
import com.tridiumemea.micros.enums.BMicrosLinkStatusEnum;
import com.tridiumemea.micros.message.MicrosDictionary;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.linkup.MicrosLinkActiveRequest;
import com.tridiumemea.micros.message.linkup.MicrosLinkDescriptionMsg;
import com.tridiumemea.micros.message.linkup.MicrosLinkRecordMsg;
import com.tridiumemea.micros.point.BMicrosPointDeviceExt;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.util.Lexicon;

public class LinkActivationUtil {
    private final BMicrosNetwork network;
    private BIpAddress address;
    private BMicrosPointDeviceExt points;
    private BMicrosLinkConfig linkConfig;
    private BMicrosListener listener;
    private Logger log;
    private static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
    private static final String SENDING_LD = "Sending Link Description: ";
    private static final String SENDING_LR = "Requesting guest messages. ";
    private static final String REQUEST_ROOM = "Sending Link Record to subscribe for room data. ";
    private static final String SENDING_LA = "Attempting Link Activate: ";

    private LinkActivationUtil() {
        throw new IllegalArgumentException("Needs Network");
    }

    public LinkActivationUtil(BMicrosNetwork network) {
        Objects.requireNonNull(network);
        this.network = network;
    }

    public void sendSequence() {
        this.initVars();
        this.network.setLinkStatus(BMicrosLinkStatusEnum.activating);
        this.network.getDsUtil().cancelAnyActiveJob();
        try {
            this.sendLinkDescription();
            this.sendGuestRecordRequests();
            this.sendCheckinAndRoomRights();
            MicrosMessage response = this.sendLinkActiveMessage();
            this.examineServerResponseToLA(response);
        }
        catch (MicrosLinkNegotiationException | InterruptedException e) {
            String failureReason = lex.getText("microsLinkUtil.ActivationFail") + ' ' + ((Throwable)e).getMessage();
            this.network.getShutdownUtil().commonLinkDownSteps(failureReason);
        }
    }

    private void initVars() {
        this.address = this.network.getDevice().getAddress();
        this.points = this.network.getDevice().getPoints();
        this.linkConfig = this.network.getLinkConfig();
        this.listener = this.network.getEventListener();
        this.log = this.network.log();
    }

    private void sendLinkDescription() {
        MicrosLinkDescriptionMsg msg = new MicrosLinkDescriptionMsg(this.address);
        msg.add("V#", MicrosDictionary.LINK_DESCRIPTION_FIELD.MODULE_VERSION_VALUE);
        msg.add("IF", "EM");
        if (this.linkConfig.getRequestVersion()) {
            msg.add("RT", 52);
        } else {
            this.log.fine("Request version disabled, removing RT52");
        }
        this.log.info(SENDING_LD + (Object)((Object)msg));
        try {
            this.network.sendAsync(msg);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, SENDING_LD, e);
        }
    }

    private void sendGuestRecordRequests() {
        StringBuilder fieldList = new StringBuilder("RN").append("G#");
        MicrosLinkRecordMsg msg = new MicrosLinkRecordMsg(this.address);
        boolean requestGuestData = this.linkConfig.getEnableGuestData() && this.points.isGuestDataLicensed();
        try {
            this.log.info(SENDING_LR);
            msg.add("RI", "GO");
            msg.add("FL", fieldList + "SF");
            this.log.fine(SENDING_LR + (Object)((Object)msg));
            this.network.sendAsync(msg);
            if (requestGuestData) {
                fieldList.append("GT").append("GF").append("GN").append("GL").append("GV");
            }
            msg = new MicrosLinkRecordMsg(this.address);
            msg.add("RI", "GI");
            msg.add("FL", fieldList + "SF");
            this.log.fine(SENDING_LR + (Object)((Object)msg));
            this.network.sendAsync(msg);
            msg = new MicrosLinkRecordMsg(this.address);
            msg.add("RI", "GC");
            msg.add("FL", fieldList + "RO");
            this.log.fine(SENDING_LR + (Object)((Object)msg));
            this.network.sendAsync(msg);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Requesting guest messages.  " + (Object)((Object)msg), e);
            if (requestGuestData && this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "Could try disabling guest data depending on failure cause.");
            }
            throw new MicrosLinkNegotiationException("Requesting Guest records caused ", e);
        }
    }

    private void sendCheckinAndRoomRights() {
        boolean checkIn = this.linkConfig.getPreArrivalConfig().getEnablePreArrival();
        boolean rights = this.linkConfig.getRoomRightsConfig().getEnableRoomRightsData();
        if (checkIn || rights) {
            StringBuilder fieldList = new StringBuilder();
            fieldList.append("RN");
            StringBuilder roomDetailLogMsg = new StringBuilder(REQUEST_ROOM);
            if (checkIn) {
                fieldList.append("CS");
                roomDetailLogMsg.append("CheckIn ");
                if (rights) {
                    roomDetailLogMsg.append("& ");
                }
            }
            if (rights) {
                if (this.points.isRoomRightsLicensed()) {
                    fieldList.append(MicrosDictionary.MINIBAR_RIGHTS.getRecord()).append(MicrosDictionary.TV_RIGHTS.getRecord());
                    roomDetailLogMsg.append("Rights ");
                } else {
                    if (roomDetailLogMsg.length() > 0) {
                        roomDetailLogMsg.append(". ");
                    }
                    roomDetailLogMsg.append("Rights not licenced! ");
                }
            }
            MicrosLinkRecordMsg msg = new MicrosLinkRecordMsg(this.address);
            msg.add("RI", "RE");
            msg.add("FL", fieldList.toString());
            roomDetailLogMsg.append(msg.toString());
            this.log.info(roomDetailLogMsg.toString());
            try {
                this.network.sendAsync(msg);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Sending Link Record to subscribe for room data.  " + (Object)((Object)msg), e);
                this.network.getDevice().getPoints().updateAllRoomEquipmentStatus();
            }
        }
    }

    private MicrosMessage sendLinkActiveMessage() {
        MicrosLinkActiveRequest request = new MicrosLinkActiveRequest(this.address);
        this.log.info(SENDING_LA + (Object)((Object)request));
        this.listener.factoryFlags.raise(MicrosMessageFlag.Flag.LINK_MSG);
        try {
            this.network.getTcpConfig().checkAndFormatMsg(request);
            MicrosMessage microsMessage = (MicrosMessage)this.network.getTcpConfig().tcomm().sendRequest((NMessage)request);
            return microsMessage;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, SENDING_LA + (Object)((Object)request), e);
            throw new MicrosLinkNegotiationException(SENDING_LA, e);
        }
        finally {
            this.listener.factoryFlags.lower(MicrosMessageFlag.Flag.LINK_MSG);
        }
    }

    private void examineServerResponseToLA(MicrosMessage serverResponse) throws InterruptedException {
        String response;
        switch (response = serverResponse != null ? serverResponse.getRecordID() : "null") {
            case "LA": {
                this.network.getDevice().getPingUtil().reportLinkActiveSuccess();
                break;
            }
            case "LS": {
                String UNEXPECTED_LS = "RECEIVED LS (INSTEAD OF EXPECTED LA)";
                this.log.severe(UNEXPECTED_LS);
                if (this.linkConfig.getResetLinkOnNegotiationClash()) {
                    this.tryCyclingLinkToRecover();
                    break;
                }
                throw new MicrosLinkNegotiationException(UNEXPECTED_LS);
            }
            default: {
                String unknownResponse = "Received neither LA or LS, but : " + response;
                this.log.warning(unknownResponse);
                throw new MicrosLinkNegotiationException(unknownResponse);
            }
        }
    }

    private void tryCyclingLinkToRecover() throws InterruptedException {
        this.log.severe("Opted to try disable / re-enable comms");
        this.network.setEnabled(false);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        this.network.setEnabled(true);
    }
}

