/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm.protocol;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.datatype.config.BMicrosDatabaseSyncConfig;
import com.tridiumemea.micros.job.BMicrosDatabaseSyncJob;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.util.Lexicon;

public class DatabaseSyncUtil {
    private Clock.Ticket dsTimer = Clock.expiredTicket;
    private final Object dsTimerLock = new Object();
    private BMicrosDatabaseSyncJob cachedJob;
    private final BMicrosNetwork network;
    private final BMicrosDatabaseSyncConfig dsConfig;
    private static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
    private static final String DS_TIMEOUT_MSG = lex.getText("ds.net.timeout");

    private DatabaseSyncUtil() {
        throw new IllegalArgumentException("Needs Network");
    }

    public DatabaseSyncUtil(BMicrosNetwork network) {
        Objects.requireNonNull(network);
        this.network = network;
        this.dsConfig = network.getLinkConfig().getDatabaseSyncConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartDatabaseSyncTimer() {
        Object object = this.dsTimerLock;
        synchronized (object) {
            this.dsTimer.cancel();
            this.dsTimer = Clock.schedule((BComponent)this.network, (BRelTime)this.dsConfig.getDatabaseSyncTimeout(), (Action)BMicrosNetwork.databaseSyncEvaluateTimeout, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDatabaseSyncTimer() {
        Object object = this.dsTimerLock;
        synchronized (object) {
            this.dsTimer.cancel();
        }
    }

    public void checkJobTimeout() {
        if (this.isCachedJobAlive()) {
            BRelTime delta = BAbsTime.now().delta(this.cachedJob.getTimeLastRecordWasSeen());
            if (this.dsConfig.getDatabaseSyncTimeout().compareTo((Object)delta) > 0) {
                this.cachedJob.log().endFailed(DS_TIMEOUT_MSG);
                this.network.log().log(Level.WARNING, DS_TIMEOUT_MSG);
                this.cancelAnyActiveJob();
                this.network.getDevice().pingFail(DS_TIMEOUT_MSG);
                this.network.getDevice().ping();
            } else {
                this.restartDatabaseSyncTimer();
                this.cachedJob.heartbeat();
            }
        }
    }

    void cancelAnyActiveJob() {
        if (this.isCachedJobAlive()) {
            this.getCachedJob().cancel();
        }
        this.stopDatabaseSyncTimer();
    }

    public boolean isCachedJobAlive() {
        return this.cachedJob != null && this.cachedJob.isAlive();
    }

    public BMicrosDatabaseSyncJob getCachedJob() {
        return this.cachedJob;
    }

    public void setCachedJob(BMicrosDatabaseSyncJob job) {
        this.cachedJob = job;
    }
}

