/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm;

import com.tridium.ndriver.comm.ICommListener;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.comm.tcp.ITcpEventListener;
import com.tridium.ndriver.comm.tcp.TcpLinkLayer;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.exception.MicrosLinkNegotiationException;
import com.tridiumemea.micros.comm.flag.MicrosMessageFlag;
import com.tridiumemea.micros.comm.protocol.SwapFlagBufferUtil;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.job.BMicrosDatabaseSyncJob;
import com.tridiumemea.micros.message.MicrosUnsolicitedNotification;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BMicrosListener
extends BComponent
implements ICommListener,
ITcpEventListener {
    public static final Type TYPE = Sys.loadType(BMicrosListener.class);
    private final SwapFlagBufferUtil swapFlagBuffer = new SwapFlagBufferUtil();
    private BMicrosNetwork network;
    private final AtomicInteger numberOfDatabaseSyncReturningNoData = new AtomicInteger();
    public final MicrosMessageFlag factoryFlags = new MicrosMessageFlag(this);
    private static final String[] SPY_PROPS = new String[]{BMicrosDatabaseSyncJob.guestInCount.getName(), BMicrosDatabaseSyncJob.guestOutCount.getName(), BMicrosDatabaseSyncJob.unknownRoomCount.getName(), BMicrosDatabaseSyncJob.totalRecievedCount.getName(), BMicrosDatabaseSyncJob.assumedCheckOutCount.getName(), BJob.startTime.getName()};
    private static final String LOG_HEADER = BMicrosListener.class.getSimpleName() + ":processUnsolicitedMessage: ";
    private static final String UNSOL_LOG_MSG = BMicrosListener.class.getSimpleName() + ":receiveMessage: calling unsolicited action on msg: ";
    private static final String NO_NETWORK_ERR = "\n *** Orphaned MicrosListener can't find network to report events to! *** \n\n";
    private static final Lexicon lex = Lexicon.make(BMicrosListener.class);
    private static final String SPY_GENERATE_ERR = lex.getText("listener.spy.fail");

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.network = (BMicrosNetwork)this.getParent();
        if (this.network != null) {
            this.network.getTcpConfig().setDefaultListener(this);
            if (this.network.log() != null) {
                this.network.log().info("Listener Attached");
            }
            if (this.network.getEnabled()) {
                TcpLinkLayer tll = (TcpLinkLayer)this.network.getTcpConfig().tcomm().getLinkLayer();
                tll.registerTcpEvenListener((ITcpEventListener)this);
            }
        } else {
            CommonUtil.globalLog.severe(NO_NETWORK_ERR);
        }
    }

    public void receiveMessage(NMessage nMsg) {
        Logger log = this.network.log();
        if (nMsg == null) {
            log.warning("MicrosListener: Received null msg");
            return;
        }
        Runnable unsolicitedAction = () -> {
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(UNSOL_LOG_MSG + nMsg);
                }
                ((MicrosUnsolicitedNotification)nMsg).unsolicitedAction(this.network);
            }
            catch (MicrosLinkNegotiationException | IllegalArgumentException | IllegalStateException e) {
                log.log(Level.WARNING, LOG_HEADER + lex.getText("microsUnsolicitedReceive.parsingErr") + ' ' + nMsg, (Throwable)e);
            }
        };
        this.network.getAsync().post(unsolicitedAction);
    }

    public SwapFlagBufferUtil getSwapFlagBuffer() {
        return this.swapFlagBuffer;
    }

    public void reportEmptyDataSync() {
        this.numberOfDatabaseSyncReturningNoData.incrementAndGet();
    }

    public void spyDataAdditions(SpyWriter out) {
        block7: {
            out.startProps("Database Sync Statistics");
            out.prop((Object)"numberOfDatabaseSyncReturningNoData", this.numberOfDatabaseSyncReturningNoData.intValue());
            if (this.isRunning()) {
                try {
                    out.prop((Object)"Network Proxy Ext Total", this.network.getDevice().getPoints().getProxyExtCount());
                    BMicrosDatabaseSyncJob currentJob = this.network.getDsUtil().getCachedJob();
                    if (currentJob != null) {
                        String[] stringArray = SPY_PROPS;
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String spyProp = stringArray[i];
                            out.prop((Object)spyProp, (Object)currentJob.get(spyProp));
                        }
                        out.prop((Object)"DatabaseSyncActive", currentJob.isAlive());
                        BRelTime duration = !currentJob.isAlive() ? currentJob.getEndTime().delta(currentJob.getStartTime()) : BAbsTime.now().delta(currentJob.getStartTime());
                        out.prop((Object)"lastSyncDuration", (Object)duration);
                    } else {
                        out.prop((Object)"currentJob:", (Object)"No job found to report on");
                    }
                }
                catch (RuntimeException e) {
                    out.prop((Object)"Error:", (Object)SPY_GENERATE_ERR);
                    if (this.network == null || this.network.log() == null) break block7;
                    this.network.log().log(Level.INFO, SPY_GENERATE_ERR, e);
                }
            }
        }
        out.endProps();
        out.startProps("Overloaded Protocol Message Flags");
        for (MicrosMessageFlag.Flag f : MicrosMessageFlag.Flag.values()) {
            out.prop((Object)f, this.factoryFlags.isRaised(f));
        }
        out.println("(When true/raised the next message of that type is expected to be a response, not unsolicited)");
        out.endProps();
    }

    public void spy(SpyWriter out) throws Exception {
        this.spyDataAdditions(out);
        super.spy(out);
    }

    public boolean isParentLegal(BComponent parent) {
        return CommonUtil.isParentLegal((BComplex)parent, (BComplex)this, BMicrosNetwork.TYPE);
    }

    public void socketTerminated(BIpAddress addr, boolean server) {
        if (this.network != null && this.network.log() != null && this.network.isRunning()) {
            this.network.log().warning("Socket Terminated For: " + addr + " server:" + server);
        }
    }
}

