/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros;

import com.tridium.ndriver.BNDevice;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.protocol.LinkPingUtil;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.datatype.BMicrosIpAddress;
import com.tridiumemea.micros.point.BMicrosPointDeviceExt;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="address", type="micros:MicrosIpAddress", defaultValue="new BMicrosIpAddress(BMicrosDevice.DEFAULT_HOST, BMicrosDevice.DEFAULT_PORT)", flags=328), @NiagaraProperty(name="versionPMS", type="baja:String", defaultValue="BString.make(MicrosDictionary.LINK_CONFIG_FIELD.UNKNOWN_VERSION)", flags=65603), @NiagaraProperty(name="versionIFC", type="baja:String", defaultValue="BString.make(MicrosDictionary.LINK_CONFIG_FIELD.UNKNOWN_VERSION)", flags=65603), @NiagaraProperty(name="hotelID", type="baja:String", defaultValue="BString.make(MicrosDictionary.LINK_CONFIG_FIELD.UNKNOWN_VERSION)", flags=65603), @NiagaraProperty(name="points", type="micros:MicrosPointDeviceExt", defaultValue="new BMicrosPointDeviceExt()"), @NiagaraProperty(override=true, name="enabled", type="boolean", flags=5, defaultValue="true")})
public final class BMicrosDevice
extends BNDevice {
    public static final Property address = BMicrosDevice.newProperty((int)328, (BValue)new BMicrosIpAddress("localhost", 5001), null);
    public static final Property versionPMS = BMicrosDevice.newProperty((int)65603, (BValue)BString.make((String)"?"), null);
    public static final Property versionIFC = BMicrosDevice.newProperty((int)65603, (BValue)BString.make((String)"?"), null);
    public static final Property hotelID = BMicrosDevice.newProperty((int)65603, (BValue)BString.make((String)"?"), null);
    public static final Property points = BMicrosDevice.newProperty((int)0, (BValue)new BMicrosPointDeviceExt(), null);
    public static final Property enabled = BMicrosDevice.newProperty((int)5, (boolean)true, null);
    public static final Type TYPE = Sys.loadType(BMicrosDevice.class);
    private BMicrosNetwork network;
    private LinkPingUtil pingUtil;
    private BMicrosIpAddress currentAddress;
    private static final BIcon ICON = BIcon.std((String)"door.png");
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 5001;
    private static final String STALE = " {" + Lexicon.make((String)"baja").get("Status.stale") + '}';
    private static final String[] VERSION_PROPS = new String[]{versionIFC.getName(), versionPMS.getName(), hotelID.getName()};

    public BMicrosIpAddress getAddress() {
        return (BMicrosIpAddress)this.get(address);
    }

    public void setAddress(BMicrosIpAddress v) {
        this.set(address, (BValue)v, null);
    }

    public String getVersionPMS() {
        return this.getString(versionPMS);
    }

    public void setVersionPMS(String v) {
        this.setString(versionPMS, v, null);
    }

    public String getVersionIFC() {
        return this.getString(versionIFC);
    }

    public void setVersionIFC(String v) {
        this.setString(versionIFC, v, null);
    }

    public String getHotelID() {
        return this.getString(hotelID);
    }

    public void setHotelID(String v) {
        this.setString(hotelID, v, null);
    }

    public BMicrosPointDeviceExt getPoints() {
        return (BMicrosPointDeviceExt)this.get(points);
    }

    public void setPoints(BMicrosPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.network = (BMicrosNetwork)this.getNetwork();
        this.pingUtil = new LinkPingUtil(this.network);
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(status)) {
            this.network.getTcpConfig().statusUpdate();
        } else if (prop.equals(address) && this.currentAddress != null && !this.getAddress().isEqualAddress(this.currentAddress)) {
            this.network.log().fine(() -> "MicrosDevice:changed:IpAddress: " + (Object)((Object)this.currentAddress) + "->" + (Object)((Object)this.getAddress()));
            this.makeVersionPropsAppearStale();
            this.network.getLinkConfig().restartBroker(prop);
        }
    }

    public BMicrosIpAddress getCurrentAddress() {
        return this.currentAddress;
    }

    public void setCurrentAddress(BMicrosIpAddress newAddress) {
        this.currentAddress = (BMicrosIpAddress)newAddress.newCopy();
    }

    public void doPing() {
        this.pingUtil.ping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingOk() {
        super.pingOk();
        this.network.log().fine("MicrosDevice: pingOk");
        this.setFaultCause("");
        this.network.pingOk();
        this.network.setFaultCause("");
        if (this.network.getSockUtil().isCommInhibitFlag()) {
            this.network.getSockUtil().lowerCommInhibitFlag();
            this.network.getSockUtil().cancelCommInhibitTimer();
        }
        Object object = this.pingUtil.getPingLock();
        synchronized (object) {
            this.pingUtil.setReadOk(true);
            this.pingUtil.getPingLock().notifyAll();
        }
    }

    public void pingFail(String cause) {
        super.pingFail(cause);
        this.network.pingFail(cause);
    }

    public Type getNetworkType() {
        return BMicrosNetwork.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return CommonUtil.isParentLegal((BComplex)parent, (BComplex)this, BMicrosNetwork.TYPE);
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value.getType().is(BMicrosPointDeviceExt.TYPE)) {
            throw new LocalizableRuntimeException("micros", "microsDevice.thereCanBeOnlyOnePointDeviceExt");
        }
    }

    public void spy(SpyWriter out) throws Exception {
        this.spyDataAdditions(out);
        super.spy(out);
    }

    void spyDataAdditions(SpyWriter out) {
        out.startProps("Device");
        out.prop((Object)"Address", (Object)this.getAddress());
        out.endProps();
        out.startProps("Link Configuration Data Received");
        for (String p : VERSION_PROPS) {
            out.prop((Object)p, (Object)this.get(p));
        }
        out.endProps();
    }

    private void makeVersionPropsAppearStale() {
        for (String p : VERSION_PROPS) {
            String curVal = this.get(p).toString();
            if (curVal.equals("?") || curVal.endsWith(STALE)) continue;
            this.set(p, (BValue)BString.make((String)curVal.concat(STALE)));
        }
    }

    public void resetVersionProps() {
        String UNKNOWN = "?";
        this.setVersionIFC(UNKNOWN);
        this.setVersionPMS(UNKNOWN);
        this.setHotelID(UNKNOWN);
    }

    public LinkPingUtil getPingUtil() {
        return this.pingUtil;
    }

    public BIcon getIcon() {
        return ICON;
    }
}

