/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaCore.util;

import com.prosysopc.ua.stack.cert.CertificateCheck;
import com.prosysopc.ua.stack.cert.DefaultCertificateValidatorListener;
import com.prosysopc.ua.stack.cert.ValidationResult;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.tridium.opcUaCore.enums.BCertificateType;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpcUaCertificateValidationListener
implements DefaultCertificateValidatorListener {
    private static final Logger LOGGER = Logger.getLogger("opcUaCore.certificateValidationListener");
    private final BCertificateType certificateType;

    public OpcUaCertificateValidationListener(BCertificateType certificateType) {
        this.certificateType = certificateType;
    }

    @Override
    public ValidationResult onValidate(Cert certificate, ApplicationDescription applicationDescription, EnumSet<CertificateCheck> passedChecks) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String certificateInfo = '\n' + "*** " + this.certificateType.getDisplayTag(null) + " Certificate : " + '\n' + "Subject   : " + certificate.getCertificate().getSubjectX500Principal() + '\n' + "Valid from: " + certificate.getCertificate().getNotBefore() + '\n' + "Issued by : " + certificate.getCertificate().getIssuerX500Principal() + '\n' + "        to: " + certificate.getCertificate().getNotAfter().toString() + '\n';
            LOGGER.log(Level.FINE, certificateInfo);
        }
        if (!passedChecks.contains((Object)CertificateCheck.Trusted)) {
            LOGGER.log(Level.FINE, "* " + this.certificateType.getDisplayTag(null) + " certificate is NOT TRUSTED BY THE USER!");
            return ValidationResult.Reject;
        }
        if (!passedChecks.contains((Object)CertificateCheck.Signature)) {
            LOGGER.log(Level.FINE, "* " + this.certificateType.getDisplayTag(null) + " certificate is NOT SIGNED BY A TRUSTED SIGNER!");
            return ValidationResult.Reject;
        }
        if (!passedChecks.contains((Object)CertificateCheck.Validity)) {
            String oldOrYoung;
            boolean isOld;
            Date today = new Date();
            boolean isYoung = certificate.getCertificate().getNotBefore().compareTo(today) > 0;
            boolean bl = isOld = certificate.getCertificate().getNotAfter().compareTo(today) < 0;
            String string = isOld ? "(ANYMORE)" : (oldOrYoung = isYoung ? "(YET)" : "");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "* " + this.certificateType.getDisplayTag(null) + " certificate time interval IS NOT VALID " + oldOrYoung + '!');
            }
            return ValidationResult.Reject;
        }
        if (!passedChecks.contains((Object)CertificateCheck.Uri)) {
            LOGGER.log(Level.FINE, "* " + this.certificateType.getDisplayTag(null) + "  certificate URI DOES NOT MATCH THE 'ApplicationDescription' URI!");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "    ApplicationURI in ApplicationDescription = " + (applicationDescription == null ? null : applicationDescription.getApplicationUri()));
            }
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "    ApplicationURI in " + this.certificateType.getDisplayTag(null).toLowerCase() + "  certificate            = " + CertificateUtils.getApplicationUriOfCertificate(certificate));
                }
            }
            catch (CertificateParsingException e2) {
                LOGGER.log(Level.FINE, "    ApplicationURI in " + this.certificateType.getDisplayTag(null).toLowerCase() + "  certificate is INVALID");
            }
            return ValidationResult.Reject;
        }
        if (passedChecks.contains((Object)CertificateCheck.SelfSigned)) {
            LOGGER.log(Level.FINE, "* " + this.certificateType.getDisplayTag(null) + "  certificate is SELF-SIGNED.");
        }
        return ValidationResult.AcceptPermanently;
    }
}

