/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.opcUaCore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BOpcTcpSecurityPolicies
extends BBitString {
    public static final int BASIC128RSA15 = 1;
    public static final int BASIC256 = 2;
    public static final int BASIC256SHA256 = 4;
    public static final BOpcTcpSecurityPolicies DEFAULT = new BOpcTcpSecurityPolicies(7);
    public static final Type TYPE = Sys.loadType(BOpcTcpSecurityPolicies.class);
    public static final BOpcTcpSecurityPolicies basic128Rsa15 = (BOpcTcpSecurityPolicies)new BOpcTcpSecurityPolicies(1).intern();
    public static final BOpcTcpSecurityPolicies basic256 = (BOpcTcpSecurityPolicies)new BOpcTcpSecurityPolicies(2).intern();
    public static final BOpcTcpSecurityPolicies basic256Sha256 = (BOpcTcpSecurityPolicies)new BOpcTcpSecurityPolicies(4).intern();
    public static final BOpcTcpSecurityPolicies EMPTY = new BOpcTcpSecurityPolicies(0);
    public static final BOpcTcpSecurityPolicies ALL = DEFAULT;
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    private int bits;

    public Type getType() {
        return TYPE;
    }

    public static BOpcTcpSecurityPolicies make(boolean v) {
        if (v) {
            return ALL;
        }
        return EMPTY;
    }

    public static BOpcTcpSecurityPolicies make(int bits) {
        if (bits == BOpcTcpSecurityPolicies.ALL.bits) {
            return ALL;
        }
        if (bits == BOpcTcpSecurityPolicies.EMPTY.bits) {
            return EMPTY;
        }
        return (BOpcTcpSecurityPolicies)new BOpcTcpSecurityPolicies(bits).intern();
    }

    private BOpcTcpSecurityPolicies(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }

    public boolean includes(int mode) {
        return (this.bits & mode) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this.bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i2 = 0; i2 < ordinals.length; ++i2) {
            mask |= ordinals[i2];
        }
        return BOpcTcpSecurityPolicies.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this.bits == 0;
    }

    public boolean isAllPolicies() {
        return this.bits == BOpcTcpSecurityPolicies.ALL.bits;
    }

    public String getEmptyTag() {
        return "none";
    }

    public int hashCode() {
        return this.bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BOpcTcpSecurityPolicies) {
            return ((BOpcTcpSecurityPolicies)((Object)obj)).bits == this.bits;
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this.bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return BOpcTcpSecurityPolicies.make(in.readInt());
    }

    public String encodeToString() {
        return Integer.toHexString(this.bits);
    }

    public BObject decodeFromString(String s2) throws IOException {
        try {
            return BOpcTcpSecurityPolicies.make(Integer.parseInt(s2, 16));
        }
        catch (Exception e2) {
            throw new IOException("Invalid bits: " + s2);
        }
    }

    public String toString(Context cx) {
        if (this.bits == 0) {
            return "{}";
        }
        StringBuilder s2 = new StringBuilder();
        s2.append('{');
        if (this.includes(1)) {
            s2.append(support.getDisplayTag(1, cx));
            s2.append(" ");
        }
        if (this.includes(2)) {
            s2.append(support.getDisplayTag(2, cx));
            s2.append(" ");
        }
        if (this.includes(4)) {
            s2.append(support.getDisplayTag(4, cx));
            s2.append(" ");
        }
        s2.append('}');
        return s2.toString();
    }

    static {
        support.add(1, "Basic128Rsa15");
        support.add(2, "Basic256");
        support.add(4, "Basic256Sha256");
    }
}

