/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.TransitionType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.TransitionTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2310")
public abstract class TransitionTypeNodeBase
extends BaseObjectTypeNode
implements TransitionType {
    private static GeneratedNodeInitializer<TransitionTypeNode> Ou;

    protected TransitionTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<TransitionTypeNode> generatedNodeInitializer = TransitionTypeNodeBase.getTransitionTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((TransitionTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<TransitionTypeNode> getTransitionTypeNodeInitializer() {
        return Ou;
    }

    public static void setTransitionTypeNodeInitializer(GeneratedNodeInitializer<TransitionTypeNode> generatedNodeInitializer) {
        Ou = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getTransitionNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTransitionNumber() {
        UaProperty uaProperty = this.getTransitionNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node TransitionNumber does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTransitionNumber(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getTransitionNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransitionNumber failed unexpectedly", statusException);
        }
    }

    public void setTransitionNumber(long l2) {
        this.setTransitionNumber(UnsignedInteger.valueOf(l2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

