/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.SyntaxReferenceEntryType;
import com.prosysopc.ua.types.opcua.server.DictionaryEntryTypeNode;
import com.prosysopc.ua.types.opcua.server.SyntaxReferenceEntryTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=32439")
public abstract class SyntaxReferenceEntryTypeNodeBase
extends DictionaryEntryTypeNode
implements SyntaxReferenceEntryType {
    private static GeneratedNodeInitializer<SyntaxReferenceEntryTypeNode> NY;

    protected SyntaxReferenceEntryTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<SyntaxReferenceEntryTypeNode> generatedNodeInitializer = SyntaxReferenceEntryTypeNodeBase.getSyntaxReferenceEntryTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SyntaxReferenceEntryTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SyntaxReferenceEntryTypeNode> getSyntaxReferenceEntryTypeNodeInitializer() {
        return NY;
    }

    public static void setSyntaxReferenceEntryTypeNodeInitializer(GeneratedNodeInitializer<SyntaxReferenceEntryTypeNode> generatedNodeInitializer) {
        NY = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getCommonNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CommonName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getCommonName() {
        UaProperty uaProperty = this.getCommonNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node CommonName does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setCommonName(String string) {
        UaProperty uaProperty = this.getCommonNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CommonName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CommonName failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

