/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.SessionDiagnosticsDataType;
import com.prosysopc.ua.stack.core.SessionSecurityDiagnosticsDataType;
import com.prosysopc.ua.stack.core.SubscriptionDiagnosticsDataType;
import com.prosysopc.ua.types.opcua.SessionDiagnosticsObjectType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionDiagnosticsVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.SessionSecurityDiagnosticsTypeNode;
import com.prosysopc.ua.types.opcua.server.SubscriptionDiagnosticsArrayTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2029")
public abstract class SessionDiagnosticsObjectTypeNodeBase
extends BaseObjectTypeNode
implements SessionDiagnosticsObjectType {
    private static GeneratedNodeInitializer<SessionDiagnosticsObjectTypeNode> Ns;

    protected SessionDiagnosticsObjectTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSubscriptionDiagnosticsArrayNode());
        this.callAfterCreateIfExists(this.getSessionDiagnosticsNode());
        this.callAfterCreateIfExists(this.getSessionSecurityDiagnosticsNode());
        GeneratedNodeInitializer<SessionDiagnosticsObjectTypeNode> generatedNodeInitializer = SessionDiagnosticsObjectTypeNodeBase.getSessionDiagnosticsObjectTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SessionDiagnosticsObjectTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SessionDiagnosticsObjectTypeNode> getSessionDiagnosticsObjectTypeNodeInitializer() {
        return Ns;
    }

    public static void setSessionDiagnosticsObjectTypeNodeInitializer(GeneratedNodeInitializer<SessionDiagnosticsObjectTypeNode> generatedNodeInitializer) {
        Ns = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getCurrentRoleIdsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentRoleIds");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public NodeId[] getCurrentRoleIds() {
        UaProperty uaProperty = this.getCurrentRoleIdsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId[])object;
    }

    @Override
    @Optional
    public void setCurrentRoleIds(NodeId[] nodeIdArray) {
        UaProperty uaProperty = this.getCurrentRoleIdsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CurrentRoleIds failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeIdArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentRoleIds failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsArrayTypeNode getSubscriptionDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray");
        return (SubscriptionDiagnosticsArrayTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsDataType[] getSubscriptionDiagnosticsArray() {
        SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = this.getSubscriptionDiagnosticsArrayNode();
        if (subscriptionDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Mandatory node SubscriptionDiagnosticsArray does not exist");
        }
        Object object = subscriptionDiagnosticsArrayTypeNode.getValue().getValue().getValue();
        return (SubscriptionDiagnosticsDataType[])object;
    }

    @Override
    @Mandatory
    public void setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] subscriptionDiagnosticsDataTypeArray) {
        SubscriptionDiagnosticsArrayTypeNode subscriptionDiagnosticsArrayTypeNode = this.getSubscriptionDiagnosticsArrayNode();
        if (subscriptionDiagnosticsArrayTypeNode == null) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            subscriptionDiagnosticsArrayTypeNode.setValue(subscriptionDiagnosticsDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SessionDiagnosticsVariableTypeNode getSessionDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionDiagnostics");
        return (SessionDiagnosticsVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SessionDiagnosticsDataType getSessionDiagnostics() {
        SessionDiagnosticsVariableTypeNode sessionDiagnosticsVariableTypeNode = this.getSessionDiagnosticsNode();
        if (sessionDiagnosticsVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SessionDiagnostics does not exist");
        }
        Object object = sessionDiagnosticsVariableTypeNode.getValue().getValue().getValue();
        return (SessionDiagnosticsDataType)object;
    }

    @Override
    @Mandatory
    public void setSessionDiagnostics(SessionDiagnosticsDataType sessionDiagnosticsDataType) {
        SessionDiagnosticsVariableTypeNode sessionDiagnosticsVariableTypeNode = this.getSessionDiagnosticsNode();
        if (sessionDiagnosticsVariableTypeNode == null) {
            throw new RuntimeException("Setting SessionDiagnostics failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            sessionDiagnosticsVariableTypeNode.setValue(sessionDiagnosticsDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionDiagnostics failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public SessionSecurityDiagnosticsTypeNode getSessionSecurityDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionSecurityDiagnostics");
        return (SessionSecurityDiagnosticsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SessionSecurityDiagnosticsDataType getSessionSecurityDiagnostics() {
        SessionSecurityDiagnosticsTypeNode sessionSecurityDiagnosticsTypeNode = this.getSessionSecurityDiagnosticsNode();
        if (sessionSecurityDiagnosticsTypeNode == null) {
            throw new RuntimeException("Mandatory node SessionSecurityDiagnostics does not exist");
        }
        Object object = sessionSecurityDiagnosticsTypeNode.getValue().getValue().getValue();
        return (SessionSecurityDiagnosticsDataType)object;
    }

    @Override
    @Mandatory
    public void setSessionSecurityDiagnostics(SessionSecurityDiagnosticsDataType sessionSecurityDiagnosticsDataType) {
        SessionSecurityDiagnosticsTypeNode sessionSecurityDiagnosticsTypeNode = this.getSessionSecurityDiagnosticsNode();
        if (sessionSecurityDiagnosticsTypeNode == null) {
            throw new RuntimeException("Setting SessionSecurityDiagnostics failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            sessionSecurityDiagnosticsTypeNode.setValue(sessionSecurityDiagnosticsDataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionSecurityDiagnostics failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

