/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.AccessLevels;
import com.prosysopc.ua.MonitoredItemBase;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.types.opcua.ServerType;
import com.prosysopc.ua.types.opcua.server.ServerTypeNodeBase;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2004")
public class ServerTypeNode
extends ServerTypeNodeBase {
    protected ServerTypeNode(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.setServiceLevel(255);
        DateTime dateTime = DateTime.currentTime();
        DataValue dataValue = this.getGetMonitoredItemsNode().getProperty(new QualifiedName("InputArguments")).getValue();
        dataValue.setSourceTimestamp(dateTime);
        dataValue.setServerTimestamp(dateTime);
        DataValue dataValue2 = this.getGetMonitoredItemsNode().getProperty(new QualifiedName("OutputArguments")).getValue();
        dataValue2.setSourceTimestamp(dateTime);
        dataValue2.setServerTimestamp(dateTime);
        this.getServiceLevelNode().setAccessLevel(AccessLevels.READ_ONLY);
        this.setAuditing(Boolean.FALSE);
        ServerTypeNode.setAccessLevelRecursively(this.getServerStatusNode(), AccessLevels.READ_ONLY, new NodeId[0]);
        ServerTypeNode.setAccessLevelRecursively(this.getAuditingNode(), AccessLevels.READ_ONLY, new NodeId[0]);
    }

    @Override
    public void setServiceLevel(int n2) {
        this.setServiceLevel(UnsignedByte.valueOf(n2));
    }

    @Override
    public void setServiceLevel(UnsignedByte unsignedByte) {
        super.setServiceLevel(unsignedByte);
    }

    public void shutdown(long l2, LocalizedText localizedText) {
        this.getServerStatusNode().setState(ServerState.Shutdown);
        this.getServerStatusNode().b(l2, localizedText);
    }

    public void start() {
        this.updateNamespaceArray();
        this.getServerStatusNode().b(0L, new LocalizedText(""));
        this.getServerStatusNode().setState(ServerState.Running);
    }

    public void updateNamespaceArray() {
        try {
            this.getNamespaceArrayNode().setValue(this.nodeManager.getNamespaceTable().toArray());
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public void updateServerArray() {
        try {
            this.getServerArrayNode().setValue(this.nodeManager.getNodeManagerTable().getServerTable().toArray());
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    @Override
    protected ServerType.GetMonitoredItemsMethodOutputs onGetMonitoredItems(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        UnsignedInteger[] unsignedIntegerArray = null;
        UnsignedInteger[] unsignedIntegerArray2 = null;
        try {
            Subscription subscription = this.getNodeManager().getNodeManagerTable().getServer().getSubscriptionManager().getSubscription(unsignedInteger);
            if (subscription.getSession() == null || subscription.getSession() != serviceContext.getSession()) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            MonitoredItemBase[] monitoredItemBaseArray = subscription.getItems();
            unsignedIntegerArray = new UnsignedInteger[monitoredItemBaseArray.length];
            unsignedIntegerArray2 = new UnsignedInteger[monitoredItemBaseArray.length];
            for (int i2 = 0; i2 < monitoredItemBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = monitoredItemBaseArray[i2].getMonitoredItemId();
                unsignedIntegerArray2[i2] = monitoredItemBaseArray[i2].getClientHandle();
            }
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
        return new ServerType.GetMonitoredItemsMethodOutputs(unsignedIntegerArray, unsignedIntegerArray2);
    }

    @Override
    protected void onRequestServerStateChange(ServiceContext serviceContext, ServerState serverState, DateTime dateTime, UnsignedInteger unsignedInteger, LocalizedText localizedText, Boolean bl) throws StatusException {
        UaServer uaServer = this.getAddressSpace().getNodeManagerRoot().getServer();
        if (!uaServer.requestServerStateChange(serviceContext, serverState, dateTime, unsignedInteger, localizedText, bl)) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
    }

    @Override
    protected void onResendData(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        try {
            MonitoredItemBase[] monitoredItemBaseArray;
            Subscription subscription = this.getNodeManager().getNodeManagerTable().getServer().getSubscriptionManager().getSubscription(unsignedInteger);
            if (!subscription.getSession().equals(serviceContext.getSession())) {
                throw new StatusException(StatusCodes.Bad_UserAccessDenied);
            }
            for (MonitoredItemBase monitoredItemBase : monitoredItemBaseArray = subscription.getItems()) {
                if (!(monitoredItemBase instanceof MonitoredDataItem)) continue;
                MonitoredDataItem monitoredDataItem = (MonitoredDataItem)monitoredItemBase;
                monitoredDataItem.notifyResendData();
            }
        }
        catch (ServiceException serviceException) {
            throw new StatusException(StatusCodes.Bad_SubscriptionIdInvalid);
        }
    }

    @Override
    protected UnsignedInteger onSetSubscriptionDurable(ServiceContext serviceContext, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }
}

