/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.types.opcua.ServerConfigurationType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.CertificateGroupFolderTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeApplyChangesMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeCancelChangesMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeCreateSigningRequestMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeGetCertificatesMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeGetRejectedListMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeNode;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeResetToServerDefaultsMethod;
import com.prosysopc.ua.types.opcua.server.ServerConfigurationTypeUpdateCertificateMethod;
import com.prosysopc.ua.types.opcua.server.TransactionDiagnosticsTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12581")
public abstract class ServerConfigurationTypeNodeBase
extends BaseObjectTypeNode
implements ServerConfigurationType {
    private static GeneratedNodeInitializer<ServerConfigurationTypeNode> MY;
    private static ServerConfigurationTypeCancelChangesMethod MZ;
    private static ServerConfigurationTypeApplyChangesMethod Na;
    private static ServerConfigurationTypeGetCertificatesMethod Nb;
    private static ServerConfigurationTypeGetRejectedListMethod Nc;
    private static ServerConfigurationTypeUpdateCertificateMethod Nd;
    private static ServerConfigurationTypeCreateSigningRequestMethod Ne;
    private static ServerConfigurationTypeResetToServerDefaultsMethod Nf;

    protected ServerConfigurationTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getCertificateGroupsNode());
        this.callAfterCreateIfExists(this.getTransactionDiagnosticsNode());
        GeneratedNodeInitializer<ServerConfigurationTypeNode> generatedNodeInitializer = ServerConfigurationTypeNodeBase.getServerConfigurationTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ServerConfigurationTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ServerConfigurationTypeNode> getServerConfigurationTypeNodeInitializer() {
        return MY;
    }

    public static void setServerConfigurationTypeNodeInitializer(GeneratedNodeInitializer<ServerConfigurationTypeNode> generatedNodeInitializer) {
        MY = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getApplicationTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ApplicationType getApplicationType() {
        UaProperty uaProperty = this.getApplicationTypeNode();
        if (uaProperty == null) {
            return null;
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ApplicationType)variant.asEnum(ApplicationType.class);
    }

    @Override
    @Optional
    public void setApplicationType(ApplicationType applicationType) {
        UaProperty uaProperty = this.getApplicationTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(applicationType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ApplicationType failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getProductUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getProductUri() {
        UaProperty uaProperty = this.getProductUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setProductUri(String string) {
        UaProperty uaProperty = this.getProductUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ProductUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProductUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getServerCapabilitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerCapabilities");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerCapabilities() {
        UaProperty uaProperty = this.getServerCapabilitiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServerCapabilities does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerCapabilities(String[] stringArray) {
        UaProperty uaProperty = this.getServerCapabilitiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerCapabilities failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerCapabilities failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMulticastDnsEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MulticastDnsEnabled");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isMulticastDnsEnabled() {
        UaProperty uaProperty = this.getMulticastDnsEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MulticastDnsEnabled does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setMulticastDnsEnabled(Boolean bl) {
        UaProperty uaProperty = this.getMulticastDnsEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MulticastDnsEnabled failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MulticastDnsEnabled failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getInApplicationSetupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InApplicationSetup");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isInApplicationSetup() {
        UaProperty uaProperty = this.getInApplicationSetupNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setInApplicationSetup(Boolean bl) {
        UaProperty uaProperty = this.getInApplicationSetupNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InApplicationSetup failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InApplicationSetup failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getApplicationNamesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationNames");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText[] getApplicationNames() {
        UaProperty uaProperty = this.getApplicationNamesNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Optional
    public void setApplicationNames(LocalizedText[] localizedTextArray) {
        UaProperty uaProperty = this.getApplicationNamesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationNames failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedTextArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ApplicationNames failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getHasSecureElementNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HasSecureElement");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isHasSecureElement() {
        UaProperty uaProperty = this.getHasSecureElementNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setHasSecureElement(Boolean bl) {
        UaProperty uaProperty = this.getHasSecureElementNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting HasSecureElement failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting HasSecureElement failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getApplicationUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getApplicationUri() {
        UaProperty uaProperty = this.getApplicationUriNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setApplicationUri(String string) {
        UaProperty uaProperty = this.getApplicationUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ApplicationUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMaxTrustListSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTrustListSize");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxTrustListSize() {
        UaProperty uaProperty = this.getMaxTrustListSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MaxTrustListSize does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxTrustListSize(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxTrustListSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTrustListSize failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxTrustListSize failed unexpectedly", statusException);
        }
    }

    public void setMaxTrustListSize(long l2) {
        this.setMaxTrustListSize(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getSupportedPrivateKeyFormatsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SupportedPrivateKeyFormats");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getSupportedPrivateKeyFormats() {
        UaProperty uaProperty = this.getSupportedPrivateKeyFormatsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SupportedPrivateKeyFormats does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setSupportedPrivateKeyFormats(String[] stringArray) {
        UaProperty uaProperty = this.getSupportedPrivateKeyFormatsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SupportedPrivateKeyFormats failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SupportedPrivateKeyFormats failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSupportsTransactionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SupportsTransactions");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isSupportsTransactions() {
        UaProperty uaProperty = this.getSupportsTransactionsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setSupportsTransactions(Boolean bl) {
        UaProperty uaProperty = this.getSupportsTransactionsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SupportsTransactions failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SupportsTransactions failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public CertificateGroupFolderTypeNode getCertificateGroupsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateGroups");
        return (CertificateGroupFolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public TransactionDiagnosticsTypeNode getTransactionDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransactionDiagnostics");
        return (TransactionDiagnosticsTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "CancelChanges"), nodeId)) {
            this.w(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ApplyChanges"), nodeId)) {
            this.x(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "GetCertificates"), nodeId)) {
            return this.p(serviceContext, (NodeId)variantArray[0].getValue()).asVariantArray();
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "GetRejectedList"), nodeId)) {
            return new Variant[]{new Variant(this.j(serviceContext))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCertificate"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (NodeId)variantArray[0].getValue(), (NodeId)variantArray[1].getValue(), (ByteString)variantArray[2].getValue(), (ByteString[])variantArray[3].getValue(), (String)variantArray[4].getValue(), (ByteString)variantArray[5].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "CreateSigningRequest"), nodeId)) {
            return new Variant[]{new Variant(this.a(serviceContext, (NodeId)variantArray[0].getValue(), (NodeId)variantArray[1].getValue(), (String)variantArray[2].getValue(), (Boolean)variantArray[3].getValue(), (ByteString)variantArray[4].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ResetToServerDefaults"), nodeId)) {
            this.y(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getCancelChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CancelChanges");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onCancelChanges(ServiceContext var1) throws StatusException;

    @Override
    public void cancelChanges() throws StatusException {
        this.w(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void w(ServiceContext serviceContext) throws StatusException {
        ServerConfigurationTypeCancelChangesMethod serverConfigurationTypeCancelChangesMethod = ServerConfigurationTypeNodeBase.getCancelChangesMethodImplementation();
        if (serverConfigurationTypeCancelChangesMethod != null) {
            serverConfigurationTypeCancelChangesMethod.cancelChanges(serviceContext, (ServerConfigurationTypeNode)this);
        } else {
            this.onCancelChanges(serviceContext);
        }
    }

    public static ServerConfigurationTypeCancelChangesMethod getCancelChangesMethodImplementation() {
        return MZ;
    }

    public static void setCancelChangesMethodImplementation(ServerConfigurationTypeCancelChangesMethod serverConfigurationTypeCancelChangesMethod) {
        MZ = serverConfigurationTypeCancelChangesMethod;
    }

    @Override
    @Mandatory
    public UaMethod getApplyChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplyChanges");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onApplyChanges(ServiceContext var1) throws StatusException;

    @Override
    public void applyChanges() throws StatusException {
        this.x(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void x(ServiceContext serviceContext) throws StatusException {
        ServerConfigurationTypeApplyChangesMethod serverConfigurationTypeApplyChangesMethod = ServerConfigurationTypeNodeBase.getApplyChangesMethodImplementation();
        if (serverConfigurationTypeApplyChangesMethod != null) {
            serverConfigurationTypeApplyChangesMethod.applyChanges(serviceContext, (ServerConfigurationTypeNode)this);
        } else {
            this.onApplyChanges(serviceContext);
        }
    }

    public static ServerConfigurationTypeApplyChangesMethod getApplyChangesMethodImplementation() {
        return Na;
    }

    public static void setApplyChangesMethodImplementation(ServerConfigurationTypeApplyChangesMethod serverConfigurationTypeApplyChangesMethod) {
        Na = serverConfigurationTypeApplyChangesMethod;
    }

    @Override
    @Optional
    public UaMethod getGetCertificatesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetCertificates");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ServerConfigurationType.GetCertificatesMethodOutputs onGetCertificates(ServiceContext var1, NodeId var2) throws StatusException;

    @Override
    public ServerConfigurationType.GetCertificatesMethodOutputs getCertificates(NodeId nodeId) throws StatusException {
        return this.p(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId);
    }

    private ServerConfigurationType.GetCertificatesMethodOutputs p(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        ServerConfigurationTypeGetCertificatesMethod serverConfigurationTypeGetCertificatesMethod = ServerConfigurationTypeNodeBase.getGetCertificatesMethodImplementation();
        if (serverConfigurationTypeGetCertificatesMethod != null) {
            return serverConfigurationTypeGetCertificatesMethod.getCertificates(serviceContext, (ServerConfigurationTypeNode)this, nodeId);
        }
        return this.onGetCertificates(serviceContext, nodeId);
    }

    public static ServerConfigurationTypeGetCertificatesMethod getGetCertificatesMethodImplementation() {
        return Nb;
    }

    public static void setGetCertificatesMethodImplementation(ServerConfigurationTypeGetCertificatesMethod serverConfigurationTypeGetCertificatesMethod) {
        Nb = serverConfigurationTypeGetCertificatesMethod;
    }

    @Override
    @Mandatory
    public UaMethod getGetRejectedListNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetRejectedList");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ByteString[] onGetRejectedList(ServiceContext var1) throws StatusException;

    @Override
    public ByteString[] getRejectedList() throws StatusException {
        return this.j(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private ByteString[] j(ServiceContext serviceContext) throws StatusException {
        ServerConfigurationTypeGetRejectedListMethod serverConfigurationTypeGetRejectedListMethod = ServerConfigurationTypeNodeBase.getGetRejectedListMethodImplementation();
        if (serverConfigurationTypeGetRejectedListMethod != null) {
            return serverConfigurationTypeGetRejectedListMethod.getRejectedList(serviceContext, (ServerConfigurationTypeNode)this);
        }
        return this.onGetRejectedList(serviceContext);
    }

    public static ServerConfigurationTypeGetRejectedListMethod getGetRejectedListMethodImplementation() {
        return Nc;
    }

    public static void setGetRejectedListMethodImplementation(ServerConfigurationTypeGetRejectedListMethod serverConfigurationTypeGetRejectedListMethod) {
        Nc = serverConfigurationTypeGetRejectedListMethod;
    }

    @Override
    @Mandatory
    public UaMethod getUpdateCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdateCertificate");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract Boolean onUpdateCertificate(ServiceContext var1, NodeId var2, NodeId var3, ByteString var4, ByteString[] var5, String var6, ByteString var7) throws StatusException;

    @Override
    public Boolean updateCertificate(NodeId nodeId, NodeId nodeId2, ByteString byteString, ByteString[] byteStringArray, String string, ByteString byteString2) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, nodeId2, byteString, byteStringArray, string, byteString2);
    }

    private Boolean a(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, ByteString byteString, ByteString[] byteStringArray, String string, ByteString byteString2) throws StatusException {
        ServerConfigurationTypeUpdateCertificateMethod serverConfigurationTypeUpdateCertificateMethod = ServerConfigurationTypeNodeBase.getUpdateCertificateMethodImplementation();
        if (serverConfigurationTypeUpdateCertificateMethod != null) {
            return serverConfigurationTypeUpdateCertificateMethod.updateCertificate(serviceContext, (ServerConfigurationTypeNode)this, nodeId, nodeId2, byteString, byteStringArray, string, byteString2);
        }
        return this.onUpdateCertificate(serviceContext, nodeId, nodeId2, byteString, byteStringArray, string, byteString2);
    }

    public static ServerConfigurationTypeUpdateCertificateMethod getUpdateCertificateMethodImplementation() {
        return Nd;
    }

    public static void setUpdateCertificateMethodImplementation(ServerConfigurationTypeUpdateCertificateMethod serverConfigurationTypeUpdateCertificateMethod) {
        Nd = serverConfigurationTypeUpdateCertificateMethod;
    }

    @Override
    @Mandatory
    public UaMethod getCreateSigningRequestNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CreateSigningRequest");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract ByteString onCreateSigningRequest(ServiceContext var1, NodeId var2, NodeId var3, String var4, Boolean var5, ByteString var6) throws StatusException;

    @Override
    public ByteString createSigningRequest(NodeId nodeId, NodeId nodeId2, String string, Boolean bl, ByteString byteString) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, nodeId, nodeId2, string, bl, byteString);
    }

    private ByteString a(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, String string, Boolean bl, ByteString byteString) throws StatusException {
        ServerConfigurationTypeCreateSigningRequestMethod serverConfigurationTypeCreateSigningRequestMethod = ServerConfigurationTypeNodeBase.getCreateSigningRequestMethodImplementation();
        if (serverConfigurationTypeCreateSigningRequestMethod != null) {
            return serverConfigurationTypeCreateSigningRequestMethod.createSigningRequest(serviceContext, (ServerConfigurationTypeNode)this, nodeId, nodeId2, string, bl, byteString);
        }
        return this.onCreateSigningRequest(serviceContext, nodeId, nodeId2, string, bl, byteString);
    }

    public static ServerConfigurationTypeCreateSigningRequestMethod getCreateSigningRequestMethodImplementation() {
        return Ne;
    }

    public static void setCreateSigningRequestMethodImplementation(ServerConfigurationTypeCreateSigningRequestMethod serverConfigurationTypeCreateSigningRequestMethod) {
        Ne = serverConfigurationTypeCreateSigningRequestMethod;
    }

    @Override
    @Optional
    public UaMethod getResetToServerDefaultsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResetToServerDefaults");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onResetToServerDefaults(ServiceContext var1) throws StatusException;

    @Override
    public void resetToServerDefaults() throws StatusException {
        this.y(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void y(ServiceContext serviceContext) throws StatusException {
        ServerConfigurationTypeResetToServerDefaultsMethod serverConfigurationTypeResetToServerDefaultsMethod = ServerConfigurationTypeNodeBase.getResetToServerDefaultsMethodImplementation();
        if (serverConfigurationTypeResetToServerDefaultsMethod != null) {
            serverConfigurationTypeResetToServerDefaultsMethod.resetToServerDefaults(serviceContext, (ServerConfigurationTypeNode)this);
        } else {
            this.onResetToServerDefaults(serviceContext);
        }
    }

    public static ServerConfigurationTypeResetToServerDefaultsMethod getResetToServerDefaultsMethodImplementation() {
        return Nf;
    }

    public static void setResetToServerDefaultsMethodImplementation(ServerConfigurationTypeResetToServerDefaultsMethod serverConfigurationTypeResetToServerDefaultsMethod) {
        Nf = serverConfigurationTypeResetToServerDefaultsMethod;
    }
}

