/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.SecurityGroupType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.SecurityGroupTypeForceKeyRotationMethod;
import com.prosysopc.ua.types.opcua.server.SecurityGroupTypeInvalidateKeysMethod;
import com.prosysopc.ua.types.opcua.server.SecurityGroupTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15471")
public abstract class SecurityGroupTypeNodeBase
extends BaseObjectTypeNode
implements SecurityGroupType {
    private static GeneratedNodeInitializer<SecurityGroupTypeNode> MS;
    private static SecurityGroupTypeInvalidateKeysMethod MT;
    private static SecurityGroupTypeForceKeyRotationMethod MU;

    protected SecurityGroupTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<SecurityGroupTypeNode> generatedNodeInitializer = SecurityGroupTypeNodeBase.getSecurityGroupTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((SecurityGroupTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<SecurityGroupTypeNode> getSecurityGroupTypeNodeInitializer() {
        return MS;
    }

    public static void setSecurityGroupTypeNodeInitializer(GeneratedNodeInitializer<SecurityGroupTypeNode> generatedNodeInitializer) {
        MS = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getKeyLifetimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "KeyLifetime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getKeyLifetime() {
        UaProperty uaProperty = this.getKeyLifetimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node KeyLifetime does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setKeyLifetime(Double d2) {
        UaProperty uaProperty = this.getKeyLifetimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting KeyLifetime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting KeyLifetime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMaxPastKeyCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxPastKeyCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxPastKeyCount() {
        UaProperty uaProperty = this.getMaxPastKeyCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MaxPastKeyCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxPastKeyCount(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxPastKeyCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxPastKeyCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxPastKeyCount failed unexpectedly", statusException);
        }
    }

    public void setMaxPastKeyCount(long l2) {
        this.setMaxPastKeyCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getSecurityGroupIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityGroupId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityGroupId() {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SecurityGroupId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityGroupId(String string) {
        UaProperty uaProperty = this.getSecurityGroupIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityGroupId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityGroupId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSecurityPolicyUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityPolicyUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSecurityPolicyUri() {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SecurityPolicyUri does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSecurityPolicyUri(String string) {
        UaProperty uaProperty = this.getSecurityPolicyUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SecurityPolicyUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SecurityPolicyUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMaxFutureKeyCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxFutureKeyCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getMaxFutureKeyCount() {
        UaProperty uaProperty = this.getMaxFutureKeyCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node MaxFutureKeyCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setMaxFutureKeyCount(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getMaxFutureKeyCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxFutureKeyCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MaxFutureKeyCount failed unexpectedly", statusException);
        }
    }

    public void setMaxFutureKeyCount(long l2) {
        this.setMaxFutureKeyCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "InvalidateKeys"), nodeId)) {
            this.u(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "ForceKeyRotation"), nodeId)) {
            this.v(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getInvalidateKeysNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InvalidateKeys");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onInvalidateKeys(ServiceContext var1) throws StatusException;

    @Override
    public void invalidateKeys() throws StatusException {
        this.u(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void u(ServiceContext serviceContext) throws StatusException {
        SecurityGroupTypeInvalidateKeysMethod securityGroupTypeInvalidateKeysMethod = SecurityGroupTypeNodeBase.getInvalidateKeysMethodImplementation();
        if (securityGroupTypeInvalidateKeysMethod != null) {
            securityGroupTypeInvalidateKeysMethod.invalidateKeys(serviceContext, (SecurityGroupTypeNode)this);
        } else {
            this.onInvalidateKeys(serviceContext);
        }
    }

    public static SecurityGroupTypeInvalidateKeysMethod getInvalidateKeysMethodImplementation() {
        return MT;
    }

    public static void setInvalidateKeysMethodImplementation(SecurityGroupTypeInvalidateKeysMethod securityGroupTypeInvalidateKeysMethod) {
        MT = securityGroupTypeInvalidateKeysMethod;
    }

    @Override
    @Optional
    public UaMethod getForceKeyRotationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ForceKeyRotation");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onForceKeyRotation(ServiceContext var1) throws StatusException;

    @Override
    public void forceKeyRotation() throws StatusException {
        this.v(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void v(ServiceContext serviceContext) throws StatusException {
        SecurityGroupTypeForceKeyRotationMethod securityGroupTypeForceKeyRotationMethod = SecurityGroupTypeNodeBase.getForceKeyRotationMethodImplementation();
        if (securityGroupTypeForceKeyRotationMethod != null) {
            securityGroupTypeForceKeyRotationMethod.forceKeyRotation(serviceContext, (SecurityGroupTypeNode)this);
        } else {
            this.onForceKeyRotation(serviceContext);
        }
    }

    public static SecurityGroupTypeForceKeyRotationMethod getForceKeyRotationMethodImplementation() {
        return MU;
    }

    public static void setForceKeyRotationMethodImplementation(SecurityGroupTypeForceKeyRotationMethod securityGroupTypeForceKeyRotationMethod) {
        MU = securityGroupTypeForceKeyRotationMethod;
    }
}

