/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.EndpointType;
import com.prosysopc.ua.stack.core.IdentityMappingRuleType;
import com.prosysopc.ua.types.opcua.RoleType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.RoleTypeAddApplicationMethod;
import com.prosysopc.ua.types.opcua.server.RoleTypeAddEndpointMethod;
import com.prosysopc.ua.types.opcua.server.RoleTypeAddIdentityMethod;
import com.prosysopc.ua.types.opcua.server.RoleTypeNode;
import com.prosysopc.ua.types.opcua.server.RoleTypeRemoveApplicationMethod;
import com.prosysopc.ua.types.opcua.server.RoleTypeRemoveEndpointMethod;
import com.prosysopc.ua.types.opcua.server.RoleTypeRemoveIdentityMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15620")
public abstract class RoleTypeNodeBase
extends BaseObjectTypeNode
implements RoleType {
    private static GeneratedNodeInitializer<RoleTypeNode> MB;
    private static RoleTypeRemoveApplicationMethod MC;
    private static RoleTypeRemoveEndpointMethod MD;
    private static RoleTypeAddIdentityMethod ME;
    private static RoleTypeAddEndpointMethod MF;
    private static RoleTypeAddApplicationMethod MG;
    private static RoleTypeRemoveIdentityMethod MH;

    protected RoleTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<RoleTypeNode> generatedNodeInitializer = RoleTypeNodeBase.getRoleTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((RoleTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<RoleTypeNode> getRoleTypeNodeInitializer() {
        return MB;
    }

    public static void setRoleTypeNodeInitializer(GeneratedNodeInitializer<RoleTypeNode> generatedNodeInitializer) {
        MB = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getApplicationsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Applications");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String[] getApplications() {
        UaProperty uaProperty = this.getApplicationsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Optional
    public void setApplications(String[] stringArray) {
        UaProperty uaProperty = this.getApplicationsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Applications failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(stringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Applications failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getIdentitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Identities");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public IdentityMappingRuleType[] getIdentities() {
        UaProperty uaProperty = this.getIdentitiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Identities does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (IdentityMappingRuleType[])object;
    }

    @Override
    @Mandatory
    public void setIdentities(IdentityMappingRuleType[] identityMappingRuleTypeArray) {
        UaProperty uaProperty = this.getIdentitiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Identities failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(identityMappingRuleTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Identities failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getCustomConfigurationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CustomConfiguration");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isCustomConfiguration() {
        UaProperty uaProperty = this.getCustomConfigurationNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setCustomConfiguration(Boolean bl) {
        UaProperty uaProperty = this.getCustomConfigurationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CustomConfiguration failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CustomConfiguration failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEndpointsExcludeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointsExclude");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isEndpointsExclude() {
        UaProperty uaProperty = this.getEndpointsExcludeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setEndpointsExclude(Boolean bl) {
        UaProperty uaProperty = this.getEndpointsExcludeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndpointsExclude failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndpointsExclude failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEndpointsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Endpoints");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EndpointType[] getEndpoints() {
        UaProperty uaProperty = this.getEndpointsNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (EndpointType[])object;
    }

    @Override
    @Optional
    public void setEndpoints(EndpointType[] endpointTypeArray) {
        UaProperty uaProperty = this.getEndpointsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Endpoints failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(endpointTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Endpoints failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getApplicationsExcludeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ApplicationsExclude");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isApplicationsExclude() {
        UaProperty uaProperty = this.getApplicationsExcludeNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setApplicationsExclude(Boolean bl) {
        UaProperty uaProperty = this.getApplicationsExcludeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ApplicationsExclude failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ApplicationsExclude failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveApplication"), nodeId)) {
            this.g(serviceContext, (String)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveEndpoint"), nodeId)) {
            this.a(serviceContext, (EndpointType)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddIdentity"), nodeId)) {
            this.a(serviceContext, (IdentityMappingRuleType)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddEndpoint"), nodeId)) {
            this.b(serviceContext, (EndpointType)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "AddApplication"), nodeId)) {
            this.h(serviceContext, (String)variantArray[0].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveIdentity"), nodeId)) {
            this.b(serviceContext, (IdentityMappingRuleType)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getRemoveApplicationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveApplication");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveApplication(ServiceContext var1, String var2) throws StatusException;

    @Override
    public void removeApplication(String string) throws StatusException {
        this.g(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
    }

    private void g(ServiceContext serviceContext, String string) throws StatusException {
        RoleTypeRemoveApplicationMethod roleTypeRemoveApplicationMethod = RoleTypeNodeBase.getRemoveApplicationMethodImplementation();
        if (roleTypeRemoveApplicationMethod != null) {
            roleTypeRemoveApplicationMethod.removeApplication(serviceContext, (RoleTypeNode)this, string);
        } else {
            this.onRemoveApplication(serviceContext, string);
        }
    }

    public static RoleTypeRemoveApplicationMethod getRemoveApplicationMethodImplementation() {
        return MC;
    }

    public static void setRemoveApplicationMethodImplementation(RoleTypeRemoveApplicationMethod roleTypeRemoveApplicationMethod) {
        MC = roleTypeRemoveApplicationMethod;
    }

    @Override
    @Optional
    public UaMethod getRemoveEndpointNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveEndpoint");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveEndpoint(ServiceContext var1, EndpointType var2) throws StatusException;

    @Override
    public void removeEndpoint(EndpointType endpointType) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, endpointType);
    }

    private void a(ServiceContext serviceContext, EndpointType endpointType) throws StatusException {
        RoleTypeRemoveEndpointMethod roleTypeRemoveEndpointMethod = RoleTypeNodeBase.getRemoveEndpointMethodImplementation();
        if (roleTypeRemoveEndpointMethod != null) {
            roleTypeRemoveEndpointMethod.removeEndpoint(serviceContext, (RoleTypeNode)this, endpointType);
        } else {
            this.onRemoveEndpoint(serviceContext, endpointType);
        }
    }

    public static RoleTypeRemoveEndpointMethod getRemoveEndpointMethodImplementation() {
        return MD;
    }

    public static void setRemoveEndpointMethodImplementation(RoleTypeRemoveEndpointMethod roleTypeRemoveEndpointMethod) {
        MD = roleTypeRemoveEndpointMethod;
    }

    @Override
    @Optional
    public UaMethod getAddIdentityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddIdentity");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onAddIdentity(ServiceContext var1, IdentityMappingRuleType var2) throws StatusException;

    @Override
    public void addIdentity(IdentityMappingRuleType identityMappingRuleType) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, identityMappingRuleType);
    }

    private void a(ServiceContext serviceContext, IdentityMappingRuleType identityMappingRuleType) throws StatusException {
        RoleTypeAddIdentityMethod roleTypeAddIdentityMethod = RoleTypeNodeBase.getAddIdentityMethodImplementation();
        if (roleTypeAddIdentityMethod != null) {
            roleTypeAddIdentityMethod.addIdentity(serviceContext, (RoleTypeNode)this, identityMappingRuleType);
        } else {
            this.onAddIdentity(serviceContext, identityMappingRuleType);
        }
    }

    public static RoleTypeAddIdentityMethod getAddIdentityMethodImplementation() {
        return ME;
    }

    public static void setAddIdentityMethodImplementation(RoleTypeAddIdentityMethod roleTypeAddIdentityMethod) {
        ME = roleTypeAddIdentityMethod;
    }

    @Override
    @Optional
    public UaMethod getAddEndpointNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddEndpoint");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onAddEndpoint(ServiceContext var1, EndpointType var2) throws StatusException;

    @Override
    public void addEndpoint(EndpointType endpointType) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, endpointType);
    }

    private void b(ServiceContext serviceContext, EndpointType endpointType) throws StatusException {
        RoleTypeAddEndpointMethod roleTypeAddEndpointMethod = RoleTypeNodeBase.getAddEndpointMethodImplementation();
        if (roleTypeAddEndpointMethod != null) {
            roleTypeAddEndpointMethod.addEndpoint(serviceContext, (RoleTypeNode)this, endpointType);
        } else {
            this.onAddEndpoint(serviceContext, endpointType);
        }
    }

    public static RoleTypeAddEndpointMethod getAddEndpointMethodImplementation() {
        return MF;
    }

    public static void setAddEndpointMethodImplementation(RoleTypeAddEndpointMethod roleTypeAddEndpointMethod) {
        MF = roleTypeAddEndpointMethod;
    }

    @Override
    @Optional
    public UaMethod getAddApplicationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AddApplication");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onAddApplication(ServiceContext var1, String var2) throws StatusException;

    @Override
    public void addApplication(String string) throws StatusException {
        this.h(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
    }

    private void h(ServiceContext serviceContext, String string) throws StatusException {
        RoleTypeAddApplicationMethod roleTypeAddApplicationMethod = RoleTypeNodeBase.getAddApplicationMethodImplementation();
        if (roleTypeAddApplicationMethod != null) {
            roleTypeAddApplicationMethod.addApplication(serviceContext, (RoleTypeNode)this, string);
        } else {
            this.onAddApplication(serviceContext, string);
        }
    }

    public static RoleTypeAddApplicationMethod getAddApplicationMethodImplementation() {
        return MG;
    }

    public static void setAddApplicationMethodImplementation(RoleTypeAddApplicationMethod roleTypeAddApplicationMethod) {
        MG = roleTypeAddApplicationMethod;
    }

    @Override
    @Optional
    public UaMethod getRemoveIdentityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveIdentity");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onRemoveIdentity(ServiceContext var1, IdentityMappingRuleType var2) throws StatusException;

    @Override
    public void removeIdentity(IdentityMappingRuleType identityMappingRuleType) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, identityMappingRuleType);
    }

    private void b(ServiceContext serviceContext, IdentityMappingRuleType identityMappingRuleType) throws StatusException {
        RoleTypeRemoveIdentityMethod roleTypeRemoveIdentityMethod = RoleTypeNodeBase.getRemoveIdentityMethodImplementation();
        if (roleTypeRemoveIdentityMethod != null) {
            roleTypeRemoveIdentityMethod.removeIdentity(serviceContext, (RoleTypeNode)this, identityMappingRuleType);
        } else {
            this.onRemoveIdentity(serviceContext, identityMappingRuleType);
        }
    }

    public static RoleTypeRemoveIdentityMethod getRemoveIdentityMethodImplementation() {
        return MH;
    }

    public static void setRemoveIdentityMethodImplementation(RoleTypeRemoveIdentityMethod roleTypeRemoveIdentityMethod) {
        MH = roleTypeRemoveIdentityMethod;
    }
}

