/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.PubSubState;
import com.prosysopc.ua.types.opcua.PubSubStatusType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubStatusTypeDisableMethod;
import com.prosysopc.ua.types.opcua.server.PubSubStatusTypeEnableMethod;
import com.prosysopc.ua.types.opcua.server.PubSubStatusTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14643")
public abstract class PubSubStatusTypeNodeBase
extends BaseObjectTypeNode
implements PubSubStatusType {
    private static GeneratedNodeInitializer<PubSubStatusTypeNode> LX;
    private static PubSubStatusTypeDisableMethod LY;
    private static PubSubStatusTypeEnableMethod LZ;

    protected PubSubStatusTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getStateNode());
        GeneratedNodeInitializer<PubSubStatusTypeNode> generatedNodeInitializer = PubSubStatusTypeNodeBase.getPubSubStatusTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubStatusTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubStatusTypeNode> getPubSubStatusTypeNodeInitializer() {
        return LX;
    }

    public static void setPubSubStatusTypeNodeInitializer(GeneratedNodeInitializer<PubSubStatusTypeNode> generatedNodeInitializer) {
        LX = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubState getState() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node State does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (PubSubState)variant.asEnum(PubSubState.class);
    }

    @Override
    @Mandatory
    public void setState(PubSubState pubSubState) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getStateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting State failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(pubSubState);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting State failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Disable"), nodeId)) {
            this.l(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Enable"), nodeId)) {
            this.k(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getDisableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Disable");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onDisable(ServiceContext var1) throws StatusException;

    @Override
    public void disable() throws StatusException {
        this.l(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void l(ServiceContext serviceContext) throws StatusException {
        PubSubStatusTypeDisableMethod pubSubStatusTypeDisableMethod = PubSubStatusTypeNodeBase.getDisableMethodImplementation();
        if (pubSubStatusTypeDisableMethod != null) {
            pubSubStatusTypeDisableMethod.disable(serviceContext, (PubSubStatusTypeNode)this);
        } else {
            this.onDisable(serviceContext);
        }
    }

    public static PubSubStatusTypeDisableMethod getDisableMethodImplementation() {
        return LY;
    }

    public static void setDisableMethodImplementation(PubSubStatusTypeDisableMethod pubSubStatusTypeDisableMethod) {
        LY = pubSubStatusTypeDisableMethod;
    }

    @Override
    @Optional
    public UaMethod getEnableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Enable");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onEnable(ServiceContext var1) throws StatusException;

    @Override
    public void enable() throws StatusException {
        this.k(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void k(ServiceContext serviceContext) throws StatusException {
        PubSubStatusTypeEnableMethod pubSubStatusTypeEnableMethod = PubSubStatusTypeNodeBase.getEnableMethodImplementation();
        if (pubSubStatusTypeEnableMethod != null) {
            pubSubStatusTypeEnableMethod.enable(serviceContext, (PubSubStatusTypeNode)this);
        } else {
            this.onEnable(serviceContext);
        }
    }

    public static PubSubStatusTypeEnableMethod getEnableMethodImplementation() {
        return LZ;
    }

    public static void setEnableMethodImplementation(PubSubStatusTypeEnableMethod pubSubStatusTypeEnableMethod) {
        LZ = pubSubStatusTypeEnableMethod;
    }
}

