/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.PubSubKeyServiceType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubKeyPushTargetFolderTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubKeyServiceTypeGetSecurityGroupMethod;
import com.prosysopc.ua.types.opcua.server.PubSubKeyServiceTypeGetSecurityKeysMethod;
import com.prosysopc.ua.types.opcua.server.PubSubKeyServiceTypeNode;
import com.prosysopc.ua.types.opcua.server.SecurityGroupFolderTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15906")
public abstract class PubSubKeyServiceTypeNodeBase
extends BaseObjectTypeNode
implements PubSubKeyServiceType {
    private static GeneratedNodeInitializer<PubSubKeyServiceTypeNode> LT;
    private static PubSubKeyServiceTypeGetSecurityGroupMethod LU;
    private static PubSubKeyServiceTypeGetSecurityKeysMethod LV;

    protected PubSubKeyServiceTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getSecurityGroupsNode());
        this.callAfterCreateIfExists(this.getKeyPushTargetsNode());
        GeneratedNodeInitializer<PubSubKeyServiceTypeNode> generatedNodeInitializer = PubSubKeyServiceTypeNodeBase.getPubSubKeyServiceTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((PubSubKeyServiceTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<PubSubKeyServiceTypeNode> getPubSubKeyServiceTypeNodeInitializer() {
        return LT;
    }

    public static void setPubSubKeyServiceTypeNodeInitializer(GeneratedNodeInitializer<PubSubKeyServiceTypeNode> generatedNodeInitializer) {
        LT = generatedNodeInitializer;
    }

    @Override
    @Optional
    public SecurityGroupFolderTypeNode getSecurityGroupsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecurityGroups");
        return (SecurityGroupFolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubKeyPushTargetFolderTypeNode getKeyPushTargetsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "KeyPushTargets");
        return (PubSubKeyPushTargetFolderTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "GetSecurityGroup"), nodeId)) {
            return new Variant[]{new Variant(this.f(serviceContext, (String)variantArray[0].getValue()))};
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "GetSecurityKeys"), nodeId)) {
            return this.a(serviceContext, (String)variantArray[0].getValue(), (UnsignedInteger)variantArray[1].getValue(), (UnsignedInteger)variantArray[2].getValue()).asVariantArray();
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getGetSecurityGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetSecurityGroup");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract NodeId onGetSecurityGroup(ServiceContext var1, String var2) throws StatusException;

    @Override
    public NodeId getSecurityGroup(String string) throws StatusException {
        return this.f(ServiceContext.INTERNAL_OPERATION_CONTEXT, string);
    }

    private NodeId f(ServiceContext serviceContext, String string) throws StatusException {
        PubSubKeyServiceTypeGetSecurityGroupMethod pubSubKeyServiceTypeGetSecurityGroupMethod = PubSubKeyServiceTypeNodeBase.getGetSecurityGroupMethodImplementation();
        if (pubSubKeyServiceTypeGetSecurityGroupMethod != null) {
            return pubSubKeyServiceTypeGetSecurityGroupMethod.getSecurityGroup(serviceContext, (PubSubKeyServiceTypeNode)this, string);
        }
        return this.onGetSecurityGroup(serviceContext, string);
    }

    public static PubSubKeyServiceTypeGetSecurityGroupMethod getGetSecurityGroupMethodImplementation() {
        return LU;
    }

    public static void setGetSecurityGroupMethodImplementation(PubSubKeyServiceTypeGetSecurityGroupMethod pubSubKeyServiceTypeGetSecurityGroupMethod) {
        LU = pubSubKeyServiceTypeGetSecurityGroupMethod;
    }

    @Override
    @Optional
    public UaMethod getGetSecurityKeysNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "GetSecurityKeys");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract PubSubKeyServiceType.GetSecurityKeysMethodOutputs onGetSecurityKeys(ServiceContext var1, String var2, UnsignedInteger var3, UnsignedInteger var4) throws StatusException;

    @Override
    public PubSubKeyServiceType.GetSecurityKeysMethodOutputs getSecurityKeys(String string, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws StatusException {
        return this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, string, unsignedInteger, unsignedInteger2);
    }

    private PubSubKeyServiceType.GetSecurityKeysMethodOutputs a(ServiceContext serviceContext, String string, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws StatusException {
        PubSubKeyServiceTypeGetSecurityKeysMethod pubSubKeyServiceTypeGetSecurityKeysMethod = PubSubKeyServiceTypeNodeBase.getGetSecurityKeysMethodImplementation();
        if (pubSubKeyServiceTypeGetSecurityKeysMethod != null) {
            return pubSubKeyServiceTypeGetSecurityKeysMethod.getSecurityKeys(serviceContext, (PubSubKeyServiceTypeNode)this, string, unsignedInteger, unsignedInteger2);
        }
        return this.onGetSecurityKeys(serviceContext, string, unsignedInteger, unsignedInteger2);
    }

    public static PubSubKeyServiceTypeGetSecurityKeysMethod getGetSecurityKeysMethodImplementation() {
        return LV;
    }

    public static void setGetSecurityKeysMethodImplementation(PubSubKeyServiceTypeGetSecurityKeysMethod pubSubKeyServiceTypeGetSecurityKeysMethod) {
        LV = pubSubKeyServiceTypeGetSecurityKeysMethod;
    }
}

