/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ProgramDiagnostic2DataType;
import com.prosysopc.ua.types.opcua.ProgramStateMachineType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteStateVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.FiniteTransitionVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.ProgramDiagnostic2TypeNode;
import com.prosysopc.ua.types.opcua.server.ProgramStateMachineTypeHaltMethod;
import com.prosysopc.ua.types.opcua.server.ProgramStateMachineTypeNode;
import com.prosysopc.ua.types.opcua.server.ProgramStateMachineTypeResetMethod;
import com.prosysopc.ua.types.opcua.server.ProgramStateMachineTypeResumeMethod;
import com.prosysopc.ua.types.opcua.server.ProgramStateMachineTypeStartMethod;
import com.prosysopc.ua.types.opcua.server.ProgramStateMachineTypeSuspendMethod;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2391")
public abstract class ProgramStateMachineTypeNodeBase
extends FiniteStateMachineTypeNode
implements ProgramStateMachineType {
    private static GeneratedNodeInitializer<ProgramStateMachineTypeNode> Le;
    private static ProgramStateMachineTypeSuspendMethod Lf;
    private static ProgramStateMachineTypeStartMethod Lg;
    private static ProgramStateMachineTypeResetMethod Lh;
    private static ProgramStateMachineTypeHaltMethod Li;
    private static ProgramStateMachineTypeResumeMethod Lj;

    protected ProgramStateMachineTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getLastTransitionNode());
        this.callAfterCreateIfExists(this.getProgramDiagnosticNode());
        this.callAfterCreateIfExists(this.getCurrentStateNode());
        this.callAfterCreateIfExists(this.getFinalResultDataNode());
        GeneratedNodeInitializer<ProgramStateMachineTypeNode> generatedNodeInitializer = ProgramStateMachineTypeNodeBase.getProgramStateMachineTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((ProgramStateMachineTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<ProgramStateMachineTypeNode> getProgramStateMachineTypeNodeInitializer() {
        return Le;
    }

    public static void setProgramStateMachineTypeNodeInitializer(GeneratedNodeInitializer<ProgramStateMachineTypeNode> generatedNodeInitializer) {
        Le = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getDeletableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Deletable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isDeletable() {
        UaProperty uaProperty = this.getDeletableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Deletable does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setDeletable(Boolean bl) {
        UaProperty uaProperty = this.getDeletableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Deletable failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Deletable failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRecycleCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RecycleCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getRecycleCount() {
        UaProperty uaProperty = this.getRecycleCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node RecycleCount does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setRecycleCount(Integer n2) {
        UaProperty uaProperty = this.getRecycleCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RecycleCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(n2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RecycleCount failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAutoDeleteNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AutoDelete");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isAutoDelete() {
        UaProperty uaProperty = this.getAutoDeleteNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node AutoDelete does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setAutoDelete(Boolean bl) {
        UaProperty uaProperty = this.getAutoDeleteNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AutoDelete failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AutoDelete failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public FiniteTransitionVariableTypeNode getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (FiniteTransitionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getLastTransition() {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getLastTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node LastTransition does not exist");
        }
        Object object = finiteTransitionVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setLastTransition(LocalizedText localizedText) {
        FiniteTransitionVariableTypeNode finiteTransitionVariableTypeNode = this.getLastTransitionNode();
        if (finiteTransitionVariableTypeNode == null) {
            throw new RuntimeException("Setting LastTransition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteTransitionVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastTransition failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public ProgramDiagnostic2TypeNode getProgramDiagnosticNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProgramDiagnostic");
        return (ProgramDiagnostic2TypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public ProgramDiagnostic2DataType getProgramDiagnostic() {
        ProgramDiagnostic2TypeNode programDiagnostic2TypeNode = this.getProgramDiagnosticNode();
        if (programDiagnostic2TypeNode == null) {
            return null;
        }
        Object object = programDiagnostic2TypeNode.getValue().getValue().getValue();
        return (ProgramDiagnostic2DataType)object;
    }

    @Override
    @Optional
    public void setProgramDiagnostic(ProgramDiagnostic2DataType programDiagnostic2DataType) {
        ProgramDiagnostic2TypeNode programDiagnostic2TypeNode = this.getProgramDiagnosticNode();
        if (programDiagnostic2TypeNode == null) {
            throw new RuntimeException("Setting ProgramDiagnostic failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            programDiagnostic2TypeNode.setValue(programDiagnostic2DataType);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProgramDiagnostic failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public FiniteStateVariableTypeNode getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (FiniteStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        FiniteStateVariableTypeNode finiteStateVariableTypeNode = this.getCurrentStateNode();
        if (finiteStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node CurrentState does not exist");
        }
        Object object = finiteStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) {
        FiniteStateVariableTypeNode finiteStateVariableTypeNode = this.getCurrentStateNode();
        if (finiteStateVariableTypeNode == null) {
            throw new RuntimeException("Setting CurrentState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            finiteStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CurrentState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseObjectTypeNode getFinalResultDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FinalResultData");
        return (BaseObjectTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Suspend"), nodeId)) {
            this.o(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Start"), nodeId)) {
            this.p(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Reset"), nodeId)) {
            this.e(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Halt"), nodeId)) {
            this.q(serviceContext);
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Resume"), nodeId)) {
            this.r(serviceContext);
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getSuspendNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Suspend");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onSuspend(ServiceContext var1) throws StatusException;

    @Override
    public void suspend() throws StatusException {
        this.o(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void o(ServiceContext serviceContext) throws StatusException {
        ProgramStateMachineTypeSuspendMethod programStateMachineTypeSuspendMethod = ProgramStateMachineTypeNodeBase.getSuspendMethodImplementation();
        if (programStateMachineTypeSuspendMethod != null) {
            programStateMachineTypeSuspendMethod.suspend(serviceContext, (ProgramStateMachineTypeNode)this);
        } else {
            this.onSuspend(serviceContext);
        }
    }

    public static ProgramStateMachineTypeSuspendMethod getSuspendMethodImplementation() {
        return Lf;
    }

    public static void setSuspendMethodImplementation(ProgramStateMachineTypeSuspendMethod programStateMachineTypeSuspendMethod) {
        Lf = programStateMachineTypeSuspendMethod;
    }

    @Override
    @Optional
    public UaMethod getStartNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Start");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onStart(ServiceContext var1) throws StatusException;

    @Override
    public void start() throws StatusException {
        this.p(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void p(ServiceContext serviceContext) throws StatusException {
        ProgramStateMachineTypeStartMethod programStateMachineTypeStartMethod = ProgramStateMachineTypeNodeBase.getStartMethodImplementation();
        if (programStateMachineTypeStartMethod != null) {
            programStateMachineTypeStartMethod.start(serviceContext, (ProgramStateMachineTypeNode)this);
        } else {
            this.onStart(serviceContext);
        }
    }

    public static ProgramStateMachineTypeStartMethod getStartMethodImplementation() {
        return Lg;
    }

    public static void setStartMethodImplementation(ProgramStateMachineTypeStartMethod programStateMachineTypeStartMethod) {
        Lg = programStateMachineTypeStartMethod;
    }

    @Override
    @Optional
    public UaMethod getResetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Reset");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onReset(ServiceContext var1) throws StatusException;

    @Override
    public void reset() throws StatusException {
        this.e(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void e(ServiceContext serviceContext) throws StatusException {
        ProgramStateMachineTypeResetMethod programStateMachineTypeResetMethod = ProgramStateMachineTypeNodeBase.getResetMethodImplementation();
        if (programStateMachineTypeResetMethod != null) {
            programStateMachineTypeResetMethod.reset(serviceContext, (ProgramStateMachineTypeNode)this);
        } else {
            this.onReset(serviceContext);
        }
    }

    public static ProgramStateMachineTypeResetMethod getResetMethodImplementation() {
        return Lh;
    }

    public static void setResetMethodImplementation(ProgramStateMachineTypeResetMethod programStateMachineTypeResetMethod) {
        Lh = programStateMachineTypeResetMethod;
    }

    @Override
    @Optional
    public UaMethod getHaltNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Halt");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onHalt(ServiceContext var1) throws StatusException;

    @Override
    public void halt() throws StatusException {
        this.q(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void q(ServiceContext serviceContext) throws StatusException {
        ProgramStateMachineTypeHaltMethod programStateMachineTypeHaltMethod = ProgramStateMachineTypeNodeBase.getHaltMethodImplementation();
        if (programStateMachineTypeHaltMethod != null) {
            programStateMachineTypeHaltMethod.halt(serviceContext, (ProgramStateMachineTypeNode)this);
        } else {
            this.onHalt(serviceContext);
        }
    }

    public static ProgramStateMachineTypeHaltMethod getHaltMethodImplementation() {
        return Li;
    }

    public static void setHaltMethodImplementation(ProgramStateMachineTypeHaltMethod programStateMachineTypeHaltMethod) {
        Li = programStateMachineTypeHaltMethod;
    }

    @Override
    @Optional
    public UaMethod getResumeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Resume");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onResume(ServiceContext var1) throws StatusException;

    @Override
    public void resume() throws StatusException {
        this.r(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    private void r(ServiceContext serviceContext) throws StatusException {
        ProgramStateMachineTypeResumeMethod programStateMachineTypeResumeMethod = ProgramStateMachineTypeNodeBase.getResumeMethodImplementation();
        if (programStateMachineTypeResumeMethod != null) {
            programStateMachineTypeResumeMethod.resume(serviceContext, (ProgramStateMachineTypeNode)this);
        } else {
            this.onResume(serviceContext);
        }
    }

    public static ProgramStateMachineTypeResumeMethod getResumeMethodImplementation() {
        return Lj;
    }

    public static void setResumeMethodImplementation(ProgramStateMachineTypeResumeMethod programStateMachineTypeResumeMethod) {
        Lj = programStateMachineTypeResumeMethod;
    }
}

