/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.OptionSetType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.OptionSetTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11487")
public abstract class OptionSetTypeNodeBase
extends BaseDataVariableTypeNode
implements OptionSetType {
    private static GeneratedNodeInitializer<OptionSetTypeNode> KV;

    protected OptionSetTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<OptionSetTypeNode> generatedNodeInitializer = OptionSetTypeNodeBase.getOptionSetTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((OptionSetTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<OptionSetTypeNode> getOptionSetTypeNodeInitializer() {
        return KV;
    }

    public static void setOptionSetTypeNodeInitializer(GeneratedNodeInitializer<OptionSetTypeNode> generatedNodeInitializer) {
        KV = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getOptionSetValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OptionSetValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText[] getOptionSetValues() {
        UaProperty uaProperty = this.getOptionSetValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node OptionSetValues does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Mandatory
    public void setOptionSetValues(LocalizedText[] localizedTextArray) {
        UaProperty uaProperty = this.getOptionSetValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OptionSetValues failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedTextArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OptionSetValues failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getBitMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BitMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean[] isBitMask() {
        UaProperty uaProperty = this.getBitMaskNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (Boolean[])object;
    }

    @Override
    @Optional
    public void setBitMask(Boolean[] booleanArray) {
        UaProperty uaProperty = this.getBitMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BitMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(booleanArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BitMask failed unexpectedly", statusException);
        }
    }
}

