/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.NetworkGroupDataType;
import com.prosysopc.ua.types.opcua.NonTransparentNetworkRedundancyType;
import com.prosysopc.ua.types.opcua.server.NonTransparentNetworkRedundancyTypeNode;
import com.prosysopc.ua.types.opcua.server.NonTransparentRedundancyTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=11945")
public abstract class NonTransparentNetworkRedundancyTypeNodeBase
extends NonTransparentRedundancyTypeNode
implements NonTransparentNetworkRedundancyType {
    private static GeneratedNodeInitializer<NonTransparentNetworkRedundancyTypeNode> KR;

    protected NonTransparentNetworkRedundancyTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<NonTransparentNetworkRedundancyTypeNode> generatedNodeInitializer = NonTransparentNetworkRedundancyTypeNodeBase.getNonTransparentNetworkRedundancyTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((NonTransparentNetworkRedundancyTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<NonTransparentNetworkRedundancyTypeNode> getNonTransparentNetworkRedundancyTypeNodeInitializer() {
        return KR;
    }

    public static void setNonTransparentNetworkRedundancyTypeNodeInitializer(GeneratedNodeInitializer<NonTransparentNetworkRedundancyTypeNode> generatedNodeInitializer) {
        KR = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getServerNetworkGroupsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerNetworkGroups");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NetworkGroupDataType[] getServerNetworkGroups() {
        UaProperty uaProperty = this.getServerNetworkGroupsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ServerNetworkGroups does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NetworkGroupDataType[])object;
    }

    @Override
    @Mandatory
    public void setServerNetworkGroups(NetworkGroupDataType[] networkGroupDataTypeArray) {
        UaProperty uaProperty = this.getServerNetworkGroupsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerNetworkGroups failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(networkGroupDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerNetworkGroups failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

