/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ChassisIdSubtype;
import com.prosysopc.ua.stack.core.LldpManagementAddressType;
import com.prosysopc.ua.stack.core.LldpSystemCapabilitiesMap;
import com.prosysopc.ua.stack.core.LldpTlvType;
import com.prosysopc.ua.stack.core.PortIdSubtype;
import com.prosysopc.ua.types.opcua.LldpRemoteSystemType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.LldpRemoteSystemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19033")
public abstract class LldpRemoteSystemTypeNodeBase
extends BaseObjectTypeNode
implements LldpRemoteSystemType {
    private static GeneratedNodeInitializer<LldpRemoteSystemTypeNode> Kz;

    protected LldpRemoteSystemTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getRemoteIndexNode());
        this.callAfterCreateIfExists(this.getRemoteTooManyNeighborsNode());
        this.callAfterCreateIfExists(this.getSystemCapabilitiesEnabledNode());
        this.callAfterCreateIfExists(this.getSystemDescriptionNode());
        this.callAfterCreateIfExists(this.getRemoteUnknownTlvNode());
        this.callAfterCreateIfExists(this.getPortIdSubtypeNode());
        this.callAfterCreateIfExists(this.getPortDescriptionNode());
        this.callAfterCreateIfExists(this.getManagementAddressNode());
        this.callAfterCreateIfExists(this.getChassisIdSubtypeNode());
        this.callAfterCreateIfExists(this.getRemoteChangesNode());
        this.callAfterCreateIfExists(this.getTimeMarkNode());
        this.callAfterCreateIfExists(this.getPortIdNode());
        this.callAfterCreateIfExists(this.getSystemCapabilitiesSupportedNode());
        this.callAfterCreateIfExists(this.getChassisIdNode());
        this.callAfterCreateIfExists(this.getSystemNameNode());
        GeneratedNodeInitializer<LldpRemoteSystemTypeNode> generatedNodeInitializer = LldpRemoteSystemTypeNodeBase.getLldpRemoteSystemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((LldpRemoteSystemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<LldpRemoteSystemTypeNode> getLldpRemoteSystemTypeNodeInitializer() {
        return Kz;
    }

    public static void setLldpRemoteSystemTypeNodeInitializer(GeneratedNodeInitializer<LldpRemoteSystemTypeNode> generatedNodeInitializer) {
        Kz = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getRemoteIndexNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteIndex");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRemoteIndex() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteIndexNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node RemoteIndex does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRemoteIndex(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteIndexNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RemoteIndex failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemoteIndex failed unexpectedly", statusException);
        }
    }

    public void setRemoteIndex(long l2) {
        this.setRemoteIndex(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getRemoteTooManyNeighborsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteTooManyNeighbors");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isRemoteTooManyNeighbors() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteTooManyNeighborsNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setRemoteTooManyNeighbors(Boolean bl) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteTooManyNeighborsNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RemoteTooManyNeighbors failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemoteTooManyNeighbors failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getSystemCapabilitiesEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemCapabilitiesEnabled");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpSystemCapabilitiesMap getSystemCapabilitiesEnabled() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSystemCapabilitiesEnabledNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (LldpSystemCapabilitiesMap)object;
    }

    @Override
    @Optional
    public void setSystemCapabilitiesEnabled(LldpSystemCapabilitiesMap lldpSystemCapabilitiesMap) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSystemCapabilitiesEnabledNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SystemCapabilitiesEnabled failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(lldpSystemCapabilitiesMap);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemCapabilitiesEnabled failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getSystemDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemDescription");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getSystemDescription() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSystemDescriptionNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSystemDescription(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSystemDescriptionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SystemDescription failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemDescription failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getRemoteUnknownTlvNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteUnknownTlv");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpTlvType[] getRemoteUnknownTlv() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteUnknownTlvNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (LldpTlvType[])object;
    }

    @Override
    @Optional
    public void setRemoteUnknownTlv(LldpTlvType[] lldpTlvTypeArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteUnknownTlvNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RemoteUnknownTlv failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(lldpTlvTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemoteUnknownTlv failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPortIdSubtypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortIdSubtype");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public PortIdSubtype getPortIdSubtype() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPortIdSubtypeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node PortIdSubtype does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (PortIdSubtype)variant.asEnum(PortIdSubtype.class);
    }

    @Override
    @Mandatory
    public void setPortIdSubtype(PortIdSubtype portIdSubtype) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPortIdSubtypeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PortIdSubtype failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(portIdSubtype);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PortIdSubtype failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getPortDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortDescription");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getPortDescription() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPortDescriptionNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setPortDescription(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPortDescriptionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PortDescription failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PortDescription failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getManagementAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ManagementAddress");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpManagementAddressType[] getManagementAddress() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getManagementAddressNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (LldpManagementAddressType[])object;
    }

    @Override
    @Optional
    public void setManagementAddress(LldpManagementAddressType[] lldpManagementAddressTypeArray) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getManagementAddressNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ManagementAddress failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(lldpManagementAddressTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ManagementAddress failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getChassisIdSubtypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChassisIdSubtype");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ChassisIdSubtype getChassisIdSubtype() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getChassisIdSubtypeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ChassisIdSubtype does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (ChassisIdSubtype)variant.asEnum(ChassisIdSubtype.class);
    }

    @Override
    @Mandatory
    public void setChassisIdSubtype(ChassisIdSubtype chassisIdSubtype) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getChassisIdSubtypeNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ChassisIdSubtype failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(chassisIdSubtype);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ChassisIdSubtype failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getRemoteChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RemoteChanges");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public Boolean isRemoteChanges() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteChangesNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Optional
    public void setRemoteChanges(Boolean bl) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getRemoteChangesNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting RemoteChanges failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(bl);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RemoteChanges failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getTimeMarkNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TimeMark");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTimeMark() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTimeMarkNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node TimeMark does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTimeMark(UnsignedInteger unsignedInteger) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getTimeMarkNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting TimeMark failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TimeMark failed unexpectedly", statusException);
        }
    }

    public void setTimeMark(long l2) {
        this.setTimeMark(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getPortIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PortId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getPortId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPortIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node PortId does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setPortId(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPortIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PortId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PortId failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getSystemCapabilitiesSupportedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemCapabilitiesSupported");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LldpSystemCapabilitiesMap getSystemCapabilitiesSupported() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSystemCapabilitiesSupportedNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (LldpSystemCapabilitiesMap)object;
    }

    @Override
    @Optional
    public void setSystemCapabilitiesSupported(LldpSystemCapabilitiesMap lldpSystemCapabilitiesMap) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSystemCapabilitiesSupportedNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SystemCapabilitiesSupported failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(lldpSystemCapabilitiesMap);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemCapabilitiesSupported failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getChassisIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChassisId");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getChassisId() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getChassisIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ChassisId does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setChassisId(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getChassisIdNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ChassisId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ChassisId failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getSystemNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getSystemName() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSystemNameNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setSystemName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSystemNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SystemName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemName failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

