/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ChassisIdSubtype;
import com.prosysopc.ua.stack.core.LldpSystemCapabilitiesMap;
import com.prosysopc.ua.types.opcua.LldpLocalSystemType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.LldpLocalSystemTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=19002")
public abstract class LldpLocalSystemTypeNodeBase
extends BaseObjectTypeNode
implements LldpLocalSystemType {
    private static GeneratedNodeInitializer<LldpLocalSystemTypeNode> Kw;

    protected LldpLocalSystemTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<LldpLocalSystemTypeNode> generatedNodeInitializer = LldpLocalSystemTypeNodeBase.getLldpLocalSystemTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((LldpLocalSystemTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<LldpLocalSystemTypeNode> getLldpLocalSystemTypeNodeInitializer() {
        return Kw;
    }

    public static void setLldpLocalSystemTypeNodeInitializer(GeneratedNodeInitializer<LldpLocalSystemTypeNode> generatedNodeInitializer) {
        Kw = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getChassisIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChassisId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getChassisId() {
        UaProperty uaProperty = this.getChassisIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ChassisId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setChassisId(String string) {
        UaProperty uaProperty = this.getChassisIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ChassisId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ChassisId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getChassisIdSubtypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ChassisIdSubtype");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ChassisIdSubtype getChassisIdSubtype() {
        UaProperty uaProperty = this.getChassisIdSubtypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node ChassisIdSubtype does not exist");
        }
        Variant variant = uaProperty.getValue().getValue();
        return (ChassisIdSubtype)variant.asEnum(ChassisIdSubtype.class);
    }

    @Override
    @Mandatory
    public void setChassisIdSubtype(ChassisIdSubtype chassisIdSubtype) {
        UaProperty uaProperty = this.getChassisIdSubtypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ChassisIdSubtype failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(chassisIdSubtype);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ChassisIdSubtype failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSystemDescriptionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemDescription");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSystemDescription() {
        UaProperty uaProperty = this.getSystemDescriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SystemDescription does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSystemDescription(String string) {
        UaProperty uaProperty = this.getSystemDescriptionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemDescription failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemDescription failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSystemNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSystemName() {
        UaProperty uaProperty = this.getSystemNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node SystemName does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSystemName(String string) {
        UaProperty uaProperty = this.getSystemNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemName failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSystemCapabilitiesEnabledNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemCapabilitiesEnabled");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LldpSystemCapabilitiesMap getSystemCapabilitiesEnabled() {
        UaProperty uaProperty = this.getSystemCapabilitiesEnabledNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LldpSystemCapabilitiesMap)object;
    }

    @Override
    @Optional
    public void setSystemCapabilitiesEnabled(LldpSystemCapabilitiesMap lldpSystemCapabilitiesMap) {
        UaProperty uaProperty = this.getSystemCapabilitiesEnabledNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemCapabilitiesEnabled failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(lldpSystemCapabilitiesMap);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemCapabilitiesEnabled failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getSystemCapabilitiesSupportedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemCapabilitiesSupported");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LldpSystemCapabilitiesMap getSystemCapabilitiesSupported() {
        UaProperty uaProperty = this.getSystemCapabilitiesSupportedNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (LldpSystemCapabilitiesMap)object;
    }

    @Override
    @Optional
    public void setSystemCapabilitiesSupported(LldpSystemCapabilitiesMap lldpSystemCapabilitiesMap) {
        UaProperty uaProperty = this.getSystemCapabilitiesSupportedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemCapabilitiesSupported failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(lldpSystemCapabilitiesMap);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SystemCapabilitiesSupported failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

