/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.InterfaceAdminStatus;
import com.prosysopc.ua.stack.core.InterfaceOperStatus;
import com.prosysopc.ua.types.opcua.IIetfBaseNetworkInterfaceType;
import com.prosysopc.ua.types.opcua.server.AnalogUnitTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BaseInterfaceTypeNode;
import com.prosysopc.ua.types.opcua.server.IIetfBaseNetworkInterfaceTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=24148")
public abstract class IIetfBaseNetworkInterfaceTypeNodeBase
extends BaseInterfaceTypeNode
implements IIetfBaseNetworkInterfaceType {
    private static GeneratedNodeInitializer<IIetfBaseNetworkInterfaceTypeNode> JY;

    protected IIetfBaseNetworkInterfaceTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getPhysAddressNode());
        this.callAfterCreateIfExists(this.getSpeedNode());
        this.callAfterCreateIfExists(this.getAdminStatusNode());
        this.callAfterCreateIfExists(this.getOperStatusNode());
        GeneratedNodeInitializer<IIetfBaseNetworkInterfaceTypeNode> generatedNodeInitializer = IIetfBaseNetworkInterfaceTypeNodeBase.getIIetfBaseNetworkInterfaceTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((IIetfBaseNetworkInterfaceTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<IIetfBaseNetworkInterfaceTypeNode> getIIetfBaseNetworkInterfaceTypeNodeInitializer() {
        return JY;
    }

    public static void setIIetfBaseNetworkInterfaceTypeNodeInitializer(GeneratedNodeInitializer<IIetfBaseNetworkInterfaceTypeNode> generatedNodeInitializer) {
        JY = generatedNodeInitializer;
    }

    @Override
    @Optional
    public BaseDataVariableTypeNode getPhysAddressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "PhysAddress");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public String getPhysAddress() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPhysAddressNode();
        if (baseDataVariableTypeNode == null) {
            return null;
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setPhysAddress(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getPhysAddressNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting PhysAddress failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting PhysAddress failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public AnalogUnitTypeNode getSpeedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Speed");
        return (AnalogUnitTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedLong getSpeed() {
        AnalogUnitTypeNode analogUnitTypeNode = this.getSpeedNode();
        if (analogUnitTypeNode == null) {
            throw new RuntimeException("Mandatory node Speed does not exist");
        }
        Object object = analogUnitTypeNode.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Mandatory
    public void setSpeed(UnsignedLong unsignedLong) {
        AnalogUnitTypeNode analogUnitTypeNode = this.getSpeedNode();
        if (analogUnitTypeNode == null) {
            throw new RuntimeException("Setting Speed failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            analogUnitTypeNode.setValue(unsignedLong);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Speed failed unexpectedly", statusException);
        }
    }

    public void setSpeed(long l2) {
        this.setSpeed(UnsignedLong.valueOf(l2));
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getAdminStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AdminStatus");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public InterfaceAdminStatus getAdminStatus() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAdminStatusNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node AdminStatus does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (InterfaceAdminStatus)variant.asEnum(InterfaceAdminStatus.class);
    }

    @Override
    @Mandatory
    public void setAdminStatus(InterfaceAdminStatus interfaceAdminStatus) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getAdminStatusNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting AdminStatus failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(interfaceAdminStatus);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AdminStatus failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getOperStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OperStatus");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public InterfaceOperStatus getOperStatus() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getOperStatusNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node OperStatus does not exist");
        }
        Variant variant = baseDataVariableTypeNode.getValue().getValue();
        return (InterfaceOperStatus)variant.asEnum(InterfaceOperStatus.class);
    }

    @Override
    @Mandatory
    public void setOperStatus(InterfaceOperStatus interfaceOperStatus) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getOperStatusNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting OperStatus failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(interfaceOperStatus);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OperStatus failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

