/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.ModelChangeStructureDataType;
import com.prosysopc.ua.types.opcua.GeneralModelChangeEventType;
import com.prosysopc.ua.types.opcua.server.BaseModelChangeEventTypeNode;
import com.prosysopc.ua.types.opcua.server.GeneralModelChangeEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2133")
public abstract class GeneralModelChangeEventTypeNodeBase
extends BaseModelChangeEventTypeNode
implements GeneralModelChangeEventType {
    private static GeneratedNodeInitializer<GeneralModelChangeEventTypeNode> JF;

    protected GeneralModelChangeEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<GeneralModelChangeEventTypeNode> generatedNodeInitializer = GeneralModelChangeEventTypeNodeBase.getGeneralModelChangeEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((GeneralModelChangeEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<GeneralModelChangeEventTypeNode> getGeneralModelChangeEventTypeNodeInitializer() {
        return JF;
    }

    public static void setGeneralModelChangeEventTypeNodeInitializer(GeneratedNodeInitializer<GeneralModelChangeEventTypeNode> generatedNodeInitializer) {
        JF = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getChangesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Changes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ModelChangeStructureDataType[] getChanges() {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node Changes does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ModelChangeStructureDataType[])object;
    }

    @Override
    @Mandatory
    public void setChanges(ModelChangeStructureDataType[] modelChangeStructureDataTypeArray) {
        UaProperty uaProperty = this.getChangesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Changes failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(modelChangeStructureDataTypeArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Changes failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

