/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.DataSetFieldContentMask;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.types.opcua.DataSetWriterType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import com.prosysopc.ua.types.opcua.server.DataSetWriterMessageTypeNode;
import com.prosysopc.ua.types.opcua.server.DataSetWriterTransportTypeNode;
import com.prosysopc.ua.types.opcua.server.DataSetWriterTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubDiagnosticsDataSetWriterTypeNode;
import com.prosysopc.ua.types.opcua.server.PubSubStatusTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=15298")
public abstract class DataSetWriterTypeNodeBase
extends BaseObjectTypeNode
implements DataSetWriterType {
    private static GeneratedNodeInitializer<DataSetWriterTypeNode> Iu;

    protected DataSetWriterTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getMessageSettingsNode());
        this.callAfterCreateIfExists(this.getStatusNode());
        this.callAfterCreateIfExists(this.getTransportSettingsNode());
        this.callAfterCreateIfExists(this.getDiagnosticsNode());
        GeneratedNodeInitializer<DataSetWriterTypeNode> generatedNodeInitializer = DataSetWriterTypeNodeBase.getDataSetWriterTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((DataSetWriterTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<DataSetWriterTypeNode> getDataSetWriterTypeNodeInitializer() {
        return Iu;
    }

    public static void setDataSetWriterTypeNodeInitializer(GeneratedNodeInitializer<DataSetWriterTypeNode> generatedNodeInitializer) {
        Iu = generatedNodeInitializer;
    }

    @Override
    @Optional
    public UaProperty getKeyFrameCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "KeyFrameCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getKeyFrameCount() {
        UaProperty uaProperty = this.getKeyFrameCountNode();
        if (uaProperty == null) {
            return null;
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setKeyFrameCount(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getKeyFrameCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting KeyFrameCount failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting KeyFrameCount failed unexpectedly", statusException);
        }
    }

    public void setKeyFrameCount(long l2) {
        this.setKeyFrameCount(UnsignedInteger.valueOf(l2));
    }

    @Override
    @Mandatory
    public UaProperty getDataSetFieldContentMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetFieldContentMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DataSetFieldContentMask getDataSetFieldContentMask() {
        UaProperty uaProperty = this.getDataSetFieldContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetFieldContentMask does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (DataSetFieldContentMask)object;
    }

    @Override
    @Mandatory
    public void setDataSetFieldContentMask(DataSetFieldContentMask dataSetFieldContentMask) {
        UaProperty uaProperty = this.getDataSetFieldContentMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetFieldContentMask failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dataSetFieldContentMask);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetFieldContentMask failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getDataSetWriterIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetWriterId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getDataSetWriterId() {
        UaProperty uaProperty = this.getDataSetWriterIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetWriterId does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setDataSetWriterId(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getDataSetWriterIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetWriterId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetWriterId failed unexpectedly", statusException);
        }
    }

    public void setDataSetWriterId(int n2) {
        this.setDataSetWriterId(UnsignedShort.valueOf(n2));
    }

    @Override
    @Mandatory
    public UaProperty getDataSetWriterPropertiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataSetWriterProperties");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public KeyValuePair[] getDataSetWriterProperties() {
        UaProperty uaProperty = this.getDataSetWriterPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node DataSetWriterProperties does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (KeyValuePair[])object;
    }

    @Override
    @Mandatory
    public void setDataSetWriterProperties(KeyValuePair[] keyValuePairArray) {
        UaProperty uaProperty = this.getDataSetWriterPropertiesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataSetWriterProperties failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(keyValuePairArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting DataSetWriterProperties failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public DataSetWriterMessageTypeNode getMessageSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MessageSettings");
        return (DataSetWriterMessageTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public PubSubStatusTypeNode getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return (PubSubStatusTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public DataSetWriterTransportTypeNode getTransportSettingsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransportSettings");
        return (DataSetWriterTransportTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public PubSubDiagnosticsDataSetWriterTypeNode getDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Diagnostics");
        return (PubSubDiagnosticsDataSetWriterTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

