/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.CertificateUpdatedAuditEventType;
import com.prosysopc.ua.types.opcua.server.AuditUpdateMethodEventTypeNode;
import com.prosysopc.ua.types.opcua.server.CertificateUpdatedAuditEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=12620")
public abstract class CertificateUpdatedAuditEventTypeNodeBase
extends AuditUpdateMethodEventTypeNode
implements CertificateUpdatedAuditEventType {
    private static GeneratedNodeInitializer<CertificateUpdatedAuditEventTypeNode> HU;

    protected CertificateUpdatedAuditEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<CertificateUpdatedAuditEventTypeNode> generatedNodeInitializer = CertificateUpdatedAuditEventTypeNodeBase.getCertificateUpdatedAuditEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((CertificateUpdatedAuditEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<CertificateUpdatedAuditEventTypeNode> getCertificateUpdatedAuditEventTypeNodeInitializer() {
        return HU;
    }

    public static void setCertificateUpdatedAuditEventTypeNodeInitializer(GeneratedNodeInitializer<CertificateUpdatedAuditEventTypeNode> generatedNodeInitializer) {
        HU = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getCertificateTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getCertificateType() {
        UaProperty uaProperty = this.getCertificateTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node CertificateType does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setCertificateType(NodeId nodeId) {
        UaProperty uaProperty = this.getCertificateTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CertificateType failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getCertificateGroupNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CertificateGroup");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getCertificateGroup() {
        UaProperty uaProperty = this.getCertificateGroupNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node CertificateGroup does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setCertificateGroup(NodeId nodeId) {
        UaProperty uaProperty = this.getCertificateGroupNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CertificateGroup failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting CertificateGroup failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

