/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.types.opcua.BuildInfoType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.BuildInfoTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=3051")
public abstract class BuildInfoTypeNodeBase
extends BaseDataVariableTypeNode
implements BuildInfoType {
    private static GeneratedNodeInitializer<BuildInfoTypeNode> HM;

    protected BuildInfoTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getProductNameNode());
        this.callAfterCreateIfExists(this.getManufacturerNameNode());
        this.callAfterCreateIfExists(this.getBuildNumberNode());
        this.callAfterCreateIfExists(this.getSoftwareVersionNode());
        this.callAfterCreateIfExists(this.getBuildDateNode());
        this.callAfterCreateIfExists(this.getProductUriNode());
        GeneratedNodeInitializer<BuildInfoTypeNode> generatedNodeInitializer = BuildInfoTypeNodeBase.getBuildInfoTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((BuildInfoTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<BuildInfoTypeNode> getBuildInfoTypeNodeInitializer() {
        return HM;
    }

    public static void setBuildInfoTypeNodeInitializer(GeneratedNodeInitializer<BuildInfoTypeNode> generatedNodeInitializer) {
        HM = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getProductNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductName() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getProductNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ProductName does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getProductNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ProductName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProductName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getManufacturerNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ManufacturerName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getManufacturerName() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getManufacturerNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ManufacturerName does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setManufacturerName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getManufacturerNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ManufacturerName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ManufacturerName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBuildNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildNumber");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getBuildNumber() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBuildNumberNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node BuildNumber does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setBuildNumber(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBuildNumberNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BuildNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BuildNumber failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSoftwareVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SoftwareVersion");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSoftwareVersion() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSoftwareVersionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node SoftwareVersion does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSoftwareVersion(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSoftwareVersionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SoftwareVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SoftwareVersion failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBuildDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildDate");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getBuildDate() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBuildDateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node BuildDate does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setBuildDate(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBuildDateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BuildDate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BuildDate failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getProductUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductUri");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductUri() {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getProductUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node ProductUri does not exist");
        }
        Object object = baseDataVariableTypeNode.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductUri(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getProductUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ProductUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProductUri failed unexpectedly", statusException);
        }
    }
}

