/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditUrlMismatchEventType;
import com.prosysopc.ua.types.opcua.server.AuditCreateSessionEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditUrlMismatchEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2748")
public abstract class AuditUrlMismatchEventTypeNodeBase
extends AuditCreateSessionEventTypeNode
implements AuditUrlMismatchEventType {
    private static GeneratedNodeInitializer<AuditUrlMismatchEventTypeNode> Hq;

    protected AuditUrlMismatchEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditUrlMismatchEventTypeNode> generatedNodeInitializer = AuditUrlMismatchEventTypeNodeBase.getAuditUrlMismatchEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditUrlMismatchEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditUrlMismatchEventTypeNode> getAuditUrlMismatchEventTypeNodeInitializer() {
        return Hq;
    }

    public static void setAuditUrlMismatchEventTypeNodeInitializer(GeneratedNodeInitializer<AuditUrlMismatchEventTypeNode> generatedNodeInitializer) {
        Hq = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEndpointUrlNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EndpointUrl");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getEndpointUrl() {
        UaProperty uaProperty = this.getEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EndpointUrl does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setEndpointUrl(String string) {
        UaProperty uaProperty = this.getEndpointUrlNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EndpointUrl failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EndpointUrl failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

