/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.HistoryEventFieldList;
import com.prosysopc.ua.types.opcua.AuditHistoryEventDeleteEventType;
import com.prosysopc.ua.types.opcua.server.AuditHistoryDeleteEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditHistoryEventDeleteEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=3022")
public abstract class AuditHistoryEventDeleteEventTypeNodeBase
extends AuditHistoryDeleteEventTypeNode
implements AuditHistoryEventDeleteEventType {
    private static GeneratedNodeInitializer<AuditHistoryEventDeleteEventTypeNode> Hd;

    protected AuditHistoryEventDeleteEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditHistoryEventDeleteEventTypeNode> generatedNodeInitializer = AuditHistoryEventDeleteEventTypeNodeBase.getAuditHistoryEventDeleteEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditHistoryEventDeleteEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditHistoryEventDeleteEventTypeNode> getAuditHistoryEventDeleteEventTypeNodeInitializer() {
        return Hd;
    }

    public static void setAuditHistoryEventDeleteEventTypeNodeInitializer(GeneratedNodeInitializer<AuditHistoryEventDeleteEventTypeNode> generatedNodeInitializer) {
        Hd = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getEventIdsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventIds");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ByteString[] getEventIds() {
        UaProperty uaProperty = this.getEventIdsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node EventIds does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (ByteString[])object;
    }

    @Override
    @Mandatory
    public void setEventIds(ByteString[] byteStringArray) {
        UaProperty uaProperty = this.getEventIdsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EventIds failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byteStringArray);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EventIds failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getOldValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OldValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public HistoryEventFieldList getOldValues() {
        UaProperty uaProperty = this.getOldValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node OldValues does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (HistoryEventFieldList)object;
    }

    @Override
    @Mandatory
    public void setOldValues(HistoryEventFieldList historyEventFieldList) {
        UaProperty uaProperty = this.getOldValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OldValues failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(historyEventFieldList);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting OldValues failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

