/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AuditHistoryDeleteEventType;
import com.prosysopc.ua.types.opcua.server.AuditHistoryDeleteEventTypeNode;
import com.prosysopc.ua.types.opcua.server.AuditHistoryUpdateEventTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=3012")
public abstract class AuditHistoryDeleteEventTypeNodeBase
extends AuditHistoryUpdateEventTypeNode
implements AuditHistoryDeleteEventType {
    private static GeneratedNodeInitializer<AuditHistoryDeleteEventTypeNode> Hc;

    protected AuditHistoryDeleteEventTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        GeneratedNodeInitializer<AuditHistoryDeleteEventTypeNode> generatedNodeInitializer = AuditHistoryDeleteEventTypeNodeBase.getAuditHistoryDeleteEventTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AuditHistoryDeleteEventTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AuditHistoryDeleteEventTypeNode> getAuditHistoryDeleteEventTypeNodeInitializer() {
        return Hc;
    }

    public static void setAuditHistoryDeleteEventTypeNodeInitializer(GeneratedNodeInitializer<AuditHistoryDeleteEventTypeNode> generatedNodeInitializer) {
        Hc = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public UaProperty getUpdatedNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdatedNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getUpdatedNode() {
        UaProperty uaProperty = this.getUpdatedNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Mandatory node UpdatedNode does not exist");
        }
        Object object = uaProperty.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setUpdatedNode(NodeId nodeId) {
        UaProperty uaProperty = this.getUpdatedNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdatedNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UpdatedNode failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }
}

