/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.GeneratedNodeInitializer;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.types.opcua.AcknowledgeableConditionType;
import com.prosysopc.ua.types.opcua.server.AcknowledgeableConditionTypeAcknowledgeMethod;
import com.prosysopc.ua.types.opcua.server.AcknowledgeableConditionTypeConfirmMethod;
import com.prosysopc.ua.types.opcua.server.AcknowledgeableConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2881")
public abstract class AcknowledgeableConditionTypeNodeBase
extends ConditionTypeNode
implements AcknowledgeableConditionType {
    private static GeneratedNodeInitializer<AcknowledgeableConditionTypeNode> FI;
    private static AcknowledgeableConditionTypeConfirmMethod FJ;
    private static AcknowledgeableConditionTypeAcknowledgeMethod FK;

    protected AcknowledgeableConditionTypeNodeBase(UaNode.Parameters parameters) {
        super(parameters);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getEnabledStateNode());
        this.callAfterCreateIfExists(this.getAckedStateNode());
        this.callAfterCreateIfExists(this.getConfirmedStateNode());
        GeneratedNodeInitializer<AcknowledgeableConditionTypeNode> generatedNodeInitializer = AcknowledgeableConditionTypeNodeBase.getAcknowledgeableConditionTypeNodeInitializer();
        if (generatedNodeInitializer != null) {
            generatedNodeInitializer.init((AcknowledgeableConditionTypeNode)this);
        }
    }

    public static GeneratedNodeInitializer<AcknowledgeableConditionTypeNode> getAcknowledgeableConditionTypeNodeInitializer() {
        return FI;
    }

    public static void setAcknowledgeableConditionTypeNodeInitializer(GeneratedNodeInitializer<AcknowledgeableConditionTypeNode> generatedNodeInitializer) {
        FI = generatedNodeInitializer;
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node EnabledState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting EnabledState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getAckedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AckedState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getAckedState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getAckedStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Mandatory node AckedState does not exist");
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setAckedState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getAckedStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting AckedState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AckedState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getConfirmedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfirmedState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getConfirmedState() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getConfirmedStateNode();
        if (twoStateVariableTypeNode == null) {
            return null;
        }
        Object object = twoStateVariableTypeNode.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setConfirmedState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getConfirmedStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting ConfirmedState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConfirmedState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Confirm"), nodeId)) {
            this.a(serviceContext, (ByteString)variantArray[0].getValue(), (LocalizedText)variantArray[1].getValue());
            return null;
        }
        if (this.isComponentMatch(this.getQualifiedName("http://opcfoundation.org/UA/", "Acknowledge"), nodeId)) {
            this.b(serviceContext, (ByteString)variantArray[0].getValue(), (LocalizedText)variantArray[1].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    @Optional
    public UaMethod getConfirmNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Confirm");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onConfirm(ServiceContext var1, ByteString var2, LocalizedText var3) throws StatusException;

    @Override
    public void confirm(ByteString byteString, LocalizedText localizedText) throws StatusException {
        this.a(ServiceContext.INTERNAL_OPERATION_CONTEXT, byteString, localizedText);
    }

    private void a(ServiceContext serviceContext, ByteString byteString, LocalizedText localizedText) throws StatusException {
        AcknowledgeableConditionTypeConfirmMethod acknowledgeableConditionTypeConfirmMethod = AcknowledgeableConditionTypeNodeBase.getConfirmMethodImplementation();
        if (acknowledgeableConditionTypeConfirmMethod != null) {
            acknowledgeableConditionTypeConfirmMethod.confirm(serviceContext, (AcknowledgeableConditionTypeNode)this, byteString, localizedText);
        } else {
            this.onConfirm(serviceContext, byteString, localizedText);
        }
    }

    public static AcknowledgeableConditionTypeConfirmMethod getConfirmMethodImplementation() {
        return FJ;
    }

    public static void setConfirmMethodImplementation(AcknowledgeableConditionTypeConfirmMethod acknowledgeableConditionTypeConfirmMethod) {
        FJ = acknowledgeableConditionTypeConfirmMethod;
    }

    @Override
    @Mandatory
    public UaMethod getAcknowledgeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Acknowledge");
        return (UaMethod)this.getComponent(qualifiedName);
    }

    protected abstract void onAcknowledge(ServiceContext var1, ByteString var2, LocalizedText var3) throws StatusException;

    @Override
    public void acknowledge(ByteString byteString, LocalizedText localizedText) throws StatusException {
        this.b(ServiceContext.INTERNAL_OPERATION_CONTEXT, byteString, localizedText);
    }

    private void b(ServiceContext serviceContext, ByteString byteString, LocalizedText localizedText) throws StatusException {
        AcknowledgeableConditionTypeAcknowledgeMethod acknowledgeableConditionTypeAcknowledgeMethod = AcknowledgeableConditionTypeNodeBase.getAcknowledgeMethodImplementation();
        if (acknowledgeableConditionTypeAcknowledgeMethod != null) {
            acknowledgeableConditionTypeAcknowledgeMethod.acknowledge(serviceContext, (AcknowledgeableConditionTypeNode)this, byteString, localizedText);
        } else {
            this.onAcknowledge(serviceContext, byteString, localizedText);
        }
    }

    public static AcknowledgeableConditionTypeAcknowledgeMethod getAcknowledgeMethodImplementation() {
        return FK;
    }

    public static void setAcknowledgeMethodImplementation(AcknowledgeableConditionTypeAcknowledgeMethod acknowledgeableConditionTypeAcknowledgeMethod) {
        FK = acknowledgeableConditionTypeAcknowledgeMethod;
    }
}

